/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.WsMemberFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetSubjectsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGetSubjectsRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcGetSubjects {
    private Set<WsSubjectLookup> wsSubjectLookups = new LinkedHashSet<WsSubjectLookup>();
    private String clientVersion;
    private String searchString;
    private WsGroupLookup wsGroupLookup;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsMemberFilter memberFilter;
    private WsSubjectLookup actAsSubject;
    private String fieldName;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private Set<String> sourceIds = null;

    public GcGetSubjects assignSearchString(String theSearchString) {
        this.searchString = theSearchString;
        return this;
    }

    public GcGetSubjects assignGroupLookup(WsGroupLookup theGroupLookup) {
        this.wsGroupLookup = theGroupLookup;
        return this;
    }

    public GcGetSubjects assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcGetSubjects addWsSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.wsSubjectLookups.add(wsSubjectLookup);
        return this;
    }

    public GcGetSubjects addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGetSubjects addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGetSubjects assignMemberFilter(WsMemberFilter theMemberFilter) {
        this.memberFilter = theMemberFilter;
        return this;
    }

    public GcGetSubjects assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.isBlank(this.searchString) && GrouperClientUtils.length(this.wsSubjectLookups) == 0) {
            throw new RuntimeException("Search string or subject lookup is required: " + this);
        }
    }

    public GcGetSubjects assignFieldName(String theFieldName) {
        this.fieldName = theFieldName;
        return this;
    }

    public GcGetSubjects addSourceId(String sourceId) {
        if (this.sourceIds == null) {
            this.sourceIds = new LinkedHashSet<String>();
        }
        this.sourceIds.add(sourceId);
        return this;
    }

    public GcGetSubjects addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcGetSubjects assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcGetSubjects assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public WsGetSubjectsResults execute() {
        this.validate();
        WsGetSubjectsResults wsGetSubjectsResults = null;
        try {
            WsRestGetSubjectsRequest getSubjects = new WsRestGetSubjectsRequest();
            getSubjects.setActAsSubjectLookup(this.actAsSubject);
            getSubjects.setFieldName(this.fieldName);
            getSubjects.setWsGroupLookup(this.wsGroupLookup);
            if (this.includeGroupDetail != null) {
                getSubjects.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                getSubjects.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            getSubjects.setSearchString(this.searchString);
            getSubjects.setMemberFilter(this.memberFilter == null ? null : this.memberFilter.name());
            if (this.params.size() > 0) {
                getSubjects.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            if (GrouperClientUtils.length(this.sourceIds) > 0) {
                getSubjects.setSourceIds(GrouperClientUtils.toArray(this.sourceIds, String.class));
            }
            if (this.subjectAttributeNames.size() > 0) {
                getSubjects.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            if (GrouperClientUtils.length(this.wsSubjectLookups) > 0) {
                getSubjects.setWsSubjectLookups(GrouperClientUtils.toArray(this.wsSubjectLookups, WsSubjectLookup.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsGetSubjectsResults = (WsGetSubjectsResults)grouperClientWs.executeService("subjects", getSubjects, "getSubjects", this.clientVersion);
            String resultMessage = wsGetSubjectsResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsGetSubjectsResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGetSubjectsResults;
    }
}

