/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key;

import de.schlichtherle.key.AbstractKeyProvider;
import de.schlichtherle.key.KeyProvider;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class KeyManager {
    private static volatile KeyManager keyManager;
    private static final Map providers;
    private final Map providerTypes = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized KeyManager getInstance() {
        if (keyManager != null) {
            return keyManager;
        }
        String cn = System.getProperty("de.schlichtherle.key.KeyManager", KeyManager.getDefaultKeyManagerClassName());
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(cn);
            keyManager = (KeyManager)c.newInstance();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UndeclaredThrowableException(ex);
        }
        return keyManager;
    }

    private static String getDefaultKeyManagerClassName() {
        if (GraphicsEnvironment.isHeadless()) {
            try {
                Class.forName("java.io.Console");
                return "de.schlichtherle.key.passwd.console.PromptingKeyManager";
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return "de.schlichtherle.key.passwd.swing.PromptingKeyManager";
    }

    public static void setInstance(KeyManager keyManager) {
        KeyManager.keyManager = keyManager;
    }

    static final synchronized KeyProvider mapKeyProvider(String resourceID, KeyProvider provider) throws NullPointerException {
        if (resourceID == null || provider == null) {
            throw new NullPointerException();
        }
        return providers.put(resourceID, provider);
    }

    static final synchronized KeyProvider unmapKeyProvider(String resourceID) throws NullPointerException {
        if (resourceID == null) {
            throw new NullPointerException();
        }
        return (KeyProvider)providers.remove(resourceID);
    }

    public static synchronized boolean resetKeyProvider(String resourceID) {
        KeyProvider provider = (KeyProvider)providers.get(resourceID);
        if (provider instanceof AbstractKeyProvider) {
            AbstractKeyProvider skp = (AbstractKeyProvider)provider;
            skp.reset();
            return true;
        }
        return false;
    }

    public static synchronized boolean resetAndRemoveKeyProvider(String resourceID) {
        KeyProvider provider = (KeyProvider)providers.get(resourceID);
        if (provider instanceof AbstractKeyProvider) {
            AbstractKeyProvider skp = (AbstractKeyProvider)provider;
            skp.reset();
            KeyProvider result = skp.removeFromKeyManager(resourceID);
            if (!$assertionsDisabled && provider != result) {
                throw new AssertionError();
            }
            return true;
        }
        if (provider != null) {
            KeyProvider previous = KeyManager.unmapKeyProvider(resourceID);
            if (!$assertionsDisabled && provider != previous) {
                throw new AssertionError();
            }
            return true;
        }
        return false;
    }

    public static void resetKeyProviders() {
        KeyManager.forEachKeyProvider(new KeyProviderCommand(){

            public void run(String resourceID, KeyProvider provider) {
                if (provider instanceof AbstractKeyProvider) {
                    ((AbstractKeyProvider)provider).reset();
                }
            }
        });
    }

    public static final void resetAndClearKeyProviders() {
        KeyManager.resetAndRemoveKeyProviders();
    }

    public static synchronized void resetAndRemoveKeyProviders() {
        class ResetAndRemoveKeyProvider
        implements KeyProviderCommand {
            IllegalStateException ise = null;
            static final /* synthetic */ boolean $assertionsDisabled;

            ResetAndRemoveKeyProvider() {
            }

            public void run(String resourceID, KeyProvider provider) {
                if (provider instanceof AbstractKeyProvider) {
                    AbstractKeyProvider skp = (AbstractKeyProvider)provider;
                    skp.reset();
                    try {
                        skp.removeFromKeyManager(resourceID);
                    }
                    catch (IllegalStateException exc) {
                        this.ise = exc;
                    }
                } else {
                    KeyProvider previous = KeyManager.unmapKeyProvider(resourceID);
                    if (!$assertionsDisabled && provider != previous) {
                        throw new AssertionError();
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$de$schlichtherle$key$KeyManager == null ? (class$de$schlichtherle$key$KeyManager = KeyManager.class$("de.schlichtherle.key.KeyManager")) : class$de$schlichtherle$key$KeyManager).desiredAssertionStatus();
            }
        }
        ResetAndRemoveKeyProvider cmd = new ResetAndRemoveKeyProvider();
        KeyManager.forEachKeyProvider(cmd);
        if (cmd.ise != null) {
            throw cmd.ise;
        }
    }

    protected static synchronized void forEachKeyProvider(KeyProviderCommand command) {
        Set entrySet = providers.entrySet();
        int n = entrySet.size();
        Map.Entry[] entries = entrySet.toArray(new Map.Entry[n]);
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = entries[i];
            String resourceID = (String)entry.getKey();
            KeyProvider provider = (KeyProvider)entry.getValue();
            command.run(resourceID, provider);
        }
    }

    public static synchronized boolean moveKeyProvider(String oldResourceID, String newResourceID) throws NullPointerException, IllegalStateException {
        if (oldResourceID == null || newResourceID == null) {
            throw new NullPointerException();
        }
        KeyProvider provider = (KeyProvider)providers.get(oldResourceID);
        if (provider == null) {
            return false;
        }
        if (provider instanceof AbstractKeyProvider) {
            AbstractKeyProvider skp = (AbstractKeyProvider)provider;
            skp.removeFromKeyManager(oldResourceID);
            try {
                skp.addToKeyManager(newResourceID);
            }
            catch (RuntimeException failure) {
                skp.addToKeyManager(oldResourceID);
                throw failure;
            }
        } else {
            KeyManager.unmapKeyProvider(oldResourceID);
            KeyManager.mapKeyProvider(newResourceID, provider);
        }
        return true;
    }

    protected final synchronized void mapKeyProviderType(Class forKeyProviderType, Class useKeyProviderType) {
        if (!KeyProvider.class.isAssignableFrom(forKeyProviderType) || !forKeyProviderType.isAssignableFrom(useKeyProviderType) || forKeyProviderType == useKeyProviderType) {
            throw new IllegalArgumentException(useKeyProviderType.getName() + " must be a subclass or implementation of " + forKeyProviderType.getName() + "!");
        }
        try {
            useKeyProviderType.getConstructor(null);
        }
        catch (NoSuchMethodException noPublicNullaryConstructor) {
            IllegalArgumentException iae = new IllegalArgumentException(useKeyProviderType.getName() + " (no public nullary constructor)");
            iae.initCause(noPublicNullaryConstructor);
            throw iae;
        }
        this.providerTypes.put(forKeyProviderType, useKeyProviderType);
    }

    public KeyProvider getKeyProvider(String resourceID) {
        return this.getKeyProvider(resourceID, KeyProvider.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized KeyProvider getKeyProvider(String resourceID, Class keyProviderType) throws NullPointerException, ClassCastException, IllegalArgumentException {
        if (resourceID == null) {
            throw new NullPointerException();
        }
        Class clazz = KeyManager.class;
        synchronized (clazz) {
            KeyProvider provider = (KeyProvider)providers.get(resourceID);
            if (provider == null) {
                Class subst = (Class)this.providerTypes.get(keyProviderType);
                if (subst != null) {
                    keyProviderType = subst;
                }
                try {
                    provider = (KeyProvider)keyProviderType.newInstance();
                }
                catch (InstantiationException failure) {
                    IllegalArgumentException iae = new IllegalArgumentException(keyProviderType.getName());
                    iae.initCause(failure);
                    throw iae;
                }
                catch (IllegalAccessException failure) {
                    IllegalArgumentException iae = new IllegalArgumentException(keyProviderType.getName());
                    iae.initCause(failure);
                    throw iae;
                }
                this.setKeyProvider(resourceID, provider);
            }
            return provider;
        }
    }

    public void setKeyProvider(String resourceID, KeyProvider provider) throws NullPointerException, IllegalStateException {
        if (provider instanceof AbstractKeyProvider) {
            ((AbstractKeyProvider)provider).addToKeyManager(resourceID);
        } else {
            KeyManager.mapKeyProvider(resourceID, provider);
        }
    }

    static {
        $assertionsDisabled = !KeyManager.class.desiredAssertionStatus();
        providers = new HashMap();
    }

    protected static interface KeyProviderCommand {
        public void run(String var1, KeyProvider var2);
    }
}

