/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.tray.impl;

import de.huxhorn.lilith.tray.TraySupport;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTrayImpl
extends TraySupport {
    private final Logger logger = LoggerFactory.getLogger(SystemTrayImpl.class);
    private TrayIcon trayIcon;
    private static final Image DEFAULT_ICON_IMAGE;
    private Menu sourcesMenu;
    private SystemTray tray = SystemTray.getSystemTray();
    private boolean active = false;

    public SystemTrayImpl() {
        this.sourcesMenu = new Menu("Sources");
        PopupMenu popup = new PopupMenu();
        MenuItem defaultItem = new MenuItem("Show/Hide");
        defaultItem.addActionListener(new ShowHideActionListener());
        popup.add(defaultItem);
        MenuItem quitItem = new MenuItem("Quit");
        quitItem.addActionListener(new QuitActionListener());
        popup.add(quitItem);
        this.trayIcon = new TrayIcon(DEFAULT_ICON_IMAGE, "Lilith", popup);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addActionListener(new TrayIconActionListener());
        this.trayIcon.addMouseListener(new TrayIconMouseListener());
    }

    public void setActive(boolean active) {
        if (active) {
            this.addTrayIcon();
        } else {
            this.removeTrayIcon();
        }
    }

    private void addTrayIcon() {
        block2: {
            try {
                this.removeTrayIcon();
                this.tray.add(this.trayIcon);
                this.active = true;
            }
            catch (AWTException e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("Exception while adding tray icon!", (Throwable)e);
            }
        }
    }

    private void removeTrayIcon() {
        this.tray.remove(this.trayIcon);
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setIconImage(Image image) {
        this.trayIcon.setImage(image);
    }

    public void displayMessage(String message, TraySupport.MessageType messageType) {
        TrayIcon.MessageType type;
        switch (messageType) {
            case ERROR: {
                type = TrayIcon.MessageType.ERROR;
                break;
            }
            case WARNING: {
                type = TrayIcon.MessageType.WARNING;
                break;
            }
            case INFO: {
                type = TrayIcon.MessageType.INFO;
                break;
            }
            default: {
                type = TrayIcon.MessageType.NONE;
            }
        }
        this.trayIcon.displayMessage(null, message, type);
    }

    public void setToolTip(String toolTip) {
        this.trayIcon.setToolTip(toolTip);
    }

    public Image getDefaultIcon() {
        return DEFAULT_ICON_IMAGE;
    }

    static {
        Logger logger = LoggerFactory.getLogger(SystemTrayImpl.class);
        URL iconUrl = SystemTrayImpl.class.getResource("/Lilith.png");
        Image image = null;
        if (iconUrl == null) {
            if (logger.isErrorEnabled()) {
                logger.error("Could not load default icon!");
            }
        } else {
            image = Toolkit.getDefaultToolkit().createImage(iconUrl);
        }
        DEFAULT_ICON_IMAGE = image;
    }

    private class TrayIconMouseListener
    extends MouseAdapter {
        private TrayIconMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2 && SystemTrayImpl.this.mainFrame != null) {
                SystemTrayImpl.this.mainFrame.toggleVisible();
            }
        }
    }

    private class TrayIconActionListener
    implements ActionListener {
        private TrayIconActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (SystemTrayImpl.this.logger.isInfoEnabled()) {
                SystemTrayImpl.this.logger.info("TrayIconAction");
            }
        }
    }

    private class ShowHideActionListener
    implements ActionListener {
        private ShowHideActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (SystemTrayImpl.this.logger.isInfoEnabled()) {
                SystemTrayImpl.this.logger.info("Show/Hide Action");
            }
            if (SystemTrayImpl.this.mainFrame != null) {
                SystemTrayImpl.this.mainFrame.toggleVisible();
            }
        }
    }

    private class QuitActionListener
    implements ActionListener {
        private QuitActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (SystemTrayImpl.this.mainFrame != null) {
                SystemTrayImpl.this.mainFrame.exit();
            }
        }
    }
}

