/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.tools.formatters;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.StatusManager;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.LoggerContext;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.logback.tools.ContextHelper;
import de.huxhorn.lilith.tools.formatters.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingFormatter
implements Formatter<EventWrapper<LoggingEvent>> {
    private final Logger logger = LoggerFactory.getLogger(LoggingFormatter.class);
    private static final String DEFAULT_PATTERN = "%-5level [%thread]: %message%n";
    private PatternLayout layout;
    private String pattern;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String format(EventWrapper<LoggingEvent> wrapper) {
        LoggingEvent event;
        this.initLayout();
        if (wrapper != null && (event = (LoggingEvent)wrapper.getEvent()) != null) {
            LoggingFoo foo = new LoggingFoo(event);
            return this.layout.doLayout((ILoggingEvent)foo);
        }
        return null;
    }

    private void initLayout() {
        if (this.layout == null) {
            this.layout = new PatternLayout();
            ch.qos.logback.classic.LoggerContext context = new ch.qos.logback.classic.LoggerContext();
            this.layout.setContext((Context)context);
            if (this.pattern != null) {
                this.layout.setPattern(this.pattern);
            } else {
                this.layout.setPattern(DEFAULT_PATTERN);
            }
            this.layout.start();
            StatusManager statusManager = context.getStatusManager();
            int statusLevel = ContextHelper.getHighestLevel((Context)context);
            if (statusLevel > 0) {
                List stati = statusManager.getCopyOfStatusList();
                String msg = "Error while initializing layout! " + stati;
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(msg);
                }
                throw new IllegalStateException(msg);
            }
        }
    }

    private static class ThrowableProxyFoo
    implements IThrowableProxy {
        private String message;
        private String className;
        private StackTraceElementProxy[] stackTraceElementProxyArray;
        private IThrowableProxy cause;
        private int commonFrames;
        private IThrowableProxy[] suppressed;

        private ThrowableProxyFoo() {
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public StackTraceElementProxy[] getStackTraceElementProxyArray() {
            return this.stackTraceElementProxyArray;
        }

        public void setStackTraceElementProxyArray(StackTraceElementProxy[] stackTraceElementProxyArray) {
            this.stackTraceElementProxyArray = stackTraceElementProxyArray;
        }

        public IThrowableProxy[] getSuppressed() {
            return this.suppressed;
        }

        public void setSuppressed(IThrowableProxy[] suppressed) {
            this.suppressed = suppressed;
        }

        public IThrowableProxy getCause() {
            return this.cause;
        }

        public void setCause(IThrowableProxy cause) {
            this.cause = cause;
        }

        public int getCommonFrames() {
            return this.commonFrames;
        }

        public void setCommonFrames(int commonFrames) {
            this.commonFrames = commonFrames;
        }

        private static ThrowableProxyFoo convert(ThrowableInfo throwableInfo) {
            ThrowableProxyFoo result = null;
            if (throwableInfo != null) {
                result = new ThrowableProxyFoo();
                result.setMessage(throwableInfo.getMessage());
                result.setClassName(throwableInfo.getName());
                result.setCommonFrames(throwableInfo.getOmittedElements());
                result.setStackTraceElementProxyArray(ThrowableProxyFoo.convert(throwableInfo.getStackTrace()));
                ThrowableInfo[] throwableInfoSuppressed = throwableInfo.getSuppressed();
                if (throwableInfoSuppressed != null) {
                    IThrowableProxy[] throwableProxySuppressed = new IThrowableProxy[throwableInfoSuppressed.length];
                    for (int i = 0; i < throwableInfoSuppressed.length; ++i) {
                        throwableProxySuppressed[i] = ThrowableProxyFoo.convert(throwableInfoSuppressed[i]);
                    }
                    result.setSuppressed(throwableProxySuppressed);
                }
                result.setCause(ThrowableProxyFoo.convert(throwableInfo.getCause()));
            }
            return result;
        }

        private static StackTraceElementProxy[] convert(ExtendedStackTraceElement[] stackTrace) {
            StackTraceElementProxy[] result = null;
            if (stackTrace != null) {
                result = new StackTraceElementProxy[stackTrace.length];
                for (int i = 0; i < stackTrace.length; ++i) {
                    StackTraceElement ste;
                    ExtendedStackTraceElement current = stackTrace[i];
                    if (current == null || (ste = current.getStackTraceElement()) == null) continue;
                    result[i] = new StackTraceElementProxy(ste);
                    String codeLocation = current.getCodeLocation();
                    String version = current.getVersion();
                    if (codeLocation == null && version == null) continue;
                    boolean exact = current.isExact();
                    ClassPackagingData cpd = new ClassPackagingData(codeLocation, version, exact);
                    result[i].setClassPackagingData(cpd);
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoggingFoo
    implements ILoggingEvent {
        private LoggingEvent event;

        public LoggingFoo(LoggingEvent event) {
            this.event = event;
        }

        public String getThreadName() {
            ThreadInfo ti;
            if (this.event != null && (ti = this.event.getThreadInfo()) != null) {
                return ti.getName();
            }
            return null;
        }

        public Level getLevel() {
            LoggingEvent.Level level;
            if (this.event != null && (level = this.event.getLevel()) != null) {
                switch (level) {
                    case TRACE: {
                        return Level.TRACE;
                    }
                    case DEBUG: {
                        return Level.DEBUG;
                    }
                    case INFO: {
                        return Level.INFO;
                    }
                    case WARN: {
                        return Level.WARN;
                    }
                    case ERROR: {
                        return Level.ERROR;
                    }
                }
            }
            return null;
        }

        public String getMessage() {
            Message message;
            if (this.event != null && (message = this.event.getMessage()) != null) {
                return message.getMessagePattern();
            }
            return null;
        }

        public Object[] getArgumentArray() {
            Message message = this.event.getMessage();
            if (message != null) {
                return message.getArguments();
            }
            return new Object[0];
        }

        public String getFormattedMessage() {
            Message message;
            if (this.event != null && (message = this.event.getMessage()) != null) {
                return message.getMessage();
            }
            return null;
        }

        public String getLoggerName() {
            if (this.event != null) {
                return this.event.getLogger();
            }
            return null;
        }

        public LoggerContextVO getLoggerContextVO() {
            LoggerContext loggerContext;
            LoggerContextVO result = null;
            if (this.event != null && (loggerContext = this.event.getLoggerContext()) != null) {
                result = new LoggerContextVO(loggerContext.getName(), loggerContext.getProperties(), loggerContext.getBirthTime().longValue());
            }
            return result;
        }

        public IThrowableProxy getThrowableProxy() {
            if (this.event != null) {
                return ThrowableProxyFoo.convert(this.event.getThrowable());
            }
            return null;
        }

        public StackTraceElement[] getCallerData() {
            ExtendedStackTraceElement[] callStack;
            if (this.event != null && (callStack = this.event.getCallStack()) != null) {
                StackTraceElement[] result = new StackTraceElement[callStack.length];
                for (int i = 0; i < callStack.length; ++i) {
                    result[i] = callStack[i].getStackTraceElement();
                }
                return result;
            }
            return new StackTraceElement[0];
        }

        public boolean hasCallerData() {
            if (this.event != null) {
                ExtendedStackTraceElement[] callStack = this.event.getCallStack();
                return callStack != null && callStack.length > 0;
            }
            return false;
        }

        public org.slf4j.Marker getMarker() {
            if (this.event != null) {
                HashMap<String, org.slf4j.Marker> markerMap = new HashMap<String, org.slf4j.Marker>();
                return LoggingFoo.convert(this.event.getMarker(), markerMap);
            }
            return null;
        }

        public Map<String, String> getMDCPropertyMap() {
            if (this.event != null) {
                return this.event.getMdc();
            }
            return null;
        }

        public Map<String, String> getMdc() {
            if (this.event != null) {
                return this.event.getMdc();
            }
            return null;
        }

        public long getTimeStamp() {
            Long timeStamp;
            if (this.event != null && (timeStamp = this.event.getTimeStamp()) != null) {
                return timeStamp;
            }
            return 0L;
        }

        public void prepareForDeferredProcessing() {
        }

        private static org.slf4j.Marker convert(Marker originalMarker, Map<String, org.slf4j.Marker> markerMap) {
            String originalName;
            org.slf4j.Marker result = null;
            if (originalMarker != null && (originalName = originalMarker.getName()) != null && (result = markerMap.get(originalName)) == null) {
                result = MarkerFactory.getDetachedMarker((String)originalName);
                markerMap.put(originalName, result);
                Map references = originalMarker.getReferences();
                if (references != null) {
                    for (Map.Entry current : references.entrySet()) {
                        String name = (String)current.getKey();
                        Marker value = (Marker)current.getValue();
                        org.slf4j.Marker marker = markerMap.get(name);
                        if (marker == null) {
                            marker = LoggingFoo.convert(value, markerMap);
                        }
                        result.add(marker);
                    }
                }
            }
            return result;
        }
    }
}

