/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.tools;

import de.huxhorn.lilith.prefs.LilithPreferences;
import de.huxhorn.lilith.prefs.protobuf.LilithPreferencesStreamingDecoder;
import de.huxhorn.lilith.prefs.protobuf.LilithPreferencesStreamingEncoder;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.sulky.io.IOUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportExportCommand {
    private static final int MAX_FILE_SIZE = 0x500000;

    public static Map<String, byte[]> exportGroovyConditions(ApplicationPreferences prefs) {
        String[] files = prefs.getAllGroovyConditionScriptFiles();
        if (files == null) {
            return null;
        }
        return ImportExportCommand.exportFiles(prefs.getGroovyConditionsPath(), files);
    }

    public static Map<String, byte[]> exportClipboardFormatterScriptFiles(ApplicationPreferences prefs) {
        String[] files = prefs.getClipboardFormatterScriptFiles();
        if (files == null) {
            return null;
        }
        return ImportExportCommand.exportFiles(prefs.getGroovyConditionsPath(), files);
    }

    public static Map<String, byte[]> exportDetailsView(ApplicationPreferences prefs) {
        String[] files = new String[]{"detailsView.css", "detailsView.groovy"};
        return ImportExportCommand.exportFiles(prefs.getDetailsViewRoot(), files);
    }

    public static Map<String, byte[]> exportRootFiles(ApplicationPreferences prefs) {
        String[] files = new String[]{"accessLayoutGlobal.xml", "accessLayout.xml", "loggingLayoutGlobal.xml", "loggingLayout.xml", "savedConditions.xml", "SoundLocations.xml", "SourceLists.xml", "SourceNames.xml", "statusColors.xml", "levelColors.xml"};
        return ImportExportCommand.exportFiles(prefs.getStartupApplicationPath(), files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, byte[]> exportFiles(File basePath, String[] files) {
        Logger logger = LoggerFactory.getLogger(ImportExportCommand.class);
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (String string : files) {
            File currentFile = basePath != null ? new File(basePath, string) : new File(string);
            if (!currentFile.exists()) {
                if (!logger.isInfoEnabled()) continue;
                logger.info("Ignoring '{}' because it does not exist.", (Object)currentFile.getAbsolutePath());
                continue;
            }
            if (!currentFile.canRead()) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Can't read '{}'!", (Object)currentFile.getAbsolutePath());
                continue;
            }
            DataInputStream is = null;
            try {
                long length = currentFile.length();
                if (length > 0x500000L) {
                    if (!logger.isInfoEnabled()) continue;
                    logger.info("Ignoring '{}' because it's too big ({} bytes).", (Object)currentFile.getAbsolutePath(), (Object)length);
                    continue;
                }
                byte[] bytes = new byte[(int)length];
                is = new DataInputStream(new FileInputStream(currentFile));
                is.readFully(bytes);
                result.put(string, bytes);
                IOUtilities.closeQuietly((InputStream)is);
            }
            catch (IOException e) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Exception while reading '" + currentFile.getAbsolutePath() + "'! Ignoring file...", (Throwable)e);
            }
            finally {
                IOUtilities.closeQuietly(is);
            }
        }
        if (logger.isInfoEnabled()) {
            TreeMap<String, byte[]> sortedResult = new TreeMap<String, byte[]>(result);
            StringBuilder msg = new StringBuilder();
            msg.append("Exported files:\n");
            for (Map.Entry entry : sortedResult.entrySet()) {
                msg.append("- ").append((String)entry.getKey()).append("\n");
                msg.append("  ").append(((byte[])entry.getValue()).length).append(" bytes\n");
            }
            logger.info(msg.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importFiles(File basePath, Map<String, byte[]> files) {
        Logger logger = LoggerFactory.getLogger(ImportExportCommand.class);
        if (basePath.mkdirs() && logger.isInfoEnabled()) {
            logger.info("Created directory '{}'.", (Object)basePath.getAbsolutePath());
        }
        for (Map.Entry<String, byte[]> current : files.entrySet()) {
            String key = current.getKey();
            byte[] value = current.getValue();
            File currentFile = new File(basePath, key);
            if (!currentFile.isFile() || currentFile.canWrite()) {
                DataOutputStream os;
                block7: {
                    os = null;
                    try {
                        os = new DataOutputStream(new FileOutputStream(currentFile));
                        os.write(value);
                        if (!logger.isInfoEnabled()) break block7;
                        logger.info("Wrote {} bytes into '{}'.", (Object)value.length, (Object)currentFile.getAbsolutePath());
                    }
                    catch (IOException e) {
                        block8: {
                            try {
                                if (!logger.isWarnEnabled()) break block8;
                                logger.warn("Exception while writing '" + currentFile.getAbsolutePath() + "'! Ignoring file...", (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                IOUtilities.closeQuietly(os);
                                throw throwable;
                            }
                        }
                        IOUtilities.closeQuietly((OutputStream)os);
                        continue;
                    }
                }
                IOUtilities.closeQuietly((OutputStream)os);
                continue;
            }
            if (!logger.isWarnEnabled()) continue;
            logger.warn("Can't write {}!", (Object)currentFile.getAbsolutePath());
        }
    }

    public static LilithPreferences exportPersistence(ApplicationPreferences prefs) {
        LilithPreferences p = new LilithPreferences();
        p.setGroovyConditions(ImportExportCommand.exportGroovyConditions(prefs));
        p.setGroovyClipboardFormatters(ImportExportCommand.exportClipboardFormatterScriptFiles(prefs));
        p.setDetailsView(ImportExportCommand.exportDetailsView(prefs));
        p.setRootFiles(ImportExportCommand.exportRootFiles(prefs));
        p.setBlackListName(prefs.getBlackListName());
        p.setWhiteListName(prefs.getWhiteListName());
        p.setLookAndFeel(prefs.getLookAndFeel());
        p.setAskingBeforeQuit(prefs.isAskingBeforeQuit());
        p.setAutoClosing(prefs.isAutoClosing());
        p.setAutoFocusingWindow(prefs.isAutoFocusingWindow());
        p.setAutoOpening(prefs.isAutoOpening());
        p.setCheckingForUpdate(prefs.isCheckingForUpdate());
        p.setCheckingForSnapshot(prefs.isCheckingForSnapshot());
        p.setCleaningLogsOnExit(prefs.isCleaningLogsOnExit());
        p.setColoringWholeRow(prefs.isColoringWholeRow());
        p.setGlobalLoggingEnabled(prefs.isGlobalLoggingEnabled());
        p.setHidingOnClose(prefs.isHidingOnClose());
        p.setLoggingStatisticEnabled(prefs.isLoggingStatisticEnabled());
        p.setMaximizingInternalFrames(prefs.isMaximizingInternalFrames());
        p.setMute(prefs.isMute());
        p.setScrollingToBottom(prefs.isScrollingToBottom());
        p.setShowingFullCallstack(prefs.isShowingFullCallstack());
        p.setUsingWrappedExceptionStyle(prefs.isUsingWrappedExceptionStyle());
        p.setShowingFullRecentPath(prefs.isShowingFullRecentPath());
        p.setShowingIdentifier(prefs.isShowingIdentifier());
        p.setShowingStatusbar(prefs.isShowingStatusbar());
        p.setShowingStackTrace(prefs.isShowingStackTrace());
        p.setShowingTipOfTheDay(prefs.isShowingTipOfTheDay());
        p.setShowingToolbar(prefs.isShowingToolbar());
        p.setSplashScreenDisabled(prefs.isSplashScreenDisabled());
        p.setTrayActive(prefs.isTrayActive());
        p.setUsingInternalFrames(prefs.isUsingInternalFrames());
        p.setSourceFiltering(prefs.getSourceFiltering());
        return p;
    }

    public static void importPersistence(ApplicationPreferences prefs, LilithPreferences p) {
        if (p.getGroovyConditions() != null) {
            ImportExportCommand.importFiles(prefs.getGroovyConditionsPath(), p.getGroovyConditions());
        }
        if (p.getGroovyConditions() != null) {
            ImportExportCommand.importFiles(prefs.getGroovyClipboardFormattersPath(), p.getGroovyClipboardFormatters());
        }
        if (p.getDetailsView() != null) {
            ImportExportCommand.importFiles(prefs.getDetailsViewRoot(), p.getDetailsView());
        }
        if (p.getRootFiles() != null) {
            ImportExportCommand.importFiles(prefs.getStartupApplicationPath(), p.getRootFiles());
        }
        prefs.setBlackListName(p.getBlackListName());
        prefs.setWhiteListName(p.getWhiteListName());
        prefs.setLookAndFeel(p.getLookAndFeel());
        prefs.setAskingBeforeQuit(p.isAskingBeforeQuit());
        prefs.setAutoClosing(p.isAutoClosing());
        prefs.setAutoFocusingWindow(p.isAutoFocusingWindow());
        prefs.setAutoOpening(p.isAutoOpening());
        prefs.setCheckingForUpdate(p.isCheckingForUpdate());
        prefs.setCheckingForSnapshot(p.isCheckingForSnapshot());
        prefs.setCleaningLogsOnExit(p.isCleaningLogsOnExit());
        prefs.setColoringWholeRow(p.isColoringWholeRow());
        prefs.setGlobalLoggingEnabled(p.isGlobalLoggingEnabled());
        prefs.setHidingOnClose(p.isHidingOnClose());
        prefs.setLoggingStatisticEnabled(p.isLoggingStatisticEnabled());
        prefs.setMaximizingInternalFrames(p.isMaximizingInternalFrames());
        prefs.setMute(p.isMute());
        prefs.setScrollingToBottom(p.isScrollingToBottom());
        prefs.setShowingFullCallstack(p.isShowingFullCallstack());
        prefs.setUsingWrappedExceptionStyle(p.isUsingWrappedExceptionStyle());
        prefs.setShowingFullRecentPath(p.isShowingFullRecentPath());
        prefs.setShowingIdentifier(p.isShowingIdentifier());
        prefs.setShowingStatusbar(p.isShowingStatusbar());
        prefs.setShowingStackTrace(p.isShowingStackTrace());
        prefs.setShowingTipOfTheDay(p.isShowingTipOfTheDay());
        prefs.setShowingToolbar(p.isShowingToolbar());
        prefs.setSplashScreenDisabled(p.isSplashScreenDisabled());
        prefs.setTrayActive(p.isTrayActive());
        prefs.setUsingInternalFrames(p.isUsingInternalFrames());
        prefs.setSourceFiltering(p.getSourceFiltering());
    }

    public static void exportPreferences(File file) {
        block2: {
            Logger logger = LoggerFactory.getLogger(ImportExportCommand.class);
            ApplicationPreferences prefs = new ApplicationPreferences();
            LilithPreferences p = ImportExportCommand.exportPersistence(prefs);
            try {
                ImportExportCommand.writePersistence(file, p);
            }
            catch (IOException e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error("Exception while writing '" + file.getAbsolutePath() + "'!", (Throwable)e);
            }
        }
    }

    public static void importPreferences(File file) {
        block2: {
            Logger logger = LoggerFactory.getLogger(ImportExportCommand.class);
            ApplicationPreferences prefs = new ApplicationPreferences();
            try {
                LilithPreferences p = ImportExportCommand.readPersistence(file);
                ImportExportCommand.importPersistence(prefs, p);
            }
            catch (IOException e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error("Exception while reading '" + file.getAbsolutePath() + "'!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePersistence(File file, LilithPreferences p) throws IOException {
        DeflaterOutputStream os = null;
        try {
            os = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            LilithPreferencesStreamingEncoder encoder = new LilithPreferencesStreamingEncoder();
            encoder.encode(p, (OutputStream)os);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LilithPreferences readPersistence(File file) throws IOException {
        GZIPInputStream is = null;
        try {
            is = new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)));
            LilithPreferencesStreamingDecoder decoder = new LilithPreferencesStreamingDecoder();
            LilithPreferences lilithPreferences = decoder.decode((InputStream)is);
            return lilithPreferences;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

