/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences.table;

import de.huxhorn.lilith.data.access.HttpStatus;
import de.huxhorn.lilith.swing.preferences.table.ColorSchemePreviewRenderer;
import de.huxhorn.lilith.swing.table.ColorScheme;
import java.util.Map;
import javax.swing.JTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessStatusTypePreviewRenderer
extends ColorSchemePreviewRenderer {
    private final Logger logger = LoggerFactory.getLogger(AccessStatusTypePreviewRenderer.class);
    private Map<HttpStatus.Type, ColorScheme> schemes;

    public Map<HttpStatus.Type, ColorScheme> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(Map<HttpStatus.Type, ColorScheme> schemes) {
        this.schemes = schemes;
    }

    @Override
    public ColorScheme resolveColorScheme(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ColorScheme result = null;
        if (value instanceof HttpStatus.Type) {
            HttpStatus.Type level = (HttpStatus.Type)value;
            if (this.schemes == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("No color schemes defined for logging levels!");
                }
            } else {
                result = this.schemes.get(level);
            }
        }
        return result;
    }

    @Override
    public void updateText(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        String text = "";
        String toolTip = "";
        if (value instanceof HttpStatus.Type) {
            HttpStatus.Type type = (HttpStatus.Type)value;
            text = type.toString();
            toolTip = type.toString();
        }
        this.renderer.setText(text);
        this.renderer.setToolTipText(toolTip);
    }
}

