/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.prefs.LilithPreferences;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.LilithKeyStrokes;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.preferences.AccessStatusTypePanel;
import de.huxhorn.lilith.swing.preferences.ConditionsPanel;
import de.huxhorn.lilith.swing.preferences.GeneralPanel;
import de.huxhorn.lilith.swing.preferences.LoggingLevelPanel;
import de.huxhorn.lilith.swing.preferences.SoundsPanel;
import de.huxhorn.lilith.swing.preferences.Source;
import de.huxhorn.lilith.swing.preferences.SourceFilteringPanel;
import de.huxhorn.lilith.swing.preferences.SourceListsPanel;
import de.huxhorn.lilith.swing.preferences.SourcesPanel;
import de.huxhorn.lilith.swing.preferences.StartupShutdownPanel;
import de.huxhorn.lilith.swing.preferences.TroubleshootingPanel;
import de.huxhorn.lilith.swing.preferences.WindowsPanel;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.swing.KeyStrokes;
import groovy.ui.Console;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(PreferencesDialog.class);
    private ApplicationPreferences applicationPreferences;
    private MainFrame mainFrame;
    private JComboBox comboBox;
    private DefaultComboBoxModel comboBoxModel;
    private CardLayout cardLayout;
    private JPanel content;
    private GeneralPanel generalPanel;
    private StartupShutdownPanel startupShutdownPanel;
    private WindowsPanel windowsPanel;
    private SoundsPanel soundsPanel;
    private SourcesPanel sourcesPanel;
    private SourceListsPanel sourceListsPanel;
    private ConditionsPanel conditionsPanel;
    private LoggingLevelPanel loggingLevelPanel;
    private AccessStatusTypePanel accessStatusTypePanel;
    private Map<String, String> sourceNames;
    private Map<String, Set<String>> sourceLists;
    private SourceFilteringPanel sourceFilteringPanel;
    private String blackListName;
    private String whiteListName;
    private LilithPreferences.SourceFiltering sourceFiltering;

    public PreferencesDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, "Preferences");
        this.mainFrame = mainFrame;
        this.applicationPreferences = mainFrame.getApplicationPreferences();
        this.createUI();
    }

    public ApplicationPreferences getApplicationPreferences() {
        return this.applicationPreferences;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    private void createUI() {
        this.generalPanel = new GeneralPanel(this);
        this.startupShutdownPanel = new StartupShutdownPanel(this);
        this.windowsPanel = new WindowsPanel(this);
        this.soundsPanel = new SoundsPanel(this);
        this.sourcesPanel = new SourcesPanel(this);
        this.sourceListsPanel = new SourceListsPanel(this);
        this.sourceFilteringPanel = new SourceFilteringPanel(this);
        this.conditionsPanel = new ConditionsPanel(this);
        this.loggingLevelPanel = new LoggingLevelPanel(this);
        this.accessStatusTypePanel = new AccessStatusTypePanel(this);
        TroubleshootingPanel troubleshootingPanel = new TroubleshootingPanel(this);
        this.comboBoxModel = new DefaultComboBoxModel();
        for (Panes current : Panes.values()) {
            this.comboBoxModel.addElement(current);
        }
        this.comboBox = new JComboBox(this.comboBoxModel);
        this.comboBox.setRenderer(new MyComboBoxRenderer());
        this.comboBox.setEditable(false);
        this.comboBox.addItemListener(new ComboItemListener());
        this.cardLayout = new CardLayout();
        this.content = new JPanel(this.cardLayout);
        this.content.setPreferredSize(new Dimension(600, 500));
        this.content.add((Component)this.generalPanel, Panes.General.toString());
        this.content.add((Component)this.startupShutdownPanel, Panes.StartupShutdown.toString());
        this.content.add((Component)this.windowsPanel, Panes.Windows.toString());
        this.content.add((Component)this.soundsPanel, Panes.Sounds.toString());
        this.content.add((Component)this.sourcesPanel, Panes.Sources.toString());
        this.content.add((Component)this.sourceListsPanel, Panes.SourceLists.toString());
        this.content.add((Component)this.sourceFilteringPanel, Panes.SourceFiltering.toString());
        this.content.add((Component)this.conditionsPanel, Panes.Conditions.toString());
        this.content.add((Component)this.loggingLevelPanel, Panes.LoggingLevels.toString());
        this.content.add((Component)this.accessStatusTypePanel, Panes.AccessStatus.toString());
        this.content.add((Component)troubleshootingPanel, Panes.Troubleshooting.toString());
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        OkAction okAction = new OkAction();
        buttonPanel.add(new JButton(okAction));
        buttonPanel.add(new JButton(new ApplyAction()));
        buttonPanel.add(new JButton(new ResetAction()));
        CancelAction cancelAction = new CancelAction();
        buttonPanel.add(new JButton(cancelAction));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.comboBox, "North");
        contentPane.add((Component)this.content, "Center");
        contentPane.add((Component)buttonPanel, "South");
        KeyStrokes.registerCommand((JComponent)this.content, (Action)okAction, (String)"OK_ACTION");
        KeyStrokes.registerCommand((JComponent)buttonPanel, (Action)okAction, (String)"OK_ACTION");
        KeyStrokes.registerCommand((JComponent)this.content, (Action)cancelAction, (String)"CANCEL_ACTION");
        KeyStrokes.registerCommand((JComponent)buttonPanel, (Action)cancelAction, (String)"CANCEL_ACTION");
    }

    private void initUI() {
        this.generalPanel.initUI();
        this.startupShutdownPanel.initUI();
        this.windowsPanel.initUI();
        this.soundsPanel.initUI();
        this.sourceNames = this.applicationPreferences.getSourceNames();
        this.sourceNames = this.sourceNames == null ? new HashMap<String, String>() : new HashMap<String, String>(this.sourceNames);
        this.sourceLists = this.applicationPreferences.getSourceLists();
        this.conditionsPanel.initUI();
        this.sourcesPanel.initUI();
        this.sourceListsPanel.initUI();
        this.sourceFilteringPanel.initUI();
        this.loggingLevelPanel.initUI();
        this.accessStatusTypePanel.initUI();
    }

    public Map<String, String> getSourceNames() {
        return this.sourceNames;
    }

    public void setSourceNames(Map<String, String> sourceNames) {
        this.sourceNames = sourceNames;
        this.sourcesPanel.initUI();
        this.sourceListsPanel.initUI();
    }

    public void setSourceName(String oldIdentifier, String newIdentifier, String sourceName) {
        if (this.sourceNames.containsKey(oldIdentifier)) {
            this.sourceNames.remove(oldIdentifier);
        }
        this.sourceNames.put(newIdentifier, sourceName);
        this.sourcesPanel.initUI();
        this.sourceListsPanel.initUI();
    }

    public void setSourceList(String oldName, String newName, List<Source> sourceList) {
        if (this.sourceLists.containsKey(oldName)) {
            this.sourceLists.remove(oldName);
        }
        HashSet<String> newList = new HashSet<String>();
        for (Source s : sourceList) {
            newList.add(s.getIdentifier());
        }
        this.sourceLists.put(newName, newList);
        this.sourceListsPanel.initUI();
        this.sourceFilteringPanel.initUI();
    }

    public List<Source> getSourceList(String name) {
        Set<String> srcList = this.sourceLists.get(name);
        if (srcList != null) {
            ArrayList<Source> result = new ArrayList<Source>();
            for (String current : srcList) {
                Source s = new Source();
                s.setIdentifier(current);
                s.setName(this.getSourceName(current));
                result.add(s);
            }
            Collections.sort(result);
            return result;
        }
        return new ArrayList<Source>();
    }

    private String getSourceName(String identifier) {
        String result = this.sourceNames.get(identifier);
        if (result == null) {
            result = identifier;
        }
        return result;
    }

    private void saveSettings() {
        this.generalPanel.saveSettings();
        this.startupShutdownPanel.saveSettings();
        this.windowsPanel.saveSettings();
        this.soundsPanel.saveSettings();
        this.conditionsPanel.saveSettings();
        this.loggingLevelPanel.saveSettings();
        this.accessStatusTypePanel.saveSettings();
        this.applicationPreferences.setSourceNames(this.sourceNames);
        this.applicationPreferences.setSourceLists(this.sourceLists);
        this.applicationPreferences.setBlackListName(this.blackListName);
        this.applicationPreferences.setWhiteListName(this.whiteListName);
        this.applicationPreferences.setSourceFiltering(this.sourceFiltering);
    }

    private void resetSettings() {
        this.initUI();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            if (visible) {
                this.initUI();
            }
            super.setVisible(visible);
        }
    }

    public List<String> getSourceListNames() {
        return new ArrayList<String>(this.sourceLists.keySet());
    }

    public void removeSourceList(String sourceListName) {
        if (this.sourceLists.containsKey(sourceListName)) {
            this.sourceLists.remove(sourceListName);
            this.sourceListsPanel.initUI();
            this.sourceFilteringPanel.initUI();
        }
    }

    public String getBlackListName() {
        if (this.blackListName == null) {
            this.blackListName = this.applicationPreferences.getBlackListName();
        }
        return this.blackListName;
    }

    public String getWhiteListName() {
        if (this.whiteListName == null) {
            this.whiteListName = this.applicationPreferences.getWhiteListName();
        }
        return this.whiteListName;
    }

    public LilithPreferences.SourceFiltering getSourceFiltering() {
        if (this.sourceFiltering == null) {
            this.sourceFiltering = this.applicationPreferences.getSourceFiltering();
        }
        return this.sourceFiltering;
    }

    public void setSourceFiltering(LilithPreferences.SourceFiltering sourceFiltering) {
        this.sourceFiltering = sourceFiltering;
    }

    public void setBlackListName(String blackListName) {
        this.blackListName = blackListName;
    }

    public void setWhiteListName(String whiteListName) {
        this.whiteListName = whiteListName;
    }

    public void setShowingTipOfTheDay(boolean showingTipOfTheDay) {
        this.startupShutdownPanel.setShowingTipOfTheDay(showingTipOfTheDay);
    }

    public void setCheckingForUpdate(boolean checkingForUpdate) {
        this.startupShutdownPanel.setCheckingForUpdate(checkingForUpdate);
    }

    public void setCheckingForSnapshot(boolean checkingForSnapshot) {
        this.startupShutdownPanel.setCheckingForSnapshot(checkingForSnapshot);
    }

    public void editSourceName(String sourceIdentifier) {
        this.showPane(Panes.Sources);
        this.sourcesPanel.editSourceName(sourceIdentifier);
    }

    public void showPane(Panes pane) {
        if (pane != null) {
            this.cardLayout.show(this.content, pane.toString());
            if (!pane.equals(this.comboBox.getSelectedItem())) {
                this.comboBox.setSelectedItem((Object)pane);
            }
        }
        if (!this.isVisible()) {
            this.mainFrame.showPreferencesDialog();
        }
    }

    public void editDetailsFormatter() {
        JTextPane inputArea;
        Console console;
        block12: {
            console = new Console();
            File messageViewRoot = this.applicationPreferences.getDetailsViewRoot();
            File messageViewGroovyFile = new File(messageViewRoot, "detailsView.groovy");
            EventWrapper eventWrapper = new EventWrapper(new SourceIdentifier("identifier", "secondaryIdentifier"), 17L, (Serializable)new LoggingEvent());
            console.setVariable("eventWrapper", (Object)eventWrapper);
            console.setCurrentFileChooserDir(messageViewRoot);
            String text = "";
            if (!messageViewGroovyFile.isFile()) {
                this.applicationPreferences.initDetailsViewRoot(true);
            }
            if (messageViewGroovyFile.isFile()) {
                try {
                    FileInputStream is = new FileInputStream(messageViewGroovyFile);
                    List lines = IOUtils.readLines((InputStream)is, (String)"UTF-8");
                    boolean isFirst = true;
                    StringBuilder textBuffer = new StringBuilder();
                    for (Object o : lines) {
                        String s = (String)o;
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            textBuffer.append("\n");
                        }
                        textBuffer.append(s);
                    }
                    text = textBuffer.toString();
                }
                catch (IOException e) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Exception while reading '" + messageViewGroovyFile.getAbsolutePath() + "'.", (Throwable)e);
                    }
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to initialize detailsView file '{}'!", (Object)messageViewGroovyFile.getAbsolutePath());
            }
            console.run();
            console.setScriptFile((Object)messageViewGroovyFile);
            inputArea = console.getInputArea();
            Document doc = inputArea.getDocument();
            try {
                doc.remove(0, doc.getLength());
                doc.insertString(0, text, null);
            }
            catch (BadLocationException e) {
                if (!this.logger.isWarnEnabled()) break block12;
                this.logger.warn("Exception while setting source!", (Throwable)e);
            }
        }
        console.setDirty(false);
        inputArea.setCaretPosition(0);
        inputArea.requestFocusInWindow();
    }

    public void editCondition(Condition condition) {
        this.showPane(Panes.Conditions);
        this.conditionsPanel.editCondition(condition);
    }

    private class ComboItemListener
    implements ItemListener {
        private ComboItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            Object item = PreferencesDialog.this.comboBoxModel.getSelectedItem();
            if (item instanceof Panes) {
                Panes pane = (Panes)((Object)item);
                PreferencesDialog.this.showPane(pane);
            }
        }
    }

    private static class MyComboBoxRenderer
    implements ListCellRenderer {
        private JLabel label = new JLabel();

        public MyComboBoxRenderer() {
            this.label.setOpaque(true);
            this.label.setHorizontalAlignment(2);
            this.label.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.label.setBackground(list.getSelectionBackground());
                this.label.setForeground(list.getSelectionForeground());
            } else {
                this.label.setBackground(list.getBackground());
                this.label.setForeground(list.getForeground());
            }
            String title = null;
            Object toolTip = null;
            if (value != null && value.getClass() == Panes.class) {
                Panes panes = (Panes)((Object)value);
                switch (panes) {
                    case General: {
                        title = "General";
                        toolTip = null;
                        break;
                    }
                    case StartupShutdown: {
                        title = "Startup & Shutdown";
                        toolTip = null;
                        break;
                    }
                    case Windows: {
                        title = "Windows";
                        toolTip = null;
                        break;
                    }
                    case Sounds: {
                        title = "Sounds";
                        toolTip = null;
                        break;
                    }
                    case Sources: {
                        title = "Sources";
                        toolTip = null;
                        break;
                    }
                    case SourceLists: {
                        title = "Source Lists";
                        toolTip = null;
                        break;
                    }
                    case SourceFiltering: {
                        title = "Source Filtering";
                        toolTip = null;
                        break;
                    }
                    case Conditions: {
                        title = "Conditions";
                        toolTip = null;
                        break;
                    }
                    case LoggingLevels: {
                        title = "Logging levels";
                        toolTip = null;
                        break;
                    }
                    case AccessStatus: {
                        title = "Access status types";
                        toolTip = null;
                        break;
                    }
                    case Troubleshooting: {
                        title = "Troubleshooting";
                        toolTip = null;
                    }
                }
            }
            this.label.setText(title);
            this.label.setToolTipText(toolTip);
            return this.label;
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 6933499606501725571L;

        public CancelAction() {
            super("Cancel");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("ESCAPE");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 67);
        }

        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.setVisible(false);
        }
    }

    private class ResetAction
    extends AbstractAction {
        private static final long serialVersionUID = -7109027518233905200L;

        public ResetAction() {
            super("Reset");
            this.putValue("MnemonicKey", 82);
        }

        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.resetSettings();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        private static final long serialVersionUID = -4047672339764590549L;

        public ApplyAction() {
            super("Apply");
            this.putValue("MnemonicKey", 65);
        }

        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.saveSettings();
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = 3395474960394431088L;

        public OkAction() {
            super("Ok");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("ENTER");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 79);
        }

        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.saveSettings();
            PreferencesDialog.this.setVisible(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Panes {
        General,
        StartupShutdown,
        Windows,
        Sounds,
        Sources,
        SourceLists,
        SourceFiltering,
        Conditions,
        LoggingLevels,
        AccessStatus,
        Troubleshooting;

    }
}

