/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.LilithKeyStrokes;
import de.huxhorn.lilith.swing.preferences.ColorSchemeEditorPanel;
import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.lilith.swing.table.ColorScheme;
import de.huxhorn.sulky.swing.KeyStrokes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditConditionDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(EditConditionDialog.class);
    private SavedCondition savedCondition;
    private JTextField conditionName;
    private OkAction okAction;
    private boolean adding;
    private boolean canceled;
    private JCheckBox activeCheckBox;
    private ColorSchemeEditorPanel colorSchemeEditorPanel;

    public EditConditionDialog(Dialog owner) {
        super(owner);
        this.setModal(true);
        this.createUi();
    }

    private void createUi() {
        this.okAction = new OkAction();
        CancelAction cancelAction = new CancelAction();
        TextKeyListener listener = new TextKeyListener();
        this.conditionName = new JTextField(25);
        this.conditionName.addActionListener(new ConditionNameActionListener());
        this.conditionName.addKeyListener(listener);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        JLabel conditionNameLabel = new JLabel("Name: ");
        conditionNameLabel.setLabelFor(this.conditionName);
        mainPanel.add((Component)conditionNameLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        mainPanel.add((Component)this.conditionName, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        this.activeCheckBox = new JCheckBox("Active");
        this.activeCheckBox.setToolTipText("<html>Active conditions are used to determine the rendering of the table cells.<br>Too many active conditions will slow down the application!</html>");
        mainPanel.add((Component)this.activeCheckBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.colorSchemeEditorPanel = new ColorSchemeEditorPanel();
        mainPanel.add((Component)this.colorSchemeEditorPanel, gbc);
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(new JButton(this.okAction));
        buttonPanel.add(new JButton(new ResetAction()));
        buttonPanel.add(new JButton(cancelAction));
        this.add((Component)buttonPanel, "South");
        KeyStrokes.registerCommand((JComponent)mainPanel, (Action)cancelAction, (String)"CANCEL_ACTION");
        KeyStrokes.registerCommand((JComponent)buttonPanel, (Action)cancelAction, (String)"CANCEL_ACTION");
    }

    public void setAdding(boolean adding) {
        this.adding = adding;
        if (adding) {
            this.setTitle("Add condition...");
        } else {
            this.setTitle("Edit condition...");
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.conditionName.requestFocusInWindow();
            this.initUI();
        }
        super.setVisible(b);
    }

    private void updateActions() {
        this.okAction.update();
    }

    public SavedCondition getSavedCondition() {
        return this.savedCondition;
    }

    public void setSavedCondition(SavedCondition savedCondition) {
        this.savedCondition = savedCondition;
    }

    public boolean isAdding() {
        return this.adding;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void initUI() {
        this.conditionName.setText(this.savedCondition.getName());
        ColorScheme colorScheme = this.savedCondition.getColorScheme();
        if (colorScheme == null) {
            colorScheme = new ColorScheme().initDefaults();
        }
        this.colorSchemeEditorPanel.setColorScheme(colorScheme);
        this.activeCheckBox.setSelected(this.savedCondition.isActive());
        this.updateActions();
    }

    private class TextKeyListener
    implements KeyListener {
        private TextKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
            EditConditionDialog.this.updateActions();
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private class ConditionNameActionListener
    implements ActionListener {
        private ConditionNameActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String name = EditConditionDialog.this.conditionName.getText();
            if (name != null && !"".equals(name.trim())) {
                EditConditionDialog.this.okAction.actionPerformed(e);
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 5442950514112749763L;

        public CancelAction() {
            super("Cancel");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("ESCAPE");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            EditConditionDialog.this.canceled = true;
            EditConditionDialog.super.setVisible(false);
        }
    }

    private class ResetAction
    extends AbstractAction {
        private static final long serialVersionUID = 3523022122100092148L;

        public ResetAction() {
            super("Reset");
        }

        public void actionPerformed(ActionEvent e) {
            EditConditionDialog.this.initUI();
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = -7380136684827113354L;

        public OkAction() {
            super("Ok");
        }

        public void update() {
            String name = EditConditionDialog.this.conditionName.getText();
            if (name != null && !"".equals(name.trim())) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            String name = EditConditionDialog.this.conditionName.getText();
            if (name != null && !"".equals(name.trim())) {
                EditConditionDialog.this.canceled = false;
                EditConditionDialog.this.savedCondition.setName(EditConditionDialog.this.conditionName.getText());
                EditConditionDialog.this.colorSchemeEditorPanel.saveColors();
                ColorScheme colorScheme = EditConditionDialog.this.colorSchemeEditorPanel.getColorScheme();
                EditConditionDialog.this.savedCondition.setColorScheme(colorScheme);
                EditConditionDialog.this.savedCondition.setActive(EditConditionDialog.this.activeCheckBox.isSelected());
                EditConditionDialog.super.setVisible(false);
            }
        }
    }
}

