/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.preferences.ColorChooserPanel;
import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.lilith.swing.preferences.table.ConditionPreviewRenderer;
import de.huxhorn.lilith.swing.table.ColorScheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorSchemeEditorPanel
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(ColorSchemeEditorPanel.class);
    private ColorChangeListener colorChangeListener;
    private ConditionPreviewRenderer previewDummyRenderer;
    private ColorScheme colorScheme;
    private ColorChooserPanel textChooserPanel;
    private ColorChooserPanel backgroundChooserPanel;
    private ColorChooserPanel borderChooserPanel;

    public ColorSchemeEditorPanel() {
        this.createUI();
    }

    private void createUI() {
        this.colorChangeListener = new ColorChangeListener();
        this.textChooserPanel = new ColorChooserPanel(Color.BLACK);
        this.backgroundChooserPanel = new ColorChooserPanel(Color.WHITE);
        this.borderChooserPanel = new ColorChooserPanel(Color.WHITE);
        this.attachChangeListener(this.textChooserPanel.getColorChooser());
        this.attachChangeListener(this.backgroundChooserPanel.getColorChooser());
        this.attachChangeListener(this.borderChooserPanel.getColorChooser());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Text", this.textChooserPanel);
        tabbedPane.add("Background", this.backgroundChooserPanel);
        tabbedPane.add("Border", this.borderChooserPanel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)tabbedPane, gbc);
        this.previewDummyRenderer = new ConditionPreviewRenderer();
        Component previewComponent = this.previewDummyRenderer.getTableCellRendererComponent(null, null, false, false, 0, 0);
        JPanel previewPanel = new JPanel(new GridLayout(1, 1));
        previewPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Preview"));
        previewPanel.add(previewComponent);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.add((Component)previewPanel, gbc);
    }

    public void saveColors() {
        this.colorScheme = new ColorScheme(this.textChooserPanel.getColor(), this.backgroundChooserPanel.getColor(), this.borderChooserPanel.getColor());
    }

    public void resetColors() {
        if (this.colorScheme == null) {
            this.colorScheme = new ColorScheme().initDefaults();
        }
        this.textChooserPanel.setColor(this.colorScheme.getTextColor());
        this.backgroundChooserPanel.setColor(this.colorScheme.getBackgroundColor());
        this.borderChooserPanel.setColor(this.colorScheme.getBorderColor());
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(ColorScheme colorScheme) {
        if (colorScheme == null) {
            throw new IllegalArgumentException("colorScheme must not be null!");
        }
        this.colorScheme = colorScheme;
        this.resetColors();
    }

    private void attachChangeListener(JColorChooser chooser) {
        AbstractColorChooserPanel[] panels = chooser.getChooserPanels();
        if (panels != null) {
            for (AbstractColorChooserPanel current : panels) {
                current.getColorSelectionModel().addChangeListener(this.colorChangeListener);
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("No chooser panels!");
        }
    }

    private class ColorChangeListener
    implements ChangeListener {
        private SavedCondition dummyCondition = new SavedCondition();

        private ColorChangeListener() {
            this.dummyCondition.setColorScheme(new ColorScheme().initDefaults());
        }

        public void stateChanged(ChangeEvent e) {
            ColorScheme cs = this.dummyCondition.getColorScheme();
            cs.setTextColor(ColorSchemeEditorPanel.this.textChooserPanel.getColor(true));
            cs.setBackgroundColor(ColorSchemeEditorPanel.this.backgroundChooserPanel.getColor(true));
            cs.setBorderColor(ColorSchemeEditorPanel.this.borderChooserPanel.getColor(true));
            if (ColorSchemeEditorPanel.this.logger.isDebugEnabled()) {
                ColorSchemeEditorPanel.this.logger.debug("initializing to {}...", (Object)this.dummyCondition);
            }
            ColorSchemeEditorPanel.this.previewDummyRenderer.getTableCellRendererComponent(null, this.dummyCondition, false, false, 0, 0);
        }
    }
}

