/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.menu;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.actions.AbstractLoggingFilterAction;
import de.huxhorn.lilith.swing.actions.EventWrapperRelated;
import de.huxhorn.lilith.swing.actions.FilterAction;
import de.huxhorn.lilith.swing.actions.FocusLoggerAction;
import de.huxhorn.lilith.swing.actions.ViewContainerRelated;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusLoggerMenu
extends JMenu
implements ViewContainerRelated,
EventWrapperRelated {
    private static final long serialVersionUID = -1383728062587884548L;
    private ViewContainer viewContainer;
    private String loggerName;

    public FocusLoggerMenu() {
        super("Logger");
        this.setViewContainer(null);
        this.setEventWrapper(null);
    }

    @Override
    public void setViewContainer(ViewContainer viewContainer) {
        this.viewContainer = viewContainer;
        this.updateState();
    }

    @Override
    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    @Override
    public void setEventWrapper(EventWrapper eventWrapper) {
        String loggerName = null;
        LoggingEvent loggingEvent = AbstractLoggingFilterAction.resolveLoggingEvent(eventWrapper);
        if (loggingEvent != null) {
            loggerName = loggingEvent.getLogger();
        }
        this.setLoggerName(loggerName);
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
        this.updateState();
    }

    private void updateState() {
        this.removeAll();
        if (this.viewContainer == null || this.loggerName == null) {
            this.setEnabled(false);
            return;
        }
        for (String current : FocusLoggerMenu.prepareLoggerNames(this.loggerName)) {
            this.add(this.createAction(this.viewContainer, current));
        }
        this.setEnabled(true);
    }

    protected FilterAction createAction(ViewContainer viewContainer, String loggerName) {
        return new FocusLoggerAction(viewContainer, loggerName);
    }

    public static List<String> prepareLoggerNames(String loggerName) {
        if (loggerName == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> tokens = new ArrayList<String>();
        loggerName = loggerName.replace('$', '.');
        StringTokenizer tok = new StringTokenizer(loggerName, ".", false);
        while (tok.hasMoreTokens()) {
            String current = tok.nextToken();
            tokens.add(current);
        }
        ArrayList<String> result = new ArrayList<String>(tokens.size());
        for (int i = tokens.size(); i > 0; --i) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (int j = 0; j < i; ++j) {
                if (first) {
                    first = false;
                } else {
                    builder.append(".");
                }
                builder.append((String)tokens.get(j));
            }
            result.add(builder.toString());
        }
        return result;
    }
}

