/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.actions;

import de.huxhorn.lilith.conditions.MessagePatternEqualsCondition;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.swing.TextPreprocessor;
import de.huxhorn.lilith.swing.actions.AbstractLoggingFilterAction;
import de.huxhorn.sulky.conditions.Condition;

public class FocusMessagePatternAction
extends AbstractLoggingFilterAction {
    private static final long serialVersionUID = -4237035769242851225L;
    private String messagePattern;

    public FocusMessagePatternAction() {
        super("Message pattern");
    }

    protected void setMessagePattern(String messagePattern) {
        this.messagePattern = messagePattern;
        this.putValue("ShortDescription", TextPreprocessor.preformattedTooltip(TextPreprocessor.cropTextBlock(messagePattern)));
        this.setEnabled(messagePattern != null);
    }

    protected void updateState() {
        Message message;
        if (this.viewContainer == null) {
            this.setMessagePattern(null);
            return;
        }
        String messagePattern = null;
        if (this.loggingEvent != null && (message = this.loggingEvent.getMessage()) != null) {
            String formattedMessage = message.getMessage();
            messagePattern = message.getMessagePattern();
            if (formattedMessage != null && formattedMessage.equals(messagePattern)) {
                messagePattern = null;
            }
        }
        this.setMessagePattern(messagePattern);
    }

    public Condition resolveCondition() {
        if (this.messagePattern == null) {
            return null;
        }
        return new MessagePatternEqualsCondition(this.messagePattern);
    }
}

