/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.actions;

import de.huxhorn.lilith.conditions.FormattedMessageEqualsCondition;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.swing.TextPreprocessor;
import de.huxhorn.lilith.swing.actions.AbstractLoggingFilterAction;
import de.huxhorn.sulky.conditions.Condition;

public class FocusFormattedMessageAction
extends AbstractLoggingFilterAction {
    private static final long serialVersionUID = -1245643497938628684L;
    private String formattedMessage;

    public FocusFormattedMessageAction() {
        super("Formatted message");
    }

    protected void setFormattedMessage(String formattedMessage) {
        this.formattedMessage = formattedMessage;
        this.putValue("ShortDescription", TextPreprocessor.preformattedTooltip(TextPreprocessor.cropTextBlock(formattedMessage)));
        this.setEnabled(formattedMessage != null);
    }

    protected void updateState() {
        Message message;
        if (this.viewContainer == null) {
            this.setFormattedMessage(null);
            return;
        }
        String formattedMessage = null;
        if (this.loggingEvent != null && (message = this.loggingEvent.getMessage()) != null) {
            formattedMessage = message.getMessage();
        }
        this.setFormattedMessage(formattedMessage);
    }

    public Condition resolveCondition() {
        if (this.formattedMessage == null) {
            return null;
        }
        return new FormattedMessageEqualsCondition(this.formattedMessage);
    }
}

