/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.Lilith;
import de.huxhorn.lilith.conditions.CallLocationCondition;
import de.huxhorn.lilith.conditions.EventContainsCondition;
import de.huxhorn.lilith.conditions.FormattedMessageContainsCondition;
import de.huxhorn.lilith.conditions.FormattedMessageEqualsCondition;
import de.huxhorn.lilith.conditions.GroovyCondition;
import de.huxhorn.lilith.conditions.LevelCondition;
import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.LoggerContainsCondition;
import de.huxhorn.lilith.conditions.LoggerEqualsCondition;
import de.huxhorn.lilith.conditions.LoggerStartsWithCondition;
import de.huxhorn.lilith.conditions.MessagePatternContainsCondition;
import de.huxhorn.lilith.conditions.MessagePatternEqualsCondition;
import de.huxhorn.lilith.data.access.HttpStatus;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.prefs.LilithPreferences;
import de.huxhorn.lilith.swing.filefilters.GroovyConditionFileFilter;
import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.lilith.swing.table.ColorScheme;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.io.IOUtilities;
import de.huxhorn.sulky.swing.PersistentTableColumnModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPreferences {
    private static final Preferences PREFERENCES = Preferences.userNodeForPackage(ApplicationPreferences.class);
    private static final int MAX_PREV_SEARCHES = 15;
    private static final int MAX_RECENT_FILES = 15;
    private static final String PREVIOUS_SEARCH_STRINGS_XML_FILENAME = "previousSearchStrings.xml";
    private static final String RECENT_FILES_XML_FILENAME = "recentFiles.xml";
    public static final String STATUS_COLORS_XML_FILENAME = "statusColors.xml";
    public static final String LEVEL_COLORS_XML_FILENAME = "levelColors.xml";
    private static final String DETAILS_VIEW_ROOT_FOLDER = "detailsView";
    public static final String DETAILS_VIEW_CSS_FILENAME = "detailsView.css";
    public static final String DETAILS_VIEW_GROOVY_FILENAME = "detailsView.groovy";
    public static final String CONDITIONS_XML_FILENAME = "savedConditions.xml";
    public static final String STATUS_COLORS_PROPERTY = "statusColors";
    public static final String LEVEL_COLORS_PROPERTY = "levelColors";
    public static final String LOOK_AND_FEEL_PROPERTY = "lookAndFeel";
    public static final String CLEANING_LOGS_ON_EXIT_PROPERTY = "cleaningLogsOnExit";
    public static final String COLORING_WHOLE_ROW_PROPERTY = "coloringWholeRow";
    public static final String SHOWING_TOOLBAR_PROPERTY = "showingToolbar";
    public static final String SHOWING_STATUSBAR_PROPERTY = "showingStatusbar";
    public static final String SHOWING_IDENTIFIER_PROPERTY = "showingIdentifier";
    public static final String SHOWING_FULL_CALLSTACK_PROPERTY = "showingFullCallstack";
    public static final String USING_WRAPPED_EXCEPTION_STYLE_PROPERTY = "usingWrappedExceptionStyle";
    public static final String SHOWING_STACKTRACE_PROPERTY = "showingStackTrace";
    public static final String CHECKING_FOR_UPDATE_PROPERTY = "checkingForUpdate";
    public static final String CHECKING_FOR_SNAPSHOT_PROPERTY = "checkingForSnapshot";
    public static final String SOURCE_FILTERING_PROPERTY = "sourceFiltering";
    public static final String SOUND_LOCATIONS_PROPERTY = "soundLocations";
    public static final String SCALE_FACTOR_PROPERTY = "scaleFactor";
    public static final String MUTE_PROPERTY = "mute";
    public static final String USING_INTERNAL_FRAMES_PROPERTY = "usingInternalFrames";
    public static final String SCROLLING_TO_BOTTOM_PROPERTY = "scrollingToBottom";
    public static final String SOURCE_NAMES_PROPERTY = "sourceNames";
    public static final String APPLICATION_PATH_PROPERTY = "applicationPath";
    public static final String TRAY_ACTIVE_PROPERTY = "trayActive";
    public static final String HIDING_ON_CLOSE_PROPERTY = "hidingOnClose";
    public static final String AUTO_OPENING_PROPERTY = "autoOpening";
    public static final String AUTO_CLOSING_PROPERTY = "autoClosing";
    public static final String IMAGE_PATH_PROPERTY = "imagePath";
    public static final String SOUND_PATH_PROPERTY = "soundPath";
    public static final String AUTO_FOCUSING_WINDOW_PROPERTY = "autoFocusingWindow";
    public static final String SOURCE_LISTS_PROPERTY = "sourceLists";
    public static final String BLACK_LIST_NAME_PROPERTY = "blackListName";
    public static final String WHITE_LIST_NAME_PROPERTY = "whiteListName";
    public static final String CONDITIONS_PROPERTY = "conditions";
    public static final String SPLASH_SCREEN_DISABLED_PROPERTY = "splashScreenDisabled";
    public static final String ASKING_BEFORE_QUIT_PROPERTY = "askingBeforeQuit";
    public static final String CURRENT_TIP_OF_THE_DAY_PROPERTY = "currentTipOfTheDay";
    public static final String SHOWING_TIP_OF_THE_DAY_PROPERTY = "showingTipOfTheDay";
    public static final String MAXIMIZING_INTERNAL_FRAMES_PROPERTY = "maximizingInternalFrames";
    public static final String GLOBAL_LOGGING_ENABLED_PROPERTY = "globalLoggingEnabled";
    public static final String LOGGING_STATISTIC_ENABLED_PROPERTY = "loggingStatisticEnabled";
    public static final String PREVIOUS_SEARCH_STRINGS_PROPERTY = "previousSearchStrings";
    public static final String RECENT_FILES_PROPERTY = "recentFiles";
    public static final String SHOWING_FULL_RECENT_PATH_PROPERTY = "showingFullRecentPath";
    public static final String DEFAULT_CONDITION_NAME_PROPERTY = "defaultConditionName";
    public static final String LOGGING_LAYOUT_GLOBAL_XML_FILENAME = "loggingLayoutGlobal.xml";
    public static final String LOGGING_LAYOUT_XML_FILENAME = "loggingLayout.xml";
    public static final String ACCESS_LAYOUT_GLOBAL_XML_FILENAME = "accessLayoutGlobal.xml";
    public static final String ACCESS_LAYOUT_XML_FILENAME = "accessLayout.xml";
    public static final String SOURCE_NAMES_XML_FILENAME = "SourceNames.xml";
    public static final String SOURCE_LISTS_XML_FILENAME = "SourceLists.xml";
    public static final String SOURCE_NAMES_PROPERTIES_FILENAME = "SourceNames.properties";
    public static final String SOUND_LOCATIONS_XML_FILENAME = "SoundLocations.xml";
    public static final String PREVIOUS_APPLICATION_PATH_FILENAME = ".previous.application.path";
    private static final String OLD_LICENSED_PREFERENCES_KEY = "licensed";
    private static final String LICENSED_PREFERENCES_KEY = "licensedVersion";
    public static final String USER_HOME;
    public static final String DEFAULT_APPLICATION_PATH;
    private static final Map<String, String> DEFAULT_SOURCE_NAMES;
    private static final Map<String, String> DEFAULT_SOUND_LOCATIONS;
    private static final Map<LoggingEvent.Level, ColorScheme> DEFAULT_LEVEL_COLOR_SCHEMES;
    private static final Map<HttpStatus.Type, ColorScheme> DEFAULT_STATUS_COLOR_SCHEMES;
    private static final String PREVIOUS_OPEN_PATH_PROPERTY = "previousOpenPath";
    private static final String PREVIOUS_IMPORT_PATH_PROPERTY = "previousImportPath";
    private static final String PREVIOUS_EXPORT_PATH_PROPERTY = "previousExportPath";
    public static final String STARTUP_LOOK_AND_FEEL;
    private static final long CONDITIONS_CHECK_INTERVAL = 30000L;
    private static final String GROOVY_SUFFIX = ".groovy";
    private static final String EXAMPLE_GROOVY_CONDITIONS_BASE = "/conditions/";
    private static final String EXAMPLE_GROOVY_CLIPBOARD_FORMATTERS_BASE = "/clipboardFormatters/";
    private static final String GROOVY_EXAMPLE_LIST = "list.txt";
    public static final String SAVED_CONDITION = "Saved";
    private static final String[] DEFAULT_CONDITIONS;
    private static final String[] LEVEL_VALUES;
    private String[] clipboardFormatterScriptFiles;
    private long lastClipboardFormatterCheck;
    private static final LilithPreferences DEFAULT_VALUES;
    private final Logger logger = LoggerFactory.getLogger(ApplicationPreferences.class);
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private File startupApplicationPath = this.getApplicationPath();
    private File detailsViewRoot;
    private List<String> installedLookAndFeels = new ArrayList<String>();
    private String[] conditionScriptFiles;
    private long lastConditionsCheck;
    private Map<LoggingEvent.Level, ColorScheme> levelColors;
    private Map<HttpStatus.Type, ColorScheme> statusColors;
    private URL detailsViewRootUrl;
    private Map<String, String> sourceNames;
    private long lastSourceNamesModified = -1L;
    private long lastConditionsModified = -1L;
    private Map<String, String> soundLocations;
    private long lastSoundLocationsModified;
    private Map<String, Set<String>> sourceLists;
    private long lastSourceListsModified;
    private LilithPreferences.SourceFiltering sourceFiltering;
    private Set<String> blackList;
    private Set<String> whiteList;
    private List<SavedCondition> conditions;
    private List<String> previousSearchStrings;
    private List<String> recentFiles;
    private File groovyConditionsPath;
    private File groovyClipboardFormattersPath;

    public Condition createCondition(String conditionName, String value) {
        if (conditionName == null) {
            throw new NullPointerException("conditionName must not be null!");
        }
        if ("event.contains".equals(conditionName)) {
            return new EventContainsCondition(value);
        }
        if ("Level>=".equals(conditionName)) {
            boolean found = false;
            for (String current : LEVEL_VALUES) {
                if (!current.equalsIgnoreCase(value)) continue;
                value = current;
                found = true;
            }
            if (found) {
                return new LevelCondition(value);
            }
            throw new IllegalArgumentException("Unknown level value '" + value + "'!");
        }
        if ("message.contains".equals(conditionName)) {
            return new FormattedMessageContainsCondition(value);
        }
        if ("message.equals".equals(conditionName)) {
            return new FormattedMessageEqualsCondition(value);
        }
        if ("messagePattern.contains".equals(conditionName)) {
            return new MessagePatternContainsCondition(value);
        }
        if ("messagePattern.equals".equals(conditionName)) {
            return new MessagePatternEqualsCondition(value);
        }
        if ("logger.startsWith".equals(conditionName)) {
            return new LoggerStartsWithCondition(value);
        }
        if ("logger.contains".equals(conditionName)) {
            return new LoggerContainsCondition(value);
        }
        if ("logger.equals".equals(conditionName)) {
            return new LoggerEqualsCondition(value);
        }
        if ("CallLocation".equals(conditionName)) {
            return new CallLocationCondition(value);
        }
        if (SAVED_CONDITION.equals(conditionName)) {
            SavedCondition savedCondition = this.resolveSavedCondition(value);
            if (savedCondition != null) {
                return savedCondition.getCondition();
            }
            throw new IllegalArgumentException("Couldn't find saved condition named '" + value + "'.");
        }
        File resolvedScriptFile = this.resolveGroovyConditionScriptFile(conditionName);
        if (resolvedScriptFile != null) {
            return new GroovyCondition(resolvedScriptFile.getAbsolutePath(), value);
        }
        throw new IllegalArgumentException("Couldn't find condition '" + conditionName + "'!");
    }

    public String resolveConditionName(Condition condition) {
        if (condition instanceof GroovyCondition) {
            GroovyCondition groovyCondition = (GroovyCondition)condition;
            String scriptFileName = groovyCondition.getScriptFileName();
            if (scriptFileName != null) {
                File scriptFile = new File(scriptFileName);
                return scriptFile.getName();
            }
            return null;
        }
        if (condition instanceof LilithCondition) {
            return ((LilithCondition)condition).getDescription();
        }
        return null;
    }

    public List<String> retrieveLevelValues() {
        return Arrays.asList(LEVEL_VALUES);
    }

    public List<String> retrieveAllConditions() {
        ArrayList<String> itemsVector = new ArrayList<String>();
        itemsVector.addAll(Arrays.asList(DEFAULT_CONDITIONS));
        String[] groovyConditions = this.getAllGroovyConditionScriptFiles();
        if (groovyConditions != null) {
            itemsVector.addAll(Arrays.asList(groovyConditions));
        }
        return itemsVector;
    }

    public ApplicationPreferences() {
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            this.installedLookAndFeels.add(info.getName());
        }
        Collections.sort(this.installedLookAndFeels);
        this.groovyConditionsPath = new File(this.startupApplicationPath, CONDITIONS_PROPERTY);
        if (this.groovyConditionsPath.mkdirs()) {
            this.installExampleConditions();
        }
        this.groovyClipboardFormattersPath = new File(this.startupApplicationPath, "clipboardFormatters");
        if (this.groovyClipboardFormattersPath.mkdirs()) {
            this.installExampleClipboardFormatters();
        }
    }

    public File getGroovyConditionsPath() {
        return this.groovyConditionsPath;
    }

    public File getGroovyClipboardFormattersPath() {
        return this.groovyClipboardFormattersPath;
    }

    public void addRecentFile(File dataFile) {
        if (dataFile == null) {
            return;
        }
        if (!(dataFile.isFile() && dataFile.canRead() || !this.logger.isWarnEnabled())) {
            this.logger.warn("Tried to add invalid recent file.");
        }
        String absName = dataFile.getAbsolutePath();
        List<String> recents = this.getRecentFiles();
        recents.remove(absName);
        recents.add(0, absName);
        this.setRecentFiles(recents);
    }

    public void removeRecentFile(File dataFile) {
        if (dataFile == null) {
            return;
        }
        String absName = dataFile.getAbsolutePath();
        List<String> recents = this.getRecentFiles();
        recents.remove(absName);
        this.setRecentFiles(recents);
    }

    private void setRecentFiles(List<String> recents) {
        ArrayList<Object> copy = recents == null ? new ArrayList() : new ArrayList<String>(recents);
        Iterator iter = copy.iterator();
        while (iter.hasNext()) {
            String current = (String)iter.next();
            File f = new File(current);
            if (f.isFile() && f.canRead()) continue;
            iter.remove();
        }
        List<String> oldValue = this.getRecentFiles();
        while (copy.size() > 15) {
            copy.remove(15);
        }
        this.writeRecentFiles(copy);
        List<String> newValue = this.getRecentFiles();
        this.propertyChangeSupport.firePropertyChange(RECENT_FILES_PROPERTY, oldValue, newValue);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("recentFiles set to {}.", newValue);
        }
    }

    public void clearRecentFiles() {
        this.setRecentFiles(new ArrayList<String>());
    }

    public List<String> getRecentFiles() {
        this.initRecentFiles();
        return new ArrayList<String>(this.recentFiles);
    }

    public void clearPreviousSearchStrings() {
        this.setPreviousSearchStrings(new ArrayList<String>());
    }

    private static <T> List<T> transformToList(Class<T> iface, Object obj) {
        Logger logger = LoggerFactory.getLogger(ApplicationPreferences.class);
        ArrayList<T> resultList = null;
        if (obj instanceof List) {
            List list = (List)obj;
            resultList = new ArrayList<T>(list.size());
            for (Object current : list) {
                if (iface.isInstance(current)) {
                    resultList.add(iface.cast(current));
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Expected {} but got {}!", (Object)iface.getName(), current);
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn("Expected List but got {}!", obj);
        }
        return resultList;
    }

    private static <T> Set<T> transformToSet(Class<T> iface, Object obj) {
        Logger logger = LoggerFactory.getLogger(ApplicationPreferences.class);
        HashSet<T> resultSet = null;
        if (obj instanceof Set) {
            Set set = (Set)obj;
            resultSet = new HashSet<T>(set.size());
            for (Object current : set) {
                if (iface.isInstance(current)) {
                    resultSet.add(iface.cast(current));
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Expected {} but got {}!", (Object)iface.getName(), current);
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn("Expected Set but got {}!", obj);
        }
        return resultSet;
    }

    private static <K, V> Map<K, V> transformToMap(Class<K> keyClass, Class<V> valueClass, Object obj) {
        Logger logger = LoggerFactory.getLogger(ApplicationPreferences.class);
        HashMap<K, V> resultMap = null;
        if (obj instanceof Map) {
            Map map = (Map)obj;
            resultMap = new HashMap<K, V>(map.size());
            Iterator i$ = map.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry c;
                Map.Entry current = c = i$.next();
                Object key = current.getKey();
                Object value = current.getValue();
                if (!keyClass.isInstance(key)) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Expected {} as key but got {}!", (Object)keyClass.getName(), key);
                    continue;
                }
                if (!valueClass.isInstance(value)) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Expected {} as value but got {}!", (Object)valueClass.getName(), value);
                    continue;
                }
                resultMap.put(keyClass.cast(key), valueClass.cast(value));
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn("Expected Map but got {}!", obj);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRecentFiles() {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, RECENT_FILES_XML_FILENAME);
        if (file.isFile() && this.recentFiles == null) {
            XMLDecoder d = null;
            try {
                d = new XMLDecoder(new BufferedInputStream(new FileInputStream(file)));
                this.recentFiles = ApplicationPreferences.transformToList(String.class, d.readObject());
            }
            catch (Throwable ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while loading recentFiles from file '" + file.getAbsolutePath() + "'!", ex);
                }
                IOUtilities.interruptIfNecessary((Throwable)ex);
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        if (this.recentFiles == null) {
            this.recentFiles = new ArrayList<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeRecentFiles(List<String> recentFiles) {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, RECENT_FILES_XML_FILENAME);
        XMLEncoder e = null;
        FileNotFoundException error = null;
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            e = new XMLEncoder(bos);
            e.writeObject(recentFiles);
        }
        catch (FileNotFoundException ex) {
            error = ex;
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
        this.recentFiles = null;
        if (error != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while writing recentFiles!", (Throwable)error);
            }
            return false;
        }
        return true;
    }

    public void addPreviousSearchString(String searchString) {
        if (searchString == null) {
            return;
        }
        if (searchString.trim().length() == 0) {
            return;
        }
        List<String> previousSearchStrings = this.getPreviousSearchStrings();
        if (previousSearchStrings.contains(searchString)) {
            previousSearchStrings.remove(searchString);
        }
        previousSearchStrings.add(0, searchString);
        this.setPreviousSearchStrings(previousSearchStrings);
    }

    private void setPreviousSearchStrings(List<String> previousSearchStrings) {
        List<String> oldValue = this.getPreviousSearchStrings();
        while (previousSearchStrings.size() > 15) {
            previousSearchStrings.remove(15);
        }
        this.writePreviousSearchStrings(previousSearchStrings);
        List<String> newValue = this.getPreviousSearchStrings();
        this.propertyChangeSupport.firePropertyChange(PREVIOUS_SEARCH_STRINGS_PROPERTY, oldValue, newValue);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("previousSearchStrings set to {}.", newValue);
        }
    }

    public List<String> getPreviousSearchStrings() {
        this.initPreviousSearchStrings();
        return new ArrayList<String>(this.previousSearchStrings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPreviousSearchStrings() {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, PREVIOUS_SEARCH_STRINGS_XML_FILENAME);
        if (file.isFile() && this.previousSearchStrings == null) {
            XMLDecoder d = null;
            try {
                d = new XMLDecoder(new BufferedInputStream(new FileInputStream(file)));
                this.previousSearchStrings = ApplicationPreferences.transformToList(String.class, d.readObject());
            }
            catch (Throwable ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while loading previous search strings from file '" + file.getAbsolutePath() + "'!", ex);
                }
                IOUtilities.interruptIfNecessary((Throwable)ex);
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        if (this.previousSearchStrings == null) {
            this.previousSearchStrings = new ArrayList<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writePreviousSearchStrings(List<String> searchStrings) {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, PREVIOUS_SEARCH_STRINGS_XML_FILENAME);
        XMLEncoder e = null;
        FileNotFoundException error = null;
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            e = new XMLEncoder(bos);
            e.writeObject(searchStrings);
        }
        catch (FileNotFoundException ex) {
            error = ex;
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
        this.previousSearchStrings = null;
        if (error != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while writing previous search strings!", (Throwable)error);
            }
            return false;
        }
        return true;
    }

    public File resolveGroovyConditionScriptFile(String input) {
        File scriptFile;
        if (input == null) {
            return null;
        }
        if (!input.endsWith(GROOVY_SUFFIX)) {
            input = input + GROOVY_SUFFIX;
        }
        if ((scriptFile = new File(this.groovyConditionsPath, input)).isFile()) {
            return scriptFile;
        }
        return null;
    }

    public String[] getAllGroovyConditionScriptFiles() {
        File[] groovyFiles;
        if ((this.conditionScriptFiles == null || System.currentTimeMillis() - this.lastConditionsCheck > 30000L) && (groovyFiles = this.groovyConditionsPath.listFiles(new GroovyConditionFileFilter())) != null && groovyFiles.length > 0) {
            this.conditionScriptFiles = new String[groovyFiles.length];
            for (int i = 0; i < groovyFiles.length; ++i) {
                File current = groovyFiles[i];
                this.conditionScriptFiles[i] = current.getName();
            }
            Arrays.sort(this.conditionScriptFiles);
            this.lastConditionsCheck = System.currentTimeMillis();
        }
        return this.conditionScriptFiles;
    }

    public File resolveClipboardFormatterScriptFile(String input) {
        File scriptFile;
        if (input == null) {
            return null;
        }
        if (!input.endsWith(GROOVY_SUFFIX)) {
            input = input + GROOVY_SUFFIX;
        }
        if ((scriptFile = new File(this.groovyClipboardFormattersPath, input)).isFile()) {
            return scriptFile;
        }
        return null;
    }

    public String[] getClipboardFormatterScriptFiles() {
        if (this.clipboardFormatterScriptFiles == null || System.currentTimeMillis() - this.lastClipboardFormatterCheck > 30000L) {
            File[] groovyFiles = this.groovyClipboardFormattersPath.listFiles(new GroovyConditionFileFilter());
            if (groovyFiles != null && groovyFiles.length > 0) {
                this.clipboardFormatterScriptFiles = new String[groovyFiles.length];
                for (int i = 0; i < groovyFiles.length; ++i) {
                    File current = groovyFiles[i];
                    this.clipboardFormatterScriptFiles[i] = current.getName();
                }
                Arrays.sort(this.clipboardFormatterScriptFiles);
                this.lastClipboardFormatterCheck = System.currentTimeMillis();
            } else {
                this.clipboardFormatterScriptFiles = null;
            }
        }
        return this.clipboardFormatterScriptFiles;
    }

    public void installExampleConditions() {
        String path = "/conditions/list.txt";
        URL url = ApplicationPreferences.class.getResource(path);
        if (url == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Couldn't find resource at {}!", (Object)path);
            }
        } else {
            List<String> lines = this.readLines(url);
            for (String current : lines) {
                path = EXAMPLE_GROOVY_CONDITIONS_BASE + current;
                url = ApplicationPreferences.class.getResource(path);
                if (url == null) {
                    if (!this.logger.isErrorEnabled()) continue;
                    this.logger.error("Couldn't find resource at {}!", (Object)path);
                    continue;
                }
                File target = new File(this.groovyConditionsPath, current);
                this.copy(url, target, true);
            }
        }
    }

    public void installExampleClipboardFormatters() {
        String path = "/clipboardFormatters/list.txt";
        URL url = ApplicationPreferences.class.getResource(path);
        if (url == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Couldn't find resource at {}!", (Object)path);
            }
        } else {
            List<String> lines = this.readLines(url);
            for (String current : lines) {
                path = EXAMPLE_GROOVY_CLIPBOARD_FORMATTERS_BASE + current;
                url = ApplicationPreferences.class.getResource(path);
                if (url == null) {
                    if (!this.logger.isErrorEnabled()) continue;
                    this.logger.error("Couldn't find resource at {}!", (Object)path);
                    continue;
                }
                File target = new File(this.groovyClipboardFormattersPath, current);
                this.copy(url, target, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLevelColors() {
        File appPath;
        File levelColorsFile;
        if (this.levelColors == null && (levelColorsFile = new File(appPath = this.getStartupApplicationPath(), LEVEL_COLORS_XML_FILENAME)).isFile()) {
            XMLDecoder d = null;
            try {
                d = new XMLDecoder(new BufferedInputStream(new FileInputStream(levelColorsFile)));
                this.levelColors = ApplicationPreferences.transformToMap(LoggingEvent.Level.class, ColorScheme.class, d.readObject());
            }
            catch (Throwable ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while loading Level-ColorSchemes from file '" + levelColorsFile.getAbsolutePath() + "'!", ex);
                }
                this.levelColors = null;
                IOUtilities.interruptIfNecessary((Throwable)ex);
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        if (this.levelColors != null && this.levelColors.size() != DEFAULT_LEVEL_COLOR_SCHEMES.size()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Reverting Level-ColorSchemes to defaults.");
            }
            this.levelColors = null;
        }
        if (this.levelColors == null) {
            this.levelColors = this.cloneLevelColors(DEFAULT_LEVEL_COLOR_SCHEMES);
        }
    }

    private Map<LoggingEvent.Level, ColorScheme> cloneLevelColors(Map<LoggingEvent.Level, ColorScheme> input) {
        if (input != null && input.size() != DEFAULT_LEVEL_COLOR_SCHEMES.size()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Reverting Level-ColorSchemes to defaults.");
            }
            input = null;
        }
        if (input == null) {
            input = DEFAULT_LEVEL_COLOR_SCHEMES;
        }
        HashMap<LoggingEvent.Level, ColorScheme> result = new HashMap<LoggingEvent.Level, ColorScheme>();
        for (Map.Entry<LoggingEvent.Level, ColorScheme> current : input.entrySet()) {
            try {
                result.put(current.getKey(), current.getValue().clone());
            }
            catch (CloneNotSupportedException ex) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error("Exception while cloning Level-ColorScheme!!", (Throwable)ex);
            }
        }
        return result;
    }

    public void setLevelColors(Map<LoggingEvent.Level, ColorScheme> colors) {
        Map<LoggingEvent.Level, ColorScheme> oldValue = this.getLevelColors();
        colors = this.cloneLevelColors(colors);
        this.writeLevelColors(colors);
        this.levelColors = colors;
        Map<LoggingEvent.Level, ColorScheme> newValue = this.getLevelColors();
        this.propertyChangeSupport.firePropertyChange(LEVEL_COLORS_PROPERTY, oldValue, newValue);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("LevelColors set to {}.", this.levelColors);
        }
    }

    private void writeLevelColors(Map<LoggingEvent.Level, ColorScheme> colors) {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, LEVEL_COLORS_XML_FILENAME);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            XMLEncoder e = new XMLEncoder(bos);
            EnumPersistenceDelegate delegate = new EnumPersistenceDelegate();
            e.setPersistenceDelegate(LoggingEvent.Level.class, delegate);
            e.writeObject(colors);
            e.close();
        }
        catch (Throwable ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while writing colors!", ex);
            }
            IOUtilities.interruptIfNecessary((Throwable)ex);
        }
    }

    public Map<LoggingEvent.Level, ColorScheme> getLevelColors() {
        if (this.levelColors == null) {
            this.initLevelColors();
        }
        return this.cloneLevelColors(this.levelColors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStatusColors() {
        File appPath;
        File statusColorsFile;
        if (this.statusColors == null && (statusColorsFile = new File(appPath = this.getStartupApplicationPath(), STATUS_COLORS_XML_FILENAME)).isFile()) {
            XMLDecoder d = null;
            try {
                d = new XMLDecoder(new BufferedInputStream(new FileInputStream(statusColorsFile)));
                this.statusColors = ApplicationPreferences.transformToMap(HttpStatus.Type.class, ColorScheme.class, d.readObject());
            }
            catch (Throwable ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while loading status Status-ColorSchemes from file '" + statusColorsFile.getAbsolutePath() + "'!", ex);
                }
                this.statusColors = null;
                IOUtilities.interruptIfNecessary((Throwable)ex);
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        if (this.statusColors != null && this.statusColors.size() != DEFAULT_STATUS_COLOR_SCHEMES.size()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Reverting Status-ColorSchemes to defaults.");
            }
            this.statusColors = null;
        }
        if (this.statusColors == null) {
            this.statusColors = this.cloneStatusColors(DEFAULT_STATUS_COLOR_SCHEMES);
        }
    }

    private Map<HttpStatus.Type, ColorScheme> cloneStatusColors(Map<HttpStatus.Type, ColorScheme> input) {
        if (input != null && input.size() != DEFAULT_STATUS_COLOR_SCHEMES.size()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Reverting Status-ColorSchemes to defaults.");
            }
            input = null;
        }
        if (input == null) {
            input = DEFAULT_STATUS_COLOR_SCHEMES;
        }
        HashMap<HttpStatus.Type, ColorScheme> result = new HashMap<HttpStatus.Type, ColorScheme>();
        for (Map.Entry<HttpStatus.Type, ColorScheme> current : input.entrySet()) {
            try {
                result.put(current.getKey(), current.getValue().clone());
            }
            catch (CloneNotSupportedException ex) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error("Exception while cloning Status-ColorScheme!!", (Throwable)ex);
            }
        }
        return result;
    }

    public void setStatusColors(Map<HttpStatus.Type, ColorScheme> colors) {
        Map<HttpStatus.Type, ColorScheme> oldValue = this.getStatusColors();
        colors = this.cloneStatusColors(colors);
        this.writeStatusColors(colors);
        this.statusColors = colors;
        Map<HttpStatus.Type, ColorScheme> newValue = this.getStatusColors();
        this.propertyChangeSupport.firePropertyChange(STATUS_COLORS_PROPERTY, oldValue, newValue);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("StatusColors set to {}.", this.statusColors);
        }
    }

    private void writeStatusColors(Map<HttpStatus.Type, ColorScheme> colors) {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, STATUS_COLORS_XML_FILENAME);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            XMLEncoder e = new XMLEncoder(bos);
            EnumPersistenceDelegate delegate = new EnumPersistenceDelegate();
            e.setPersistenceDelegate(HttpStatus.Type.class, delegate);
            e.writeObject(colors);
            e.close();
        }
        catch (Throwable ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while writing colors!", ex);
            }
            IOUtilities.interruptIfNecessary((Throwable)ex);
        }
    }

    public Map<HttpStatus.Type, ColorScheme> getStatusColors() {
        if (this.statusColors == null) {
            this.initStatusColors();
        }
        return this.cloneStatusColors(this.statusColors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSourceLists() {
        File appPath = this.getStartupApplicationPath();
        File sourceListsFile = new File(appPath, SOURCE_LISTS_XML_FILENAME);
        if (sourceListsFile.isFile()) {
            long lastModified = sourceListsFile.lastModified();
            if (this.sourceLists != null && this.lastSourceListsModified >= lastModified) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Won't reload source lists.");
                }
                return;
            }
            XMLDecoder d = null;
            try {
                d = new XMLDecoder(new BufferedInputStream(new FileInputStream(sourceListsFile)));
                Map<String, Set> interimMap = ApplicationPreferences.transformToMap(String.class, Set.class, d.readObject());
                HashMap<String, Set<String>> resultMap = null;
                if (interimMap != null) {
                    resultMap = new HashMap<String, Set<String>>();
                    for (Map.Entry<String, Set> current : interimMap.entrySet()) {
                        Set<String> value = ApplicationPreferences.transformToSet(String.class, current.getValue());
                        if (value == null) continue;
                        resultMap.put(current.getKey(), value);
                    }
                }
                this.sourceLists = resultMap;
                this.lastSourceListsModified = lastModified;
            }
            catch (Throwable ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while loading source lists from sourceListsFile '" + sourceListsFile.getAbsolutePath() + "'!", ex);
                }
                this.sourceLists = new HashMap<String, Set<String>>();
                IOUtilities.interruptIfNecessary((Throwable)ex);
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        } else if (this.sourceLists == null) {
            this.sourceLists = new HashMap<String, Set<String>>();
        }
    }

    public Map<String, Set<String>> getSourceLists() {
        this.initSourceLists();
        return new HashMap<String, Set<String>>(this.sourceLists);
    }

    public void setSourceLists(Map<String, Set<String>> sourceLists) {
        Map<String, Set<String>> oldValue = this.getSourceLists();
        this.writeSourceLists(sourceLists);
        Map<String, Set<String>> newValue = this.getSourceLists();
        this.blackList = null;
        this.whiteList = null;
        this.propertyChangeSupport.firePropertyChange(SOURCE_LISTS_PROPERTY, oldValue, newValue);
        if (sourceLists == null) {
            this.setSourceFiltering(LilithPreferences.SourceFiltering.NONE);
            this.setWhiteListName("");
            this.setBlackListName("");
        } else {
            String whiteListName;
            String blackListName = this.getBlackListName();
            if (sourceLists.get(blackListName) == null) {
                this.setBlackListName("");
                if (this.getSourceFiltering() == LilithPreferences.SourceFiltering.BLACKLIST) {
                    this.setSourceFiltering(LilithPreferences.SourceFiltering.NONE);
                }
            }
            if (sourceLists.get(whiteListName = this.getWhiteListName()) == null) {
                this.setWhiteListName("");
                if (this.getSourceFiltering() == LilithPreferences.SourceFiltering.WHITELIST) {
                    this.setSourceFiltering(LilithPreferences.SourceFiltering.NONE);
                }
            }
        }
    }

    public void setSourceFiltering(LilithPreferences.SourceFiltering sourceFiltering) {
        LilithPreferences.SourceFiltering oldValue = this.getSourceFiltering();
        PREFERENCES.put(SOURCE_FILTERING_PROPERTY, sourceFiltering.toString());
        this.sourceFiltering = sourceFiltering;
        this.propertyChangeSupport.firePropertyChange(SOURCE_FILTERING_PROPERTY, oldValue, sourceFiltering);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("SourceFiltering set to {}.", (Object)this.sourceFiltering);
        }
    }

    public LilithPreferences.SourceFiltering getSourceFiltering() {
        if (this.sourceFiltering != null) {
            return this.sourceFiltering;
        }
        String sf = PREFERENCES.get(SOURCE_FILTERING_PROPERTY, "NONE");
        try {
            this.sourceFiltering = LilithPreferences.SourceFiltering.valueOf((String)sf);
        }
        catch (IllegalArgumentException e) {
            this.sourceFiltering = LilithPreferences.SourceFiltering.NONE;
        }
        return this.sourceFiltering;
    }

    public void initDetailsViewRoot(boolean overwriteAlways) {
        this.detailsViewRoot = new File(this.startupApplicationPath, DETAILS_VIEW_ROOT_FOLDER);
        if (this.detailsViewRoot.mkdirs() && this.logger.isInfoEnabled()) {
            this.logger.info("Created directory {}.", (Object)this.detailsViewRoot.getAbsolutePath());
        }
        try {
            this.detailsViewRootUrl = this.detailsViewRoot.toURI().toURL();
        }
        catch (MalformedURLException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while creating detailsViewRootUrl for '{}'!", (Object)this.detailsViewRoot.getAbsolutePath());
            }
            this.detailsViewRootUrl = null;
        }
        String resourcePath = "/detailsView/detailsView.css";
        String historyBasePath = "/detailsView/history/detailsView.css/";
        File detailsViewCssFile = new File(this.detailsViewRoot, DETAILS_VIEW_CSS_FILENAME);
        this.initIfNecessary(detailsViewCssFile, resourcePath, historyBasePath, overwriteAlways);
        resourcePath = "/detailsView/detailsView.groovy";
        historyBasePath = "/detailsView/history/detailsView.groovy/";
        File detailsViewGroovyFile = new File(this.detailsViewRoot, DETAILS_VIEW_GROOVY_FILENAME);
        this.initIfNecessary(detailsViewGroovyFile, resourcePath, historyBasePath, overwriteAlways);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNecessary(File file, String resourcePath, String historyBasePath, boolean overwriteAlways) {
        boolean delete = false;
        if (overwriteAlways) {
            delete = true;
        } else if (file.isFile()) {
            byte[] available = null;
            try {
                FileInputStream availableFile = new FileInputStream(file);
                available = ApplicationPreferences.getMD5(availableFile);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            byte[] current = ApplicationPreferences.getMD5(ApplicationPreferences.class.getResourceAsStream(resourcePath));
            if (Arrays.equals(available, current)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("The current version of {} is also the latest version.", (Object)file.getAbsolutePath());
                }
                return;
            }
            if (available != null) {
                URL historyUrl = this.getClass().getResource(historyBasePath + "history.txt");
                if (historyUrl != null) {
                    List<String> historyList = this.readLines(historyUrl);
                    for (String currentLine : historyList) {
                        InputStream is = this.getClass().getResourceAsStream(historyBasePath + currentLine + ".md5");
                        if (is == null) continue;
                        DataInputStream dis = new DataInputStream(is);
                        byte[] checksum = new byte[16];
                        try {
                            dis.readFully(checksum);
                            if (!Arrays.equals(available, checksum)) continue;
                            if (this.logger.isInfoEnabled()) {
                                this.logger.info("Found old version of {}: {}", (Object)file.getAbsolutePath(), (Object)currentLine);
                            }
                            delete = true;
                            break;
                        }
                        catch (IOException e) {
                            if (!this.logger.isWarnEnabled()) continue;
                            this.logger.warn("Exception while reading checksum of {}!", (Object)currentLine, (Object)e);
                        }
                        finally {
                            try {
                                dis.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            } else {
                delete = true;
            }
        }
        URL resourceUrl = ApplicationPreferences.class.getResource(resourcePath);
        if (resourceUrl == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Couldn't find resource {}!", (Object)resourcePath);
            }
            return;
        }
        this.copy(resourceUrl, file, delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(URL source, File target, boolean overwrite) {
        block12: {
            block13: {
                FileOutputStream os;
                InputStream is;
                block10: {
                    if (overwrite && target.isFile()) {
                        if (target.delete()) {
                            if (this.logger.isInfoEnabled()) {
                                this.logger.info("Deleted {}. ", (Object)target.getAbsolutePath());
                            }
                        } else if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Tried to delete {} but couldn't!", (Object)target.getAbsolutePath());
                        }
                    }
                    if (target.isFile()) break block13;
                    is = null;
                    os = null;
                    try {
                        os = new FileOutputStream(target);
                        is = source.openStream();
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                        if (!this.logger.isInfoEnabled()) break block10;
                        this.logger.info("Initialized file at '{}' with data from '{}'.", (Object)target.getAbsolutePath(), (Object)source);
                    }
                    catch (IOException e) {
                        block11: {
                            try {
                                if (!this.logger.isWarnEnabled()) break block11;
                                this.logger.warn("Exception while initializing '" + target.getAbsolutePath() + "' with data from '" + source + "'.!", (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                IOUtilities.closeQuietly(is);
                                IOUtilities.closeQuietly((OutputStream)os);
                                throw throwable;
                            }
                        }
                        IOUtilities.closeQuietly((InputStream)is);
                        IOUtilities.closeQuietly((OutputStream)os);
                        break block12;
                    }
                }
                IOUtilities.closeQuietly((InputStream)is);
                IOUtilities.closeQuietly((OutputStream)os);
                break block12;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Won't overwrite '{}'.", (Object)target.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readLines(URL url) {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String currentLine;
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((currentLine = reader.readLine()) != null) {
                if ("".equals(currentLine = currentLine.trim()) || currentLine.startsWith("#")) continue;
                result.add(currentLine);
            }
        }
        catch (IOException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while reading lines from {}!", (Object)url, (Object)e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    public File getDetailsViewRoot() {
        if (this.detailsViewRoot != null) {
            return this.detailsViewRoot;
        }
        this.initDetailsViewRoot(false);
        return this.detailsViewRoot;
    }

    public URL getDetailsViewRootUrl() {
        if (this.detailsViewRootUrl != null) {
            return this.detailsViewRootUrl;
        }
        this.initDetailsViewRoot(false);
        return this.detailsViewRootUrl;
    }

    public boolean isValidSource(String source) {
        if (source == null) {
            return false;
        }
        LilithPreferences.SourceFiltering filtering = this.getSourceFiltering();
        switch (filtering) {
            case BLACKLIST: {
                return !this.isBlackListed(source);
            }
            case WHITELIST: {
                return this.isWhiteListed(source);
            }
        }
        return true;
    }

    public boolean isBlackListed(String source) {
        if (this.blackList == null) {
            String listName = this.getBlackListName();
            this.initSourceLists();
            this.blackList = this.sourceLists.get(listName);
            if (this.blackList == null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Couldn't find source list '{}'!", (Object)listName);
                }
                this.setSourceFiltering(LilithPreferences.SourceFiltering.NONE);
                this.setBlackListName("");
                return true;
            }
        }
        return this.blackList.contains(source);
    }

    public void setBlackListName(String name) {
        String oldValue = this.getBlackListName();
        PREFERENCES.put(BLACK_LIST_NAME_PROPERTY, name);
        String newValue = this.getBlackListName();
        this.propertyChangeSupport.firePropertyChange(BLACK_LIST_NAME_PROPERTY, oldValue, newValue);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("BlackListName set to {}.", (Object)newValue);
        }
    }

    public String getBlackListName() {
        return PREFERENCES.get(BLACK_LIST_NAME_PROPERTY, "");
    }

    public boolean isWhiteListed(String source) {
        if (this.whiteList == null) {
            String listName = this.getWhiteListName();
            this.initSourceLists();
            this.whiteList = this.sourceLists.get(listName);
            if (this.whiteList == null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Couldn't find source list '{}'!", (Object)listName);
                }
                this.setSourceFiltering(LilithPreferences.SourceFiltering.NONE);
                this.setWhiteListName("");
                return true;
            }
        }
        return this.whiteList.contains(source);
    }

    public void setWhiteListName(String name) {
        String oldValue = this.getWhiteListName();
        PREFERENCES.put(WHITE_LIST_NAME_PROPERTY, name);
        String newValue = this.getWhiteListName();
        this.propertyChangeSupport.firePropertyChange(WHITE_LIST_NAME_PROPERTY, oldValue, newValue);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("WhiteListName set to {}.", (Object)newValue);
        }
    }

    public String getWhiteListName() {
        return PREFERENCES.get(WHITE_LIST_NAME_PROPERTY, "");
    }

    public void setLookAndFeel(String name) {
        String oldValue = this.getLookAndFeel();
        PREFERENCES.put(LOOK_AND_FEEL_PROPERTY, name);
        String newValue = this.getLookAndFeel();
        this.propertyChangeSupport.firePropertyChange(LOOK_AND_FEEL_PROPERTY, oldValue, newValue);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("LookAndFeel set to {}.", (Object)newValue);
        }
    }

    public String getLookAndFeel() {
        String result = PREFERENCES.get(LOOK_AND_FEEL_PROPERTY, STARTUP_LOOK_AND_FEEL);
        if (!this.installedLookAndFeels.contains(result)) {
            result = STARTUP_LOOK_AND_FEEL;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Look and Feel corrected to \"{}\".", (Object)result);
            }
        }
        return result;
    }

    public void setCurrentTipOfTheDay(int currentTipOfTheDay) {
        Integer oldValue = this.getCurrentTipOfTheDay();
        PREFERENCES.putInt(CURRENT_TIP_OF_THE_DAY_PROPERTY, currentTipOfTheDay);
        Integer newValue = this.getCurrentTipOfTheDay();
        this.propertyChangeSupport.firePropertyChange(CURRENT_TIP_OF_THE_DAY_PROPERTY, oldValue, newValue);
    }

    public int getCurrentTipOfTheDay() {
        return PREFERENCES.getInt(CURRENT_TIP_OF_THE_DAY_PROPERTY, -1);
    }

    public void setShowingTipOfTheDay(boolean showingTipOfTheDay) {
        Boolean oldValue = this.isShowingTipOfTheDay();
        PREFERENCES.putBoolean(SHOWING_TIP_OF_THE_DAY_PROPERTY, showingTipOfTheDay);
        Boolean newValue = this.isShowingTipOfTheDay();
        this.propertyChangeSupport.firePropertyChange(SHOWING_TIP_OF_THE_DAY_PROPERTY, oldValue, newValue);
    }

    public boolean isShowingTipOfTheDay() {
        return PREFERENCES.getBoolean(SHOWING_TIP_OF_THE_DAY_PROPERTY, DEFAULT_VALUES.isShowingTipOfTheDay());
    }

    public void setMaximizingInternalFrames(boolean showingTipOfTheDay) {
        Boolean oldValue = this.isMaximizingInternalFrames();
        PREFERENCES.putBoolean(MAXIMIZING_INTERNAL_FRAMES_PROPERTY, showingTipOfTheDay);
        Boolean newValue = this.isMaximizingInternalFrames();
        this.propertyChangeSupport.firePropertyChange(MAXIMIZING_INTERNAL_FRAMES_PROPERTY, oldValue, newValue);
    }

    public boolean isMaximizingInternalFrames() {
        return PREFERENCES.getBoolean(MAXIMIZING_INTERNAL_FRAMES_PROPERTY, DEFAULT_VALUES.isMaximizingInternalFrames());
    }

    public void setGlobalLoggingEnabled(boolean globalLoggingEnabled) {
        Boolean oldValue = this.isGlobalLoggingEnabled();
        PREFERENCES.putBoolean(GLOBAL_LOGGING_ENABLED_PROPERTY, globalLoggingEnabled);
        Boolean newValue = this.isGlobalLoggingEnabled();
        this.propertyChangeSupport.firePropertyChange(GLOBAL_LOGGING_ENABLED_PROPERTY, oldValue, newValue);
    }

    public boolean isGlobalLoggingEnabled() {
        return PREFERENCES.getBoolean(GLOBAL_LOGGING_ENABLED_PROPERTY, DEFAULT_VALUES.isGlobalLoggingEnabled());
    }

    public void setLoggingStatisticEnabled(boolean enabled) {
        Boolean oldValue = this.isLoggingStatisticEnabled();
        PREFERENCES.putBoolean(LOGGING_STATISTIC_ENABLED_PROPERTY, enabled);
        Boolean newValue = this.isLoggingStatisticEnabled();
        this.propertyChangeSupport.firePropertyChange(LOGGING_STATISTIC_ENABLED_PROPERTY, oldValue, newValue);
    }

    public boolean isLoggingStatisticEnabled() {
        return PREFERENCES.getBoolean(LOGGING_STATISTIC_ENABLED_PROPERTY, DEFAULT_VALUES.isLoggingStatisticEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConditions() {
        File appPath = this.getStartupApplicationPath();
        File conditionsFile = new File(appPath, CONDITIONS_XML_FILENAME);
        if (conditionsFile.isFile()) {
            long lastModified = conditionsFile.lastModified();
            if (this.conditions != null && this.lastConditionsModified >= lastModified) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Won't reload conditions.");
                }
                return;
            }
            XMLDecoder d = null;
            try {
                d = new XMLDecoder(new BufferedInputStream(new FileInputStream(conditionsFile)));
                this.conditions = ApplicationPreferences.transformToList(SavedCondition.class, d.readObject());
                this.lastConditionsModified = lastModified;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Loaded conditions {}.", this.conditions);
                }
            }
            catch (Throwable ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while loading conditions from file '" + conditionsFile.getAbsolutePath() + "'!", ex);
                }
                IOUtilities.interruptIfNecessary((Throwable)ex);
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        if (this.conditions == null) {
            this.conditions = new ArrayList<SavedCondition>();
        }
    }

    public SavedCondition resolveSavedCondition(Condition condition) {
        if (condition == null) {
            return null;
        }
        this.initConditions();
        for (SavedCondition current : this.conditions) {
            if (!condition.equals(current.getCondition())) continue;
            try {
                return current.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
        return null;
    }

    public SavedCondition resolveSavedCondition(String conditionName) {
        if (conditionName == null) {
            return null;
        }
        this.initConditions();
        for (SavedCondition current : this.conditions) {
            if (!conditionName.equals(current.getName())) continue;
            try {
                return current.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
        return null;
    }

    public List<SavedCondition> getConditions() {
        this.initConditions();
        ArrayList<SavedCondition> result = new ArrayList<SavedCondition>(this.conditions.size());
        for (SavedCondition current : this.conditions) {
            try {
                result.add(current.clone());
            }
            catch (CloneNotSupportedException e) {}
        }
        return result;
    }

    public List<String> getConditionNames() {
        this.initConditions();
        ArrayList<String> result = new ArrayList<String>(this.conditions.size());
        for (SavedCondition current : this.conditions) {
            result.add(current.getName());
        }
        return result;
    }

    public void setConditions(List<SavedCondition> conditions) {
        List<SavedCondition> oldValue = this.getConditions();
        this.writeConditions(conditions);
        List<SavedCondition> newValue = this.getConditions();
        this.propertyChangeSupport.firePropertyChange(CONDITIONS_PROPERTY, oldValue, newValue);
    }

    public void setAutoOpening(boolean autoOpening) {
        Boolean oldValue = this.isAutoOpening();
        PREFERENCES.putBoolean(AUTO_OPENING_PROPERTY, autoOpening);
        Boolean newValue = this.isAutoOpening();
        this.propertyChangeSupport.firePropertyChange(AUTO_OPENING_PROPERTY, oldValue, newValue);
    }

    public boolean isAutoOpening() {
        return PREFERENCES.getBoolean(AUTO_OPENING_PROPERTY, DEFAULT_VALUES.isAutoOpening());
    }

    public void setTrayActive(boolean trayActive) {
        Boolean oldValue = this.isTrayActive();
        PREFERENCES.putBoolean(TRAY_ACTIVE_PROPERTY, trayActive);
        Boolean newValue = this.isTrayActive();
        this.propertyChangeSupport.firePropertyChange(TRAY_ACTIVE_PROPERTY, oldValue, newValue);
    }

    public boolean isTrayActive() {
        return PREFERENCES.getBoolean(TRAY_ACTIVE_PROPERTY, DEFAULT_VALUES.isTrayActive());
    }

    public void setHidingOnClose(boolean trayActive) {
        Boolean oldValue = this.isHidingOnClose();
        PREFERENCES.putBoolean(HIDING_ON_CLOSE_PROPERTY, trayActive);
        Boolean newValue = this.isHidingOnClose();
        this.propertyChangeSupport.firePropertyChange(HIDING_ON_CLOSE_PROPERTY, oldValue, newValue);
    }

    public boolean isHidingOnClose() {
        return PREFERENCES.getBoolean(HIDING_ON_CLOSE_PROPERTY, DEFAULT_VALUES.isHidingOnClose());
    }

    public void setShowingToolbar(boolean showingToolbarName) {
        Boolean oldValue = this.isShowingToolbar();
        PREFERENCES.putBoolean(SHOWING_TOOLBAR_PROPERTY, showingToolbarName);
        Boolean newValue = this.isShowingToolbar();
        this.propertyChangeSupport.firePropertyChange(SHOWING_TOOLBAR_PROPERTY, oldValue, newValue);
    }

    public boolean isShowingToolbar() {
        return PREFERENCES.getBoolean(SHOWING_TOOLBAR_PROPERTY, DEFAULT_VALUES.isShowingToolbar());
    }

    public boolean isShowingStatusbar() {
        return PREFERENCES.getBoolean(SHOWING_STATUSBAR_PROPERTY, DEFAULT_VALUES.isShowingStatusbar());
    }

    public void setShowingStatusbar(boolean showingStatusbarName) {
        Boolean oldValue = this.isShowingStatusbar();
        PREFERENCES.putBoolean(SHOWING_STATUSBAR_PROPERTY, showingStatusbarName);
        Boolean newValue = this.isShowingStatusbar();
        this.propertyChangeSupport.firePropertyChange(SHOWING_STATUSBAR_PROPERTY, oldValue, newValue);
    }

    public void setShowingIdentifier(boolean showingIdentifierWithName) {
        Boolean oldValue = this.isShowingIdentifier();
        PREFERENCES.putBoolean(SHOWING_IDENTIFIER_PROPERTY, showingIdentifierWithName);
        Boolean newValue = this.isShowingIdentifier();
        this.propertyChangeSupport.firePropertyChange(SHOWING_IDENTIFIER_PROPERTY, oldValue, newValue);
    }

    public boolean isShowingIdentifier() {
        return PREFERENCES.getBoolean(SHOWING_IDENTIFIER_PROPERTY, DEFAULT_VALUES.isShowingIdentifier());
    }

    public void setSplashScreenDisabled(boolean splashScreenDisabled) {
        Boolean oldValue = this.isSplashScreenDisabled();
        PREFERENCES.putBoolean(SPLASH_SCREEN_DISABLED_PROPERTY, splashScreenDisabled);
        Boolean newValue = this.isSplashScreenDisabled();
        this.propertyChangeSupport.firePropertyChange(SPLASH_SCREEN_DISABLED_PROPERTY, oldValue, newValue);
    }

    public boolean isSplashScreenDisabled() {
        return PREFERENCES.getBoolean(SPLASH_SCREEN_DISABLED_PROPERTY, DEFAULT_VALUES.isSplashScreenDisabled());
    }

    public void setAskingBeforeQuit(boolean askingBeforeQuit) {
        Boolean oldValue = this.isAskingBeforeQuit();
        PREFERENCES.putBoolean(ASKING_BEFORE_QUIT_PROPERTY, askingBeforeQuit);
        Boolean newValue = this.isAskingBeforeQuit();
        this.propertyChangeSupport.firePropertyChange(ASKING_BEFORE_QUIT_PROPERTY, oldValue, newValue);
    }

    public boolean isAskingBeforeQuit() {
        return PREFERENCES.getBoolean(ASKING_BEFORE_QUIT_PROPERTY, DEFAULT_VALUES.isAskingBeforeQuit());
    }

    public void setShowingFullCallstack(boolean showingFullCallstack) {
        Boolean oldValue = this.isShowingFullCallstack();
        PREFERENCES.putBoolean(SHOWING_FULL_CALLSTACK_PROPERTY, showingFullCallstack);
        Boolean newValue = this.isShowingFullCallstack();
        this.propertyChangeSupport.firePropertyChange(SHOWING_FULL_CALLSTACK_PROPERTY, oldValue, newValue);
    }

    public boolean isShowingFullCallstack() {
        return PREFERENCES.getBoolean(SHOWING_FULL_CALLSTACK_PROPERTY, DEFAULT_VALUES.isShowingFullCallstack());
    }

    public void setUsingWrappedExceptionStyle(boolean showingFullCallstack) {
        Boolean oldValue = this.isUsingWrappedExceptionStyle();
        PREFERENCES.putBoolean(USING_WRAPPED_EXCEPTION_STYLE_PROPERTY, showingFullCallstack);
        Boolean newValue = this.isUsingWrappedExceptionStyle();
        this.propertyChangeSupport.firePropertyChange(USING_WRAPPED_EXCEPTION_STYLE_PROPERTY, oldValue, newValue);
    }

    public boolean isUsingWrappedExceptionStyle() {
        return PREFERENCES.getBoolean(USING_WRAPPED_EXCEPTION_STYLE_PROPERTY, DEFAULT_VALUES.isUsingWrappedExceptionStyle());
    }

    public void setShowingStackTrace(boolean showingStackTrace) {
        Boolean oldValue = this.isShowingStackTrace();
        PREFERENCES.putBoolean(SHOWING_STACKTRACE_PROPERTY, showingStackTrace);
        Boolean newValue = this.isShowingStackTrace();
        this.propertyChangeSupport.firePropertyChange(SHOWING_STACKTRACE_PROPERTY, oldValue, newValue);
    }

    public boolean isShowingStackTrace() {
        return PREFERENCES.getBoolean(SHOWING_STACKTRACE_PROPERTY, DEFAULT_VALUES.isShowingStackTrace());
    }

    public void setCleaningLogsOnExit(boolean cleaningLogsOnExit) {
        Boolean oldValue = this.isCleaningLogsOnExit();
        PREFERENCES.putBoolean(CLEANING_LOGS_ON_EXIT_PROPERTY, cleaningLogsOnExit);
        Boolean newValue = this.isCleaningLogsOnExit();
        this.propertyChangeSupport.firePropertyChange(CLEANING_LOGS_ON_EXIT_PROPERTY, oldValue, newValue);
    }

    public boolean isCleaningLogsOnExit() {
        return PREFERENCES.getBoolean(CLEANING_LOGS_ON_EXIT_PROPERTY, DEFAULT_VALUES.isCleaningLogsOnExit());
    }

    public void setColoringWholeRow(boolean coloringWholeRow) {
        Boolean oldValue = this.isColoringWholeRow();
        PREFERENCES.putBoolean(COLORING_WHOLE_ROW_PROPERTY, coloringWholeRow);
        Boolean newValue = this.isColoringWholeRow();
        this.propertyChangeSupport.firePropertyChange(COLORING_WHOLE_ROW_PROPERTY, oldValue, newValue);
    }

    public boolean isColoringWholeRow() {
        return PREFERENCES.getBoolean(COLORING_WHOLE_ROW_PROPERTY, DEFAULT_VALUES.isColoringWholeRow());
    }

    public void setCheckingForUpdate(boolean checkingForUpdate) {
        Boolean oldValue = this.isCheckingForUpdate();
        PREFERENCES.putBoolean(CHECKING_FOR_UPDATE_PROPERTY, checkingForUpdate);
        Boolean newValue = this.isCheckingForUpdate();
        this.propertyChangeSupport.firePropertyChange(CHECKING_FOR_UPDATE_PROPERTY, oldValue, newValue);
    }

    public boolean isCheckingForUpdate() {
        return PREFERENCES.getBoolean(CHECKING_FOR_UPDATE_PROPERTY, DEFAULT_VALUES.isCheckingForUpdate());
    }

    public void setCheckingForSnapshot(boolean checkingForSnapshot) {
        Boolean oldValue = this.isCheckingForSnapshot();
        PREFERENCES.putBoolean(CHECKING_FOR_SNAPSHOT_PROPERTY, checkingForSnapshot);
        Boolean newValue = this.isCheckingForSnapshot();
        this.propertyChangeSupport.firePropertyChange(CHECKING_FOR_SNAPSHOT_PROPERTY, oldValue, newValue);
    }

    public boolean isCheckingForSnapshot() {
        return PREFERENCES.getBoolean(CHECKING_FOR_SNAPSHOT_PROPERTY, DEFAULT_VALUES.isCheckingForSnapshot());
    }

    public void setAutoClosing(boolean autoClosing) {
        Boolean oldValue = this.isAutoClosing();
        PREFERENCES.putBoolean(AUTO_CLOSING_PROPERTY, autoClosing);
        Boolean newValue = this.isAutoClosing();
        this.propertyChangeSupport.firePropertyChange(AUTO_CLOSING_PROPERTY, oldValue, newValue);
    }

    public boolean isAutoClosing() {
        return PREFERENCES.getBoolean(AUTO_CLOSING_PROPERTY, DEFAULT_VALUES.isAutoClosing());
    }

    public File getImagePath() {
        String imagePath = PREFERENCES.get(IMAGE_PATH_PROPERTY, USER_HOME);
        File result = new File(imagePath);
        if (!result.isDirectory()) {
            result = new File(USER_HOME);
        }
        return result;
    }

    public void setImagePath(File imagePath) {
        if (!imagePath.isDirectory()) {
            throw new IllegalArgumentException("'" + imagePath.getAbsolutePath() + "' is not a directory!");
        }
        File oldValue = this.getImagePath();
        PREFERENCES.put(IMAGE_PATH_PROPERTY, imagePath.getAbsolutePath());
        File newValue = this.getImagePath();
        this.propertyChangeSupport.firePropertyChange(IMAGE_PATH_PROPERTY, oldValue, newValue);
    }

    public File getPreviousOpenPath() {
        String imagePath = PREFERENCES.get(PREVIOUS_OPEN_PATH_PROPERTY, USER_HOME);
        File result = new File(imagePath);
        if (!result.isDirectory()) {
            result = new File(USER_HOME);
        }
        return result;
    }

    public void setPreviousOpenPath(File openPath) {
        if (!openPath.isDirectory()) {
            throw new IllegalArgumentException("'" + openPath.getAbsolutePath() + "' is not a directory!");
        }
        File oldValue = this.getPreviousOpenPath();
        PREFERENCES.put(PREVIOUS_OPEN_PATH_PROPERTY, openPath.getAbsolutePath());
        File newValue = this.getPreviousOpenPath();
        this.propertyChangeSupport.firePropertyChange(PREVIOUS_OPEN_PATH_PROPERTY, oldValue, newValue);
    }

    public File getPreviousImportPath() {
        String path = PREFERENCES.get(PREVIOUS_IMPORT_PATH_PROPERTY, USER_HOME);
        File result = new File(path);
        if (!result.isDirectory()) {
            result = new File(USER_HOME);
        }
        return result;
    }

    public void setPreviousImportPath(File importPath) {
        if (!importPath.isDirectory()) {
            throw new IllegalArgumentException("'" + importPath.getAbsolutePath() + "' is not a directory!");
        }
        File oldValue = this.getPreviousImportPath();
        PREFERENCES.put(PREVIOUS_IMPORT_PATH_PROPERTY, importPath.getAbsolutePath());
        File newValue = this.getPreviousImportPath();
        this.propertyChangeSupport.firePropertyChange(PREVIOUS_IMPORT_PATH_PROPERTY, oldValue, newValue);
    }

    public File getPreviousExportPath() {
        String path = PREFERENCES.get(PREVIOUS_EXPORT_PATH_PROPERTY, USER_HOME);
        File result = new File(path);
        if (!result.isDirectory()) {
            result = new File(USER_HOME);
        }
        return result;
    }

    public void setPreviousExportPath(File exportPath) {
        if (!exportPath.isDirectory()) {
            throw new IllegalArgumentException("'" + exportPath.getAbsolutePath() + "' is not a directory!");
        }
        File oldValue = this.getPreviousImportPath();
        PREFERENCES.put(PREVIOUS_EXPORT_PATH_PROPERTY, exportPath.getAbsolutePath());
        File newValue = this.getPreviousExportPath();
        this.propertyChangeSupport.firePropertyChange(PREVIOUS_EXPORT_PATH_PROPERTY, oldValue, newValue);
    }

    public File getSoundPath() {
        String soundPath = PREFERENCES.get(SOUND_PATH_PROPERTY, USER_HOME);
        File result = new File(soundPath);
        if (!result.isDirectory()) {
            result = new File(USER_HOME);
        }
        return result;
    }

    public void setSoundPath(File soundPath) {
        if (!soundPath.isDirectory()) {
            throw new IllegalArgumentException("'" + soundPath.getAbsolutePath() + "' is not a directory!");
        }
        File oldValue = this.getSoundPath();
        PREFERENCES.put(SOUND_PATH_PROPERTY, soundPath.getAbsolutePath());
        File newValue = this.getSoundPath();
        this.propertyChangeSupport.firePropertyChange(SOUND_PATH_PROPERTY, oldValue, newValue);
    }

    public void setScaleFactor(double scale) {
        Double oldValue = this.getScaleFactor();
        PREFERENCES.putDouble(SCALE_FACTOR_PROPERTY, scale);
        Double newValue = this.getScaleFactor();
        this.propertyChangeSupport.firePropertyChange(SCALE_FACTOR_PROPERTY, oldValue, newValue);
    }

    public double getScaleFactor() {
        return PREFERENCES.getDouble(SCALE_FACTOR_PROPERTY, 1.0);
    }

    public void setMute(boolean mute) {
        Boolean oldValue = this.isMute();
        PREFERENCES.putBoolean(MUTE_PROPERTY, mute);
        Boolean newValue = this.isMute();
        this.propertyChangeSupport.firePropertyChange(MUTE_PROPERTY, oldValue, newValue);
    }

    public boolean isMute() {
        return PREFERENCES.getBoolean(MUTE_PROPERTY, DEFAULT_VALUES.isMute());
    }

    public void setLicensed(boolean licensed) {
        Boolean oldValue = this.isLicensed();
        if (licensed) {
            PREFERENCES.put(LICENSED_PREFERENCES_KEY, Lilith.APP_VERSION);
        } else {
            PREFERENCES.remove(LICENSED_PREFERENCES_KEY);
        }
        Boolean newValue = this.isLicensed();
        this.propertyChangeSupport.firePropertyChange(LICENSED_PREFERENCES_KEY, oldValue, newValue);
    }

    public boolean isLicensed() {
        return Lilith.APP_VERSION.equals(PREFERENCES.get(LICENSED_PREFERENCES_KEY, null));
    }

    public void setApplicationPath(File applicationPath) {
        if (applicationPath.mkdirs() && this.logger.isInfoEnabled()) {
            this.logger.info("Created directory {}.", (Object)applicationPath.getAbsolutePath());
        }
        if (!applicationPath.isDirectory()) {
            throw new IllegalArgumentException("'" + applicationPath.getAbsolutePath() + "' is not a directory!");
        }
        File oldValue = this.getStartupApplicationPath();
        PREFERENCES.put(APPLICATION_PATH_PROPERTY, applicationPath.getAbsolutePath());
        File newValue = this.getApplicationPath();
        this.propertyChangeSupport.firePropertyChange(APPLICATION_PATH_PROPERTY, oldValue, newValue);
    }

    public File getApplicationPath() {
        String appPath = PREFERENCES.get(APPLICATION_PATH_PROPERTY, DEFAULT_APPLICATION_PATH);
        File result = new File(appPath);
        if (result.mkdirs() && this.logger.isInfoEnabled()) {
            this.logger.info("Created directory {}.", (Object)result.getAbsolutePath());
        }
        return result;
    }

    public void setDefaultConditionName(String conditionName) {
        String oldValue = this.getDefaultConditionName();
        PREFERENCES.put(DEFAULT_CONDITION_NAME_PROPERTY, conditionName);
        String newValue = this.getDefaultConditionName();
        this.propertyChangeSupport.firePropertyChange(DEFAULT_CONDITION_NAME_PROPERTY, oldValue, newValue);
    }

    public String getDefaultConditionName() {
        return PREFERENCES.get(DEFAULT_CONDITION_NAME_PROPERTY, "event.contains");
    }

    public File getStartupApplicationPath() {
        return this.startupApplicationPath;
    }

    public void setUsingInternalFrames(boolean usingInternalFrames) {
        Boolean oldValue = this.isUsingInternalFrames();
        PREFERENCES.putBoolean(USING_INTERNAL_FRAMES_PROPERTY, usingInternalFrames);
        Boolean newValue = this.isUsingInternalFrames();
        this.propertyChangeSupport.firePropertyChange(USING_INTERNAL_FRAMES_PROPERTY, oldValue, newValue);
    }

    public boolean isUsingInternalFrames() {
        return PREFERENCES.getBoolean(USING_INTERNAL_FRAMES_PROPERTY, DEFAULT_VALUES.isUsingInternalFrames());
    }

    public void setAutoFocusingWindow(boolean autoFocusingWindow) {
        Boolean oldValue = this.isAutoFocusingWindow();
        PREFERENCES.putBoolean(AUTO_FOCUSING_WINDOW_PROPERTY, autoFocusingWindow);
        Boolean newValue = this.isAutoFocusingWindow();
        this.propertyChangeSupport.firePropertyChange(AUTO_FOCUSING_WINDOW_PROPERTY, oldValue, newValue);
    }

    public boolean isAutoFocusingWindow() {
        return PREFERENCES.getBoolean(AUTO_FOCUSING_WINDOW_PROPERTY, DEFAULT_VALUES.isAutoFocusingWindow());
    }

    public void setShowingFullRecentPath(boolean showingFullRecentPath) {
        Boolean oldValue = this.isShowingFullRecentPath();
        PREFERENCES.putBoolean(SHOWING_FULL_RECENT_PATH_PROPERTY, showingFullRecentPath);
        Boolean newValue = this.isShowingFullRecentPath();
        this.propertyChangeSupport.firePropertyChange(SHOWING_FULL_RECENT_PATH_PROPERTY, oldValue, newValue);
    }

    public boolean isShowingFullRecentPath() {
        return PREFERENCES.getBoolean(SHOWING_FULL_RECENT_PATH_PROPERTY, DEFAULT_VALUES.isShowingFullRecentPath());
    }

    public void setSourceNames(Map<String, String> sourceNames) {
        Map<String, String> oldValue = this.getSourceNames();
        this.writeSourceNames(sourceNames);
        Map<String, String> newValue = this.getSourceNames();
        this.propertyChangeSupport.firePropertyChange(SOURCE_NAMES_PROPERTY, oldValue, newValue);
    }

    public Map<String, String> getSourceNames() {
        File appPath = this.getStartupApplicationPath();
        File sourceNamesFile = new File(appPath, SOURCE_NAMES_XML_FILENAME);
        if (sourceNamesFile.isFile() && this.loadSourceNamesXml(sourceNamesFile)) {
            return new HashMap<String, String>(this.sourceNames);
        }
        sourceNamesFile = new File(appPath, SOURCE_NAMES_PROPERTIES_FILENAME);
        if (sourceNamesFile.isFile() && this.loadSourceNamesProperties(sourceNamesFile)) {
            return new HashMap<String, String>(this.sourceNames);
        }
        return new HashMap<String, String>(DEFAULT_SOURCE_NAMES);
    }

    public Map<String, String> getSoundLocations() {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, SOUND_LOCATIONS_XML_FILENAME);
        if (file.isFile() && this.loadSoundLocationsXml(file)) {
            return new HashMap<String, String>(this.soundLocations);
        }
        return new HashMap<String, String>(DEFAULT_SOUND_LOCATIONS);
    }

    public void setSoundLocations(Map<String, String> soundLocations) {
        Map<String, String> oldValue = this.getSoundLocations();
        this.writeSoundLocations(soundLocations);
        Map<String, String> newValue = this.getSoundLocations();
        this.propertyChangeSupport.firePropertyChange(SOUND_LOCATIONS_PROPERTY, oldValue, newValue);
    }

    public void resetSoundLocations() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initializing preferences with default sound locations.");
        }
        this.setSoundLocations(DEFAULT_SOUND_LOCATIONS);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void reset() {
        block2: {
            Logger logger = LoggerFactory.getLogger(ApplicationPreferences.class);
            boolean licensed = this.isLicensed();
            try {
                PREFERENCES.clear();
                this.resetSoundLocations();
                this.setLicensed(licensed);
                this.setApplicationPath(new File(DEFAULT_APPLICATION_PATH));
            }
            catch (BackingStoreException e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Exception while clearing preferences!");
            }
        }
    }

    public void setScrollingToBottom(boolean scrollingToBottom) {
        Boolean oldValue = this.isScrollingToBottom();
        PREFERENCES.putBoolean(SCROLLING_TO_BOTTOM_PROPERTY, scrollingToBottom);
        Boolean newValue = this.isScrollingToBottom();
        this.propertyChangeSupport.firePropertyChange(SCROLLING_TO_BOTTOM_PROPERTY, oldValue, newValue);
    }

    public boolean isScrollingToBottom() {
        return PREFERENCES.getBoolean(SCROLLING_TO_BOTTOM_PROPERTY, DEFAULT_VALUES.isScrollingToBottom());
    }

    private boolean loadSoundLocationsXml(File file) {
        long lastModified = file.lastModified();
        if (this.soundLocations != null && this.lastSoundLocationsModified >= lastModified) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Won't reload sound locations.");
            }
            return true;
        }
        Map<String, String> props = this.loadPropertiesXml(file);
        if (props != null) {
            this.lastSoundLocationsModified = lastModified;
            for (Map.Entry<String, String> current : DEFAULT_SOUND_LOCATIONS.entrySet()) {
                if (props.containsKey(current.getKey())) continue;
                props.put(current.getKey(), "");
            }
            this.soundLocations = props;
            return true;
        }
        return false;
    }

    private boolean writeSoundLocations(Map<String, String> sourceNames) {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, SOUND_LOCATIONS_XML_FILENAME);
        return this.writePropertiesXml(file, sourceNames, "Sound locations");
    }

    private boolean loadSourceNamesXml(File file) {
        long lastModified = file.lastModified();
        if (this.sourceNames != null && this.lastSourceNamesModified >= lastModified) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Won't reload source names.");
            }
            return true;
        }
        Map<String, String> props = this.loadPropertiesXml(file);
        if (props != null) {
            this.lastSourceNamesModified = lastModified;
            this.sourceNames = props;
            return true;
        }
        return false;
    }

    private boolean loadSourceNamesProperties(File sourceNamesFile) {
        long lastModified = sourceNamesFile.lastModified();
        if (this.sourceNames != null && this.lastSourceNamesModified >= lastModified) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Won't reload source names.");
            }
            return true;
        }
        Map<String, String> props = this.loadProperties(sourceNamesFile);
        if (props != null) {
            this.lastSourceNamesModified = lastModified;
            this.sourceNames = props;
            return true;
        }
        return false;
    }

    private boolean writeSourceNames(Map<String, String> sourceNames) {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, SOURCE_NAMES_XML_FILENAME);
        return this.writePropertiesXml(file, sourceNames, "Source names");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeSourceLists(Map<String, Set<String>> sourceLists) {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, SOURCE_LISTS_XML_FILENAME);
        XMLEncoder e = null;
        FileNotFoundException error = null;
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            e = new XMLEncoder(bos);
            e.writeObject(sourceLists);
        }
        catch (FileNotFoundException ex) {
            error = ex;
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
        if (error != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while writing source lists!", (Throwable)error);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeConditions(List<SavedCondition> conditions) {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, CONDITIONS_XML_FILENAME);
        XMLEncoder e = null;
        FileNotFoundException error = null;
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            e = new XMLEncoder(bos);
            e.writeObject(conditions);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Wrote conditions {}.", conditions);
            }
        }
        catch (FileNotFoundException ex) {
            error = ex;
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
        if (error != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while writing source lists!", (Throwable)error);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> loadPropertiesXml(File file) {
        HashMap<String, String> hashMap;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            Properties props = new Properties();
            props.loadFromXML(is);
            HashMap<String, String> result = new HashMap<String, String>();
            for (Object keyObj : props.keySet()) {
                String key = (String)keyObj;
                String value = (String)props.get(key);
                if (value == null) continue;
                result.put(key, value);
            }
            hashMap = result;
        }
        catch (IOException e) {
            block5: {
                try {
                    if (!this.logger.isWarnEnabled()) break block5;
                    this.logger.warn("Couldn't load properties from '" + file.getAbsolutePath() + "'!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtilities.closeQuietly((InputStream)is);
            return null;
        }
        IOUtilities.closeQuietly((InputStream)is);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean writePropertiesXml(File file, Map<String, String> stringStringMap, String comment) {
        IOException error;
        block10: {
            Properties output = new Properties();
            for (Map.Entry<String, String> entry : stringStringMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null) continue;
                output.put(key, value);
            }
            BufferedOutputStream os = null;
            error = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(file));
                output.storeToXML((OutputStream)os, comment, "UTF-8");
                IOUtilities.closeQuietly((OutputStream)os);
            }
            catch (FileNotFoundException e) {
                error = e;
            }
            catch (IOException e2) {
                error = e2;
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtilities.closeQuietly(os);
            }
        }
        if (error != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while writing source names!", (Throwable)error);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> loadProperties(File file) {
        HashMap<String, String> hashMap;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            Properties props = new Properties();
            props.load(is);
            HashMap<String, String> result = new HashMap<String, String>();
            for (Object keyObj : props.keySet()) {
                String key = (String)keyObj;
                String value = (String)props.get(key);
                if (value == null) continue;
                result.put(key, value);
            }
            hashMap = result;
        }
        catch (IOException e) {
            block5: {
                try {
                    if (!this.logger.isWarnEnabled()) break block5;
                    this.logger.warn("Couldn't load properties from '" + file.getAbsolutePath() + "'!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtilities.closeQuietly((InputStream)is);
            return null;
        }
        IOUtilities.closeQuietly((InputStream)is);
        return hashMap;
    }

    public void writeLoggingColumnLayout(boolean global, List<PersistentTableColumnModel.TableColumnLayoutInfo> layoutInfos) {
        File appPath = this.getStartupApplicationPath();
        File file = global ? new File(appPath, LOGGING_LAYOUT_GLOBAL_XML_FILENAME) : new File(appPath, LOGGING_LAYOUT_XML_FILENAME);
        this.writeColumnLayout(file, layoutInfos);
    }

    public void writeAccessColumnLayout(boolean global, List<PersistentTableColumnModel.TableColumnLayoutInfo> layoutInfos) {
        File appPath = this.getStartupApplicationPath();
        File file = global ? new File(appPath, ACCESS_LAYOUT_GLOBAL_XML_FILENAME) : new File(appPath, ACCESS_LAYOUT_XML_FILENAME);
        this.writeColumnLayout(file, layoutInfos);
    }

    public List<PersistentTableColumnModel.TableColumnLayoutInfo> readLoggingColumnLayout(boolean global) {
        File appPath = this.getStartupApplicationPath();
        File file = global ? new File(appPath, LOGGING_LAYOUT_GLOBAL_XML_FILENAME) : new File(appPath, LOGGING_LAYOUT_XML_FILENAME);
        return this.readColumnLayout(file);
    }

    public List<PersistentTableColumnModel.TableColumnLayoutInfo> readAccessColumnLayout(boolean global) {
        File appPath = this.getStartupApplicationPath();
        File file = global ? new File(appPath, ACCESS_LAYOUT_GLOBAL_XML_FILENAME) : new File(appPath, ACCESS_LAYOUT_XML_FILENAME);
        return this.readColumnLayout(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeColumnLayout(File file, List<PersistentTableColumnModel.TableColumnLayoutInfo> layoutInfos) {
        XMLEncoder e = null;
        FileNotFoundException error = null;
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            e = new XMLEncoder(bos);
            e.writeObject(layoutInfos);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Wrote layouts {} to file '{}'.", layoutInfos, (Object)file.getAbsolutePath());
            }
        }
        catch (FileNotFoundException ex) {
            error = ex;
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
        if (error != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while writing layouts to file '" + file.getAbsolutePath() + "'!", (Throwable)error);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PersistentTableColumnModel.TableColumnLayoutInfo> readColumnLayout(File file) {
        List<PersistentTableColumnModel.TableColumnLayoutInfo> result;
        XMLDecoder d = null;
        try {
            d = new XMLDecoder(new BufferedInputStream(new FileInputStream(file)));
            result = ApplicationPreferences.transformToList(PersistentTableColumnModel.TableColumnLayoutInfo.class, d.readObject());
        }
        catch (Throwable ex) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Exception while loading layouts from file '{}'':", (Object)file.getAbsolutePath(), (Object)ex.getMessage());
            }
            result = null;
            IOUtilities.interruptIfNecessary((Throwable)ex);
        }
        finally {
            if (d != null) {
                d.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getMD5(InputStream input) {
        if (input == null) {
            return null;
        }
        try {
            int read22;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            while ((read22 = input.read(buffer)) >= 0) {
                messageDigest.update(buffer, 0, read22);
            }
            byte[] read22 = messageDigest.digest();
            return read22;
        }
        catch (Throwable ex) {
            Logger logger = LoggerFactory.getLogger(ApplicationPreferences.class);
            if (logger.isWarnEnabled()) {
                logger.warn("Exception while calculating checksum!", ex);
            }
            IOUtilities.interruptIfNecessary((Throwable)ex);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {}
        }
        return null;
    }

    public void flush() {
        block2: {
            try {
                PREFERENCES.flush();
            }
            catch (BackingStoreException e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("Exception while flushing preferences!", (Throwable)e);
            }
        }
    }

    public boolean isReplacingOnApply(ActionEvent event) {
        boolean result = false;
        if (event == null || (1 & event.getModifiers()) == 0) {
            result = true;
        }
        return result;
    }

    static {
        DEFAULT_CONDITIONS = new String[]{"event.contains", "Level>=", "message.contains", "message.equals", "messagePattern.contains", "messagePattern.equals", "logger.startsWith", "logger.contains", "logger.equals", "CallLocation", SAVED_CONDITION};
        LEVEL_VALUES = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR"};
        DEFAULT_VALUES = new LilithPreferences();
        PREFERENCES.remove(OLD_LICENSED_PREFERENCES_KEY);
        USER_HOME = System.getProperty("user.home");
        File defaultAppPath = new File(USER_HOME, ".lilith");
        DEFAULT_APPLICATION_PATH = defaultAppPath.getAbsolutePath();
        HashMap<String, String> defaultSoundLocations = new HashMap<String, String>();
        defaultSoundLocations.put("sourceAdded", "/events/SourceAdded.mp3");
        defaultSoundLocations.put("sourceRemoved", "/events/SourceRemoved.mp3");
        defaultSoundLocations.put("errorEventAlarm", "/events/ErrorEventAlarm.mp3");
        defaultSoundLocations.put("warnEventAlarm", "/events/WarnEventAlarm.mp3");
        DEFAULT_SOUND_LOCATIONS = Collections.unmodifiableMap(defaultSoundLocations);
        HashMap<String, String> defaultSourceNames = new HashMap<String, String>();
        defaultSourceNames.put("127.0.0.1", "Localhost");
        DEFAULT_SOURCE_NAMES = Collections.unmodifiableMap(defaultSourceNames);
        HashMap<LoggingEvent.Level, ColorScheme> defaultLevelColors = new HashMap<LoggingEvent.Level, ColorScheme>();
        defaultLevelColors.put(LoggingEvent.Level.TRACE, new ColorScheme(new Color(31, 68, 88), new Color(128, 186, 217), new Color(128, 186, 217)));
        defaultLevelColors.put(LoggingEvent.Level.DEBUG, new ColorScheme(Color.BLACK, Color.GREEN, Color.GREEN));
        defaultLevelColors.put(LoggingEvent.Level.INFO, new ColorScheme(Color.BLACK, Color.WHITE, Color.WHITE));
        defaultLevelColors.put(LoggingEvent.Level.WARN, new ColorScheme(Color.BLACK, Color.YELLOW, Color.YELLOW));
        defaultLevelColors.put(LoggingEvent.Level.ERROR, new ColorScheme(Color.YELLOW, Color.RED, Color.ORANGE));
        DEFAULT_LEVEL_COLOR_SCHEMES = Collections.unmodifiableMap(defaultLevelColors);
        HashMap<HttpStatus.Type, ColorScheme> defaultStatusColors = new HashMap<HttpStatus.Type, ColorScheme>();
        defaultStatusColors.put(HttpStatus.Type.SUCCESSFUL, new ColorScheme(Color.BLACK, Color.GREEN, Color.GREEN));
        defaultStatusColors.put(HttpStatus.Type.INFORMATIONAL, new ColorScheme(Color.BLACK, Color.WHITE, Color.WHITE));
        defaultStatusColors.put(HttpStatus.Type.REDIRECTION, new ColorScheme(Color.BLACK, Color.YELLOW, Color.YELLOW));
        defaultStatusColors.put(HttpStatus.Type.CLIENT_ERROR, new ColorScheme(Color.GREEN, Color.RED, Color.ORANGE));
        defaultStatusColors.put(HttpStatus.Type.SERVER_ERROR, new ColorScheme(Color.YELLOW, Color.RED, Color.ORANGE));
        DEFAULT_STATUS_COLOR_SCHEMES = Collections.unmodifiableMap(defaultStatusColors);
        STARTUP_LOOK_AND_FEEL = UIManager.getLookAndFeel().getName();
    }

    static class EnumPersistenceDelegate
    extends PersistenceDelegate {
        EnumPersistenceDelegate() {
        }

        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance == newInstance;
        }

        protected Expression instantiate(Object oldInstance, Encoder out) {
            Enum e = (Enum)oldInstance;
            return new Expression(e, e.getClass(), "valueOf", new Object[]{e.name()});
        }
    }
}

