/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.services.sender;

import de.huxhorn.lilith.sender.ConnectionState;
import de.huxhorn.lilith.sender.DataOutputStreamFactory;
import de.huxhorn.lilith.sender.HeartbeatRunnable;
import de.huxhorn.lilith.sender.MessageWriteByteStrategy;
import de.huxhorn.lilith.sender.SendBytesService;
import de.huxhorn.lilith.sender.SimpleSendBytesService;
import de.huxhorn.lilith.sender.SocketDataOutputStreamFactory;
import de.huxhorn.lilith.sender.WriteByteStrategy;
import de.huxhorn.lilith.services.sender.EventSender;
import java.io.Serializable;
import javax.jmdns.JmDNS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventSender<T extends Serializable>
implements EventSender<T> {
    public static final String COMPRESSED_MDNS_PROPERTY_NAME = "compressed";
    private boolean compressing;
    private String serviceName;
    private String hostName;
    private int port;
    protected SimpleSendBytesService sendBytesService;
    private Thread heartbeatThread;
    private JmDNS jmDns;

    public AbstractEventSender(JmDNS jmDns, String serviceName, String hostName, int port, boolean compressing) {
        this.jmDns = jmDns;
        this.serviceName = serviceName;
        this.hostName = hostName;
        this.port = port;
        this.compressing = compressing;
        this.sendBytesService = new SimpleSendBytesService((DataOutputStreamFactory)new SocketDataOutputStreamFactory(hostName, port), (WriteByteStrategy)new MessageWriteByteStrategy());
        this.sendBytesService.startUp();
        this.heartbeatThread = new Thread((Runnable)new HeartbeatRunnable((SendBytesService)this.sendBytesService));
        this.heartbeatThread.setDaemon(true);
        this.heartbeatThread.start();
    }

    @Override
    public JmDNS getJmDNS() {
        return this.jmDns;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getHostAddress() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void discard() {
        this.heartbeatThread.interrupt();
        this.sendBytesService.shutDown();
    }

    @Override
    public boolean isInactive() {
        return this.sendBytesService.getConnectionState() != ConnectionState.Connected;
    }
}

