/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.services.clipboard;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.services.clipboard.ClipboardFormatter;
import java.io.Serializable;

public class LoggingNdcFormatter
implements ClipboardFormatter {
    private static final long serialVersionUID = 5898595765166630166L;

    public String getName() {
        return "Copy NDC";
    }

    public String getDescription() {
        return "Copies the Nested Diagnostic Context of the logging event to the clipboard.";
    }

    public String getAccelerator() {
        return null;
    }

    public boolean isCompatible(Object object) {
        Serializable eventObj;
        EventWrapper wrapper;
        if (object instanceof EventWrapper && (wrapper = (EventWrapper)object).getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent) {
            LoggingEvent loggingEvent = (LoggingEvent)eventObj;
            Message[] ndc = loggingEvent.getNdc();
            return ndc != null && ndc.length > 0;
        }
        return false;
    }

    public String toString(Object object) {
        LoggingEvent loggingEvent;
        Message[] ndc;
        Serializable eventObj;
        EventWrapper wrapper;
        if (object instanceof EventWrapper && (wrapper = (EventWrapper)object).getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent && (ndc = (loggingEvent = (LoggingEvent)eventObj).getNdc()) != null && ndc.length > 0) {
            StringBuilder text = new StringBuilder();
            for (Message current : ndc) {
                if (text.length() != 0) {
                    text.append("\n");
                }
                text.append(current.getMessage());
            }
            return text.toString();
        }
        return null;
    }
}

