/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.debug;

import de.huxhorn.lilith.debug.AbstractDebugRunnable;
import de.huxhorn.lilith.logback.classic.NDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogNdcRunnable
extends AbstractDebugRunnable {
    private final Logger logger = LoggerFactory.getLogger(LogNdcRunnable.class);

    public LogNdcRunnable(int delay) {
        super(delay);
    }

    public void runIt() throws InterruptedException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Message before pushing to NDC.");
        }
        this.sleep();
        NDC.push((String)"Message with parameters: {} {}", (Object[])new Object[]{"foo", "bar"});
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Message after pushing to NDC.");
        }
        this.sleep();
        NDC.push((String)"Another message with parameters: {} {}", (Object[])new Object[]{"foo", "bar"});
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Message after pushing to NDC again.");
        }
        this.sleep();
        NDC.push((String)"Simple message without parameters.", (Object[])new Object[0]);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Message after pushing to NDC a third time.");
        }
        this.sleep();
        NDC.pop();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Message after popping the NDC once.");
        }
        this.sleep();
        NDC.pop();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Message after popping the NDC twice.");
        }
        this.sleep();
        NDC.pop();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Message after popping the NDC thrice.");
        }
        this.sleep();
    }
}

