/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionBundle
implements Comparable<VersionBundle> {
    private String version;
    private long timestamp;

    public VersionBundle(String version) {
        this(version, -1L);
    }

    public VersionBundle(String version, long timestamp) {
        this.version = version;
        if (timestamp < 0L) {
            timestamp = -1L;
        }
        this.timestamp = timestamp;
    }

    public String getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static VersionBundle fromString(String input) {
        VersionBundle result;
        Logger logger = LoggerFactory.getLogger(VersionBundle.class);
        if (input == null) {
            return null;
        }
        int hashIndex = (input = input.trim()).indexOf(35);
        if (hashIndex < 0) {
            if (logger.isWarnEnabled()) {
                logger.warn("Retrieved version without timestamp! '{}'", (Object)input);
            }
            result = new VersionBundle(input);
        } else {
            String version = input.substring(0, hashIndex);
            String timestampStr = input.substring(hashIndex + 1);
            try {
                result = new VersionBundle(version, Long.parseLong(timestampStr));
            }
            catch (NumberFormatException ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Retrieved version with invalid timestamp! '{}'", (Object)input, (Object)ex);
                }
                result = new VersionBundle(input);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("VersionBundle: {}", (Object)result);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionBundle that = (VersionBundle)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        return this.version + '#' + this.timestamp;
    }

    @Override
    public int compareTo(VersionBundle o) {
        if (o == null) {
            return 1;
        }
        long dif = this.timestamp - o.timestamp;
        if (dif < 0L) {
            return -1;
        }
        if (dif > 0L) {
            return 1;
        }
        return 0;
    }
}

