/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.prefs.protobuf;

import de.huxhorn.lilith.prefs.LilithPreferences;
import de.huxhorn.lilith.prefs.protobuf.generated.PrefsProto;
import de.huxhorn.sulky.codec.streaming.StreamingDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LilithPreferencesStreamingDecoder
implements StreamingDecoder<LilithPreferences> {
    public LilithPreferences decode(InputStream from) throws IOException {
        PrefsProto.LilithPreferences prefs = PrefsProto.LilithPreferences.parseFrom(from);
        return LilithPreferencesStreamingDecoder.convert(prefs);
    }

    private static Map<String, byte[]> convert(PrefsProto.DirectoryContent dir) {
        if (dir == null) {
            return null;
        }
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        List<PrefsProto.ByteArrayMapEntry> entries = dir.getEntryList();
        for (PrefsProto.ByteArrayMapEntry current : entries) {
            result.put(current.getKey(), current.getValue().toByteArray());
        }
        return result;
    }

    private static LilithPreferences convert(PrefsProto.LilithPreferences p) {
        if (p == null) {
            return null;
        }
        LilithPreferences prefs = new LilithPreferences();
        if (p.hasGroovyConditions()) {
            prefs.setGroovyConditions(LilithPreferencesStreamingDecoder.convert(p.getGroovyConditions()));
        }
        if (p.hasGroovyClipboardFormatters()) {
            prefs.setGroovyClipboardFormatters(LilithPreferencesStreamingDecoder.convert(p.getGroovyClipboardFormatters()));
        }
        if (p.hasDetailsView()) {
            prefs.setDetailsView(LilithPreferencesStreamingDecoder.convert(p.getDetailsView()));
        }
        if (p.hasRootFiles()) {
            prefs.setRootFiles(LilithPreferencesStreamingDecoder.convert(p.getRootFiles()));
        }
        if (p.hasBlacklistName()) {
            prefs.setBlackListName(p.getBlacklistName());
        }
        if (p.hasWhitelistName()) {
            prefs.setWhiteListName(p.getWhitelistName());
        }
        if (p.hasLookAndFeel()) {
            prefs.setLookAndFeel(p.getLookAndFeel());
        }
        if (p.hasAskingBeforeQuit()) {
            prefs.setAskingBeforeQuit(p.getAskingBeforeQuit());
        }
        if (p.hasAutoClosing()) {
            prefs.setAutoClosing(p.getAutoClosing());
        }
        if (p.hasAutoFocusingWindow()) {
            prefs.setAutoFocusingWindow(p.getAutoFocusingWindow());
        }
        if (p.hasAutoOpening()) {
            prefs.setAutoOpening(p.getAutoOpening());
        }
        if (p.hasCheckingForUpdate()) {
            prefs.setCheckingForUpdate(p.getCheckingForUpdate());
        }
        if (p.hasCheckingForSnapshot()) {
            prefs.setCheckingForSnapshot(p.getCheckingForSnapshot());
        }
        if (p.hasCleaningLogsOnExit()) {
            prefs.setCleaningLogsOnExit(p.getCleaningLogsOnExit());
        }
        if (p.hasColoringWholeRow()) {
            prefs.setColoringWholeRow(p.getColoringWholeRow());
        }
        if (p.hasGlobalLoggingEnabled()) {
            prefs.setGlobalLoggingEnabled(p.getGlobalLoggingEnabled());
        }
        if (p.hasHidingOnClose()) {
            prefs.setHidingOnClose(p.getHidingOnClose());
        }
        if (p.hasLoggingStatisticEnabled()) {
            prefs.setLoggingStatisticEnabled(p.getLoggingStatisticEnabled());
        }
        if (p.hasMaximizingInternalFrames()) {
            prefs.setMaximizingInternalFrames(p.getMaximizingInternalFrames());
        }
        if (p.hasMute()) {
            prefs.setMute(p.getMute());
        }
        if (p.hasScrollingToBottom()) {
            prefs.setScrollingToBottom(p.getScrollingToBottom());
        }
        if (p.hasShowingFullCallstack()) {
            prefs.setShowingFullCallstack(p.getShowingFullCallstack());
        }
        if (p.hasShowingFullRecentPath()) {
            prefs.setShowingFullRecentPath(p.getShowingFullRecentPath());
        }
        if (p.hasShowingIdentifier()) {
            prefs.setShowingIdentifier(p.getShowingIdentifier());
        }
        if (p.hasShowingStatusbar()) {
            prefs.setShowingStatusbar(p.getShowingStatusbar());
        }
        if (p.hasShowingStacktrace()) {
            prefs.setShowingStackTrace(p.getShowingStacktrace());
        }
        if (p.hasUsingWrappedExceptionStyle()) {
            prefs.setUsingWrappedExceptionStyle(p.getUsingWrappedExceptionStyle());
        }
        if (p.hasShowingTipOfTheDay()) {
            prefs.setShowingTipOfTheDay(p.getShowingTipOfTheDay());
        }
        if (p.hasShowingToolbar()) {
            prefs.setShowingToolbar(p.getShowingToolbar());
        }
        if (p.hasSplashScreenDisabled()) {
            prefs.setSplashScreenDisabled(p.getSplashScreenDisabled());
        }
        if (p.hasTrayActive()) {
            prefs.setTrayActive(p.getTrayActive());
        }
        if (p.hasUsingInternalFrames()) {
            prefs.setUsingInternalFrames(p.getUsingInternalFrames());
        }
        if (p.hasSourceFiltering()) {
            PrefsProto.SourceFiltering sf = p.getSourceFiltering();
            switch (sf) {
                case BLACKLIST: {
                    prefs.setSourceFiltering(LilithPreferences.SourceFiltering.BLACKLIST);
                    break;
                }
                case WHITELIST: {
                    prefs.setSourceFiltering(LilithPreferences.SourceFiltering.WHITELIST);
                    break;
                }
                default: {
                    prefs.setSourceFiltering(LilithPreferences.SourceFiltering.NONE);
                    break;
                }
            }
        } else {
            prefs.setSourceFiltering(LilithPreferences.SourceFiltering.NONE);
        }
        if (p.hasDefaultConditionName()) {
            prefs.setDefaultConditionName(p.getDefaultConditionName());
        }
        return prefs;
    }
}

