/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine.json.eventproducer;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.json.LoggingJsonDecoder;
import de.huxhorn.lilith.engine.impl.eventproducer.AbstractEventProducer;
import de.huxhorn.lilith.engine.impl.eventproducer.LoggingEventSourceIdentifierUpdater;
import de.huxhorn.lilith.engine.impl.eventproducer.SourceIdentifierUpdater;
import de.huxhorn.sulky.buffers.AppendOperation;
import de.huxhorn.sulky.io.IOUtilities;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LilithJsonStreamLoggingEventProducer
extends AbstractEventProducer<LoggingEvent> {
    private final Logger logger = LoggerFactory.getLogger(LilithJsonStreamLoggingEventProducer.class);
    private LoggingJsonDecoder decoder = new LoggingJsonDecoder(false);
    private BufferedInputStream inputStream;

    public LilithJsonStreamLoggingEventProducer(SourceIdentifier sourceIdentifier, AppendOperation<EventWrapper<LoggingEvent>> eventQueue, InputStream inputStream) {
        super(sourceIdentifier, eventQueue, (SourceIdentifierUpdater)new LoggingEventSourceIdentifierUpdater());
        this.inputStream = new BufferedInputStream(inputStream);
    }

    public void start() {
        Thread t = new Thread((Runnable)new ReceiverRunnable(), "" + this.getSourceIdentifier() + "-Receiver");
        t.setDaemon(true);
        t.start();
    }

    public void close() {
        IOUtilities.closeQuietly((InputStream)this.inputStream);
    }

    private class ReceiverRunnable
    implements Runnable {
        private ReceiverRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                ArrayList<Byte> bytes = new ArrayList<Byte>();
                while (true) {
                    block11: {
                        block12: {
                            byte current;
                            block10: {
                                int readByte;
                                if ((readByte = LilithJsonStreamLoggingEventProducer.this.inputStream.read()) == -1) {
                                    if (!LilithJsonStreamLoggingEventProducer.this.logger.isDebugEnabled()) return;
                                    LilithJsonStreamLoggingEventProducer.this.logger.debug("Read -1, stopping...");
                                    return;
                                }
                                current = (byte)readByte;
                                if (current != 0) break block10;
                                if (bytes.size() <= 0) break block11;
                                break block12;
                            }
                            bytes.add(current);
                            continue;
                        }
                        byte[] ba = new byte[bytes.size()];
                        for (int i = 0; i < bytes.size(); ++i) {
                            ba[i] = (Byte)bytes.get(i);
                        }
                        bytes.clear();
                        LoggingEvent event = LilithJsonStreamLoggingEventProducer.this.decoder.decode(ba);
                        LilithJsonStreamLoggingEventProducer.this.addEvent((Serializable)event);
                        continue;
                    }
                    if (!LilithJsonStreamLoggingEventProducer.this.logger.isDebugEnabled()) continue;
                    LilithJsonStreamLoggingEventProducer.this.logger.debug("bytes.size()==0!!");
                    continue;
                    break;
                }
            }
            catch (Throwable e) {
                if (LilithJsonStreamLoggingEventProducer.this.logger.isInfoEnabled()) {
                    LilithJsonStreamLoggingEventProducer.this.logger.info("Exception ({}: '{}') while reading events. Adding eventWrapper with empty event and stopping...", (Object)e.getClass().getName(), (Object)e.getMessage());
                }
                LilithJsonStreamLoggingEventProducer.this.addEvent(null);
                IOUtilities.interruptIfNecessary((Throwable)e);
                return;
            }
            finally {
                LilithJsonStreamLoggingEventProducer.this.close();
            }
        }
    }
}

