/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.rt;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class IDLFilter
implements Filter {
    private ServletContext servletContext = null;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.inputFactory = XMLInputFactory.newInstance();
        this.outputFactory = XMLOutputFactory.newInstance();
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        RequestURIParts parts = this.parseParts(request);
        if (parts != null) {
            String realBaseAddress = parts.getBaseAddress();
            String idlPath = parts.getFilePath();
            InputStream idl = this.servletContext.getResourceAsStream(idlPath);
            if (idl != null) {
                servletResponse.setContentType("text/xml");
                String assumedBaseAddress = this.servletContext.getInitParameter("assumed-base-uri");
                try {
                    XMLEventReader eventReader = this.inputFactory.createXMLEventReader(idl);
                    XMLEventWriter eventWriter = this.outputFactory.createXMLEventWriter(servletResponse.getWriter());
                    while (eventReader.hasNext()) {
                        XMLEvent event = eventReader.nextEvent();
                        if (event.isProcessingInstruction()) {
                            String target = ((ProcessingInstruction)event).getTarget();
                            if (!"enunciate-assumed-base-uri".equals(target) || !(assumedBaseAddress = ((ProcessingInstruction)event).getData()).endsWith("/")) continue;
                            assumedBaseAddress = assumedBaseAddress.substring(0, assumedBaseAddress.length() - 1);
                            continue;
                        }
                        if (event.getEventType() == 12 || event.getEventType() == 4) {
                            String data = ((Characters)event).getData();
                            if (assumedBaseAddress != null && data.contains(assumedBaseAddress)) {
                                data = data.replace(assumedBaseAddress, realBaseAddress);
                                event = new DelegatingCharacters((Characters)event, data);
                            }
                        } else if (event.getEventType() == 1) {
                            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                            Iterator<Attribute> attributesIt = ((StartElement)event).getAttributes();
                            while (attributesIt.hasNext()) {
                                Attribute attribute = attributesIt.next();
                                String value = attribute.getValue();
                                if (assumedBaseAddress != null && value.contains(assumedBaseAddress)) {
                                    value = value.replace(assumedBaseAddress, realBaseAddress);
                                    attribute = new DelegatingAttribute(attribute, value);
                                    event = new DelegatingStartElement((StartElement)event, attributes);
                                }
                                attributes.add(attribute);
                            }
                        }
                        eventWriter.add(event);
                    }
                    eventReader.close();
                    eventWriter.flush();
                    eventWriter.close();
                    return;
                }
                catch (XMLStreamException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    protected RequestURIParts parseParts(HttpServletRequest request) {
        String baseAddress;
        String filePath;
        StringBuffer requestURI = request.getRequestURL();
        String contextPath = request.getContextPath();
        if ("".equals(contextPath)) {
            URI uri;
            try {
                uri = new URI(requestURI.toString());
            }
            catch (URISyntaxException e) {
                return null;
            }
            filePath = uri.getPath();
            baseAddress = requestURI.substring(0, requestURI.length() - filePath.length());
        } else {
            int splitIndex = requestURI.indexOf(contextPath) + contextPath.length();
            baseAddress = requestURI.substring(0, splitIndex);
            filePath = requestURI.substring(splitIndex);
        }
        return new RequestURIParts(baseAddress, filePath);
    }

    public void destroy() {
    }

    public static class DelegatingStartElement
    extends DelegatingXMLEvent
    implements StartElement {
        private final StartElement delegate;
        private final List<Attribute> attributes;

        public DelegatingStartElement(StartElement delegate, List<Attribute> attributes) {
            super(delegate);
            this.delegate = delegate;
            this.attributes = attributes;
        }

        @Override
        public QName getName() {
            return this.delegate.getName();
        }

        public Iterator getAttributes() {
            return this.attributes.iterator();
        }

        public Iterator getNamespaces() {
            return this.delegate.getNamespaces();
        }

        @Override
        public Attribute getAttributeByName(QName name) {
            for (Attribute attribute : this.attributes) {
                if (!attribute.getName().equals(name)) continue;
                return attribute;
            }
            return null;
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.delegate.getNamespaceURI(prefix);
        }

        @Override
        public boolean isStartElement() {
            return true;
        }

        @Override
        public StartElement asStartElement() {
            return this;
        }
    }

    public static class DelegatingAttribute
    extends DelegatingXMLEvent
    implements Attribute {
        private final Attribute delegate;
        private final String value;

        public DelegatingAttribute(Attribute delegate, String value) {
            super(delegate);
            this.delegate = delegate;
            this.value = value;
        }

        @Override
        public QName getName() {
            return this.delegate.getName();
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getDTDType() {
            return this.delegate.getDTDType();
        }

        @Override
        public boolean isSpecified() {
            return this.delegate.isSpecified();
        }

        @Override
        public boolean isAttribute() {
            return true;
        }
    }

    public static class DelegatingCharacters
    extends DelegatingXMLEvent
    implements Characters {
        private final Characters delegate;
        private final String data;

        public DelegatingCharacters(Characters delegate, String data) {
            super(delegate);
            this.delegate = delegate;
            this.data = data;
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public boolean isWhiteSpace() {
            return this.delegate.isWhiteSpace();
        }

        @Override
        public boolean isCData() {
            return this.delegate.isCData();
        }

        @Override
        public boolean isIgnorableWhiteSpace() {
            return this.delegate.isIgnorableWhiteSpace();
        }

        @Override
        public boolean isCharacters() {
            return true;
        }

        @Override
        public Characters asCharacters() {
            return this;
        }
    }

    public static class DelegatingXMLEvent
    implements XMLEvent {
        private final XMLEvent delegate;

        public DelegatingXMLEvent(XMLEvent delegate) {
            this.delegate = delegate;
        }

        @Override
        public int getEventType() {
            return this.delegate.getEventType();
        }

        @Override
        public Location getLocation() {
            return this.delegate.getLocation();
        }

        @Override
        public boolean isStartElement() {
            return this.delegate.isStartElement();
        }

        @Override
        public boolean isAttribute() {
            return this.delegate.isAttribute();
        }

        @Override
        public boolean isNamespace() {
            return this.delegate.isNamespace();
        }

        @Override
        public boolean isEndElement() {
            return this.delegate.isEndElement();
        }

        @Override
        public boolean isEntityReference() {
            return this.delegate.isEntityReference();
        }

        @Override
        public boolean isProcessingInstruction() {
            return this.delegate.isProcessingInstruction();
        }

        @Override
        public boolean isCharacters() {
            return this.delegate.isCharacters();
        }

        @Override
        public boolean isStartDocument() {
            return this.delegate.isStartDocument();
        }

        @Override
        public boolean isEndDocument() {
            return this.delegate.isEndDocument();
        }

        @Override
        public StartElement asStartElement() {
            return this.delegate.asStartElement();
        }

        @Override
        public EndElement asEndElement() {
            return this.delegate.asEndElement();
        }

        @Override
        public Characters asCharacters() {
            return this.delegate.asCharacters();
        }

        @Override
        public QName getSchemaType() {
            return this.delegate.getSchemaType();
        }

        @Override
        public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
            this.delegate.writeAsEncodedUnicode(writer);
        }
    }

    public static class RequestURIParts {
        private final String baseAddress;
        private final String idlPath;

        public RequestURIParts(String baseAddress, String idlPath) {
            this.baseAddress = baseAddress;
            this.idlPath = idlPath;
        }

        public String getBaseAddress() {
            return this.baseAddress;
        }

        public String getFilePath() {
            return this.idlPath;
        }
    }
}

