/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.util.UnsignedNumberUtil;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TPMSClockInfo {
    private final BigInteger clock;
    private final long resetCount;
    private final long restartCount;
    private final boolean safe;

    public TPMSClockInfo(@NotNull BigInteger clock, long resetCount, long restartCount, boolean safe) {
        this.clock = clock;
        this.resetCount = resetCount;
        this.restartCount = restartCount;
        this.safe = safe;
    }

    @NotNull
    public BigInteger getClock() {
        return this.clock;
    }

    public long getResetCount() {
        return this.resetCount;
    }

    public long getRestartCount() {
        return this.restartCount;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMSClockInfo that = (TPMSClockInfo)o;
        return this.resetCount == that.resetCount && this.restartCount == that.restartCount && this.safe == that.safe && Objects.equals(this.clock, that.clock);
    }

    public int hashCode() {
        return Objects.hash(this.clock, this.resetCount, this.restartCount, this.safe);
    }

    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(17);
        buffer.put(UnsignedNumberUtil.toBytes(this.getClock()));
        buffer.put(UnsignedNumberUtil.toBytes(this.getResetCount()));
        buffer.put(UnsignedNumberUtil.toBytes(this.getRestartCount()));
        buffer.put(this.isSafe() ? (byte)1 : 0);
        return buffer.array();
    }
}

