/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum COSEKeyOperation {
    SIGN(1),
    VERIFY(2),
    ENCRYPT(3),
    DECRYPT(4),
    WRAP_KEY(5),
    UNWRAP_KEY(6),
    DERIVE_KEY(7),
    DERIVE_BITS(8),
    MAC_CREATE(9),
    MAC_VERIFY(10);

    private final int value;

    private COSEKeyOperation(int value) {
        this.value = value;
    }

    public static @NonNull COSEKeyOperation create(int value) {
        switch (value) {
            case 1: {
                return SIGN;
            }
            case 2: {
                return VERIFY;
            }
            case 3: {
                return ENCRYPT;
            }
            case 4: {
                return DECRYPT;
            }
            case 5: {
                return WRAP_KEY;
            }
            case 6: {
                return UNWRAP_KEY;
            }
            case 7: {
                return DERIVE_KEY;
            }
            case 8: {
                return DERIVE_BITS;
            }
            case 9: {
                return MAC_CREATE;
            }
            case 10: {
                return MAC_VERIFY;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static @NonNull COSEKeyOperation deserialize(int value) throws InvalidFormatException {
        try {
            return COSEKeyOperation.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, COSEKeyOperation.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

