/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.messages;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.messages.MessageInputI18n;
import com.vaadin.flow.component.messages.MessageInputVariant;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.shared.Registration;
import java.util.Objects;
import tools.jackson.databind.node.BaseJsonNode;

@Tag(value="vaadin-message-input")
@JsModule(value="@vaadin/message-input/src/vaadin-message-input.js")
@NpmPackage(value="@vaadin/message-input", version="25.0.0")
public class MessageInput
extends Component
implements Focusable<MessageInput>,
HasSize,
HasStyle,
HasEnabled,
HasTooltip,
HasThemeVariant<MessageInputVariant> {
    private MessageInputI18n i18n;

    public MessageInput() {
    }

    public MessageInput(ComponentEventListener<SubmitEvent> listener) {
        this.addSubmitListener(listener);
    }

    public Registration addSubmitListener(ComponentEventListener<SubmitEvent> listener) {
        return this.addListener(SubmitEvent.class, listener);
    }

    public MessageInputI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(MessageInputI18n i18n) {
        Objects.requireNonNull(i18n, "The i18n object should not be null");
        this.i18n = i18n;
        this.getElement().setPropertyJson("i18n", (BaseJsonNode)JacksonUtils.beanToJson((Object)i18n));
    }

    @DomEvent(value="submit")
    public static class SubmitEvent
    extends ComponentEvent<MessageInput> {
        private final String value;

        public SubmitEvent(MessageInput source, boolean fromClient, @EventData(value="event.detail.value") String value) {
            super((Component)source, fromClient);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

