/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.hilla.signals.Signal;
import com.vaadin.hilla.signals.core.event.StateEvent;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class ValueSignal<T>
extends Signal<T> {
    private T value;

    public ValueSignal(T defaultValue, Class<T> valueType) {
        this(valueType);
        Objects.requireNonNull(defaultValue);
        this.value = defaultValue;
    }

    public ValueSignal(Class<T> valueType) {
        super(valueType);
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    @Override
    protected ObjectNode createSnapshotEvent() {
        ObjectNode snapshot = new StateEvent<T>(this.getId().toString(), StateEvent.EventType.SNAPSHOT, this.value).toJson();
        return StateEvent.setAccepted(snapshot, true);
    }

    @Override
    protected boolean processEvent(ObjectNode event) {
        try {
            StateEvent stateEvent = new StateEvent(event, this.getValueType());
            return switch (stateEvent.getEventType()) {
                case StateEvent.EventType.SET -> {
                    this.value = stateEvent.getValue();
                    yield true;
                }
                case StateEvent.EventType.REPLACE -> this.compareAndSet(stateEvent.getValue(), stateEvent.getExpected());
                default -> throw new UnsupportedOperationException("Unsupported event: " + stateEvent.getEventType());
            };
        }
        catch (StateEvent.InvalidEventTypeException e) {
            throw new UnsupportedOperationException("Unsupported JSON: " + event, e);
        }
    }

    protected boolean compareAndSet(T newValue, T expectedValue) {
        if (Objects.equals(this.value, expectedValue)) {
            this.value = newValue;
            return true;
        }
        return false;
    }
}

