/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.frontend.FrontendToolsLocator;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.NodeResolver;
import com.vaadin.flow.server.frontend.ProxyFactory;
import com.vaadin.flow.server.frontend.installer.Platform;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendTools {
    public static final String DEFAULT_NODE_VERSION = "v24.12.0";
    public static final String DEFAULT_NPM_VERSION = "11.6.2";
    public static final String DEFAULT_PNPM_VERSION = "10.26.0";
    private static final String MSG_PREFIX = "%n%n======================================================================================================";
    private static final String MSG_SUFFIX = "%n======================================================================================================%n";
    private static final String PNPM_NOT_FOUND = "%n%n======================================================================================================%nVaadin is configured to use a globally installed pnpm ('pnpm.global=true'), but pnpm was not found on your system.%nInstall pnpm by following the instruction at https://pnpm.io/installation %nor exclude 'pnpm.global' from the configuration or set it to false.%n======================================================================================================%n";
    private static final String BUN_NOT_FOUND = "%n%n======================================================================================================%nVaadin is configured to use a globally installed bun, but bun was not found on your system.%nInstall bun by following the instruction at https://bun.sh %n======================================================================================================%n";
    private static final String BAD_VERSION = "%n%n======================================================================================================%nYour installed '%s' version (%s) is known to have problems.%nPlease update it%s.%n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final List<@NonNull FrontendVersion> BAD_NPM_VERSIONS = Collections.singletonList(new FrontendVersion("9.2.0"));
    private static final int SUPPORTED_NODE_MAJOR_VERSION = 24;
    private static final int SUPPORTED_NODE_MINOR_VERSION = 0;
    public static final int MAX_SUPPORTED_NODE_MAJOR_VERSION = 24;
    private static final int SUPPORTED_NPM_MAJOR_VERSION = 11;
    private static final int SUPPORTED_NPM_MINOR_VERSION = 3;
    public static final FrontendVersion SUPPORTED_NODE_VERSION = new FrontendVersion(24, 0);
    public static final FrontendVersion MINIMUM_AUTO_INSTALLED_NODE = new FrontendVersion(24, 10, 0);
    private static final FrontendVersion SUPPORTED_NPM_VERSION = new FrontendVersion(11, 3);
    private static final int SUPPORTED_PNPM_MAJOR_VERSION = 7;
    private static final int SUPPORTED_PNPM_MINOR_VERSION = 0;
    private static final FrontendVersion SUPPORTED_PNPM_VERSION = new FrontendVersion(7, 0);
    private static final FrontendVersion SUPPORTED_BUN_VERSION = new FrontendVersion(1, 0, 6);
    private final String baseDir;
    private final Supplier<String> alternativeDirGetter;
    private final FrontendToolsLocator frontendToolsLocator = new FrontendToolsLocator();
    private static volatile NodeResolver.ActiveNodeInstallation activeNodeInstallation;
    private static final Object RESOLUTION_LOCK;
    private final String nodeVersion;
    private final URI nodeDownloadRoot;
    private final boolean ignoreVersionChecks;
    private final boolean forceAlternativeNode;
    private final boolean useGlobalPnpm;

    public FrontendTools(FrontendToolsSettings settings) {
        this.baseDir = Objects.requireNonNull(settings.getBaseDir());
        this.alternativeDirGetter = settings.getAlternativeDirGetter();
        this.nodeVersion = Objects.requireNonNull(settings.getNodeVersion());
        this.nodeDownloadRoot = Objects.requireNonNull(settings.getNodeDownloadRoot());
        this.ignoreVersionChecks = settings.isIgnoreVersionChecks();
        this.forceAlternativeNode = settings.isForceAlternativeNode();
        this.useGlobalPnpm = settings.isUseGlobalPnpm();
    }

    public FrontendTools(ApplicationConfiguration applicationConfiguration, File projectRoot) {
        this(FrontendTools.createSettings(applicationConfiguration, projectRoot));
    }

    @Deprecated
    public FrontendTools(String baseDir, Supplier<String> alternativeDirGetter, String nodeVersion, URI nodeDownloadRoot, boolean forceAlternativeNode, boolean useGlobalPnpm) {
        this(baseDir, alternativeDirGetter, nodeVersion, nodeDownloadRoot, "true".equalsIgnoreCase(System.getProperty("vaadin.ignoreVersionChecks")), forceAlternativeNode, useGlobalPnpm);
    }

    FrontendTools(String baseDir, Supplier<String> alternativeDirGetter, String nodeVersion, URI nodeDownloadRoot, boolean ignoreVersionChecks, boolean forceAlternativeNode, boolean useGlobalPnpm) {
        this.baseDir = Objects.requireNonNull(baseDir);
        this.alternativeDirGetter = alternativeDirGetter;
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
        this.nodeDownloadRoot = Objects.requireNonNull(nodeDownloadRoot);
        this.ignoreVersionChecks = ignoreVersionChecks;
        this.forceAlternativeNode = forceAlternativeNode;
        this.useGlobalPnpm = useGlobalPnpm;
    }

    private static FrontendToolsSettings createSettings(ApplicationConfiguration applicationConfiguration, File projectRoot) {
        boolean useHomeNodeExec = applicationConfiguration.getBooleanProperty("require.home.node", false);
        boolean useGlobalPnpm = applicationConfiguration.getBooleanProperty("pnpm.global", false);
        String nodeVersion = applicationConfiguration.getStringProperty("node.version", DEFAULT_NODE_VERSION);
        String nodeDownloadRoot = applicationConfiguration.getStringProperty("node.download.root", Platform.guess().getNodeDownloadRoot());
        FrontendToolsSettings settings = new FrontendToolsSettings(projectRoot.getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setForceAlternativeNode(useHomeNodeExec);
        settings.setUseGlobalPnpm(useGlobalPnpm);
        settings.setNodeVersion(nodeVersion);
        settings.setNodeDownloadRoot(URI.create(nodeDownloadRoot));
        settings.setIgnoreVersionChecks(false);
        return settings;
    }

    public String getNodeExecutable() {
        return this.ensureNodeResolved().nodeExecutable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeResolver.ActiveNodeInstallation ensureNodeResolved() {
        NodeResolver.ActiveNodeInstallation active = activeNodeInstallation;
        if (active != null) {
            return active;
        }
        Object object = RESOLUTION_LOCK;
        synchronized (object) {
            active = activeNodeInstallation;
            if (active != null) {
                return active;
            }
            if (this.alternativeDirGetter == null) {
                throw new IllegalStateException("Node not found and no alternative directory configured for installation");
            }
            NodeResolver resolver = new NodeResolver(this.getAlternativeDir(), this.nodeVersion, this.nodeDownloadRoot, this.forceAlternativeNode, this.getProxies());
            activeNodeInstallation = resolver.resolve();
            return activeNodeInstallation;
        }
    }

    public List<String> getNpmExecutable() {
        return this.getNpmExecutable(true);
    }

    public List<String> getPnpmExecutable() {
        List<String> pnpmCommand = this.getSuitablePnpm();
        assert (!pnpmCommand.isEmpty());
        pnpmCommand = new ArrayList<String>(pnpmCommand);
        pnpmCommand.add("--shamefully-hoist=true");
        return pnpmCommand;
    }

    public List<String> getBunExecutable() {
        List<String> bunCommand = this.getSuitableBun();
        assert (!bunCommand.isEmpty());
        bunCommand = new ArrayList<String>(bunCommand);
        return bunCommand;
    }

    public void validateNodeAndNpmVersion() {
        if (this.ignoreVersionChecks) {
            return;
        }
        try {
            Pair<FrontendVersion, String> foundNodeVersionAndExe = this.getNodeVersionAndExecutable();
            this.getLogger().debug("Using node {} located at {}", (Object)foundNodeVersionAndExe.getFirst().getFullVersion(), (Object)foundNodeVersionAndExe.getSecond());
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().warn("Error checking node version", (Throwable)e);
        }
        try {
            FrontendVersion foundNpmVersion = this.getNpmVersion();
            this.getLogger().debug("Using npm {} located at {}", (Object)foundNpmVersion.getFullVersion(), (Object)this.getNpmExecutable(false).get(0));
            if (foundNpmVersion.isOlderThan(SUPPORTED_NPM_VERSION)) {
                throw new IllegalStateException(String.format("Internal error: npm version %s is older than required %s. This should not happen as Node %s should bundle a compatible npm version. Please report this issue.", foundNpmVersion.getFullVersion(), SUPPORTED_NPM_VERSION.getFullVersion(), DEFAULT_NODE_VERSION));
            }
            this.checkForFaultyNpmVersion(foundNpmVersion);
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().warn("Error checking npm version", (Throwable)e);
        }
    }

    public FrontendVersion getNodeVersion() throws FrontendUtils.UnknownVersionException {
        return this.getNodeVersionAndExecutable().getFirst();
    }

    private Pair<FrontendVersion, String> getNodeVersionAndExecutable() throws FrontendUtils.UnknownVersionException {
        String executable = this.getNodeBinary();
        ArrayList<String> nodeVersionCommand = new ArrayList<String>();
        nodeVersionCommand.add(executable);
        nodeVersionCommand.add("--version");
        return new Pair<FrontendVersion, String>(FrontendUtils.getVersion("node", nodeVersionCommand), executable);
    }

    protected List<ProxyConfig.Proxy> getProxies() {
        return ProxyFactory.getProxies(new File(this.baseDir));
    }

    void checkForFaultyNpmVersion(FrontendVersion npmVersion) {
        if (BAD_NPM_VERSIONS.contains(npmVersion)) {
            String badNpmVersion = this.buildBadVersionString("npm", npmVersion.getFullVersion(), "by updating your global npm installation with `npm install -g npm@latest`");
            throw new IllegalStateException(badNpmVersion);
        }
    }

    File getNpmCacheDir() throws FrontendUtils.CommandExecutionException, IllegalStateException {
        ArrayList<String> npmCacheCommand = new ArrayList<String>(this.getNpmExecutable(false));
        npmCacheCommand.add("config");
        npmCacheCommand.add("get");
        npmCacheCommand.add("cache");
        npmCacheCommand.add("--global");
        String output = FrontendUtils.executeCommand(npmCacheCommand);
        output = this.removeLineBreaks(output);
        if (output.isEmpty()) {
            throw new IllegalStateException(String.format("Command '%s' returned an empty path", String.join((CharSequence)" ", npmCacheCommand)));
        }
        return new File(output);
    }

    public FrontendVersion getNpmVersion() throws FrontendUtils.UnknownVersionException {
        ArrayList<String> npmVersionCommand = new ArrayList<String>(this.getNpmExecutable(false));
        npmVersionCommand.add("--version");
        return FrontendUtils.getVersion("npm", npmVersionCommand);
    }

    public Path getNpmPackageExecutable(String packageName, String binName, File cwd) throws FrontendUtils.CommandExecutionException {
        String script = "var jsonPath = require.resolve('%s/package.json');\nvar json = require(jsonPath);\nconsole.log(path.resolve(path.dirname(jsonPath), json.bin['%s']));\n".formatted(packageName, binName);
        return Paths.get(FrontendUtils.executeCommand(List.of(this.getNodeExecutable(), "--eval", script), builder -> builder.directory(cwd)).trim(), new String[0]);
    }

    @Deprecated(forRemoval=true, since="24.8")
    public Map<String, String> getWebpackNodeEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(this.getNodeExecutable(), "-p", "crypto.createHash('md4')");
        try {
            Process process = processBuilder.start();
            int errorLevel = process.waitFor();
            if (errorLevel != 0) {
                environment.put("NODE_OPTIONS", "--openssl-legacy-provider");
            }
        }
        catch (IOException e) {
            this.getLogger().error("IO error while determining --openssl-legacy-provider parameter requirement", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.getLogger().error("Interrupted while determining --openssl-legacy-provider parameter requirement", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return environment;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(FrontendTools.class);
    }

    private List<String> getNpmExecutable(boolean removePnpmLock) {
        ArrayList<String> returnCommand = new ArrayList<String>(this.getNpmCliToolExecutable(BuildTool.NPM, new String[0]));
        returnCommand.add("--no-update-notifier");
        returnCommand.add("--no-audit");
        returnCommand.add("--scripts-prepend-node-path=true");
        if (removePnpmLock && new File(this.baseDir, "pnpm-lock.yaml").delete()) {
            this.getLogger().debug("pnpm-lock.yaml file is removed from " + this.baseDir);
        }
        return returnCommand;
    }

    private List<String> getNpmCliToolExecutable(BuildTool cliTool, String ... flags) {
        ArrayList<String> returnCommand = new ArrayList<String>();
        if (cliTool.equals((Object)BuildTool.NPM) || cliTool.equals((Object)BuildTool.NPX)) {
            NodeResolver.ActiveNodeInstallation active = this.ensureNodeResolved();
            returnCommand.add(active.nodeExecutable());
            if (cliTool.equals((Object)BuildTool.NPM)) {
                returnCommand.add(active.npmCliScript());
            } else {
                File npmCliFile = new File(active.npmCliScript());
                File npxCliFile = new File(npmCliFile.getParentFile(), "npx-cli.js");
                if (!npxCliFile.exists()) {
                    throw new IllegalStateException("npx-cli.js not found at expected location: " + npxCliFile.getAbsolutePath());
                }
                returnCommand.add(npxCliFile.getAbsolutePath());
            }
        }
        if (flags.length > 0) {
            Collections.addAll(returnCommand, flags);
        }
        return returnCommand;
    }

    List<String> getSuitablePnpm() {
        List pnpmCommand;
        if (this.useGlobalPnpm) {
            pnpmCommand = this.frontendToolsLocator.tryLocateTool(BuildTool.PNPM.getCommand()).map(File::getAbsolutePath).map(Collections::singletonList).orElseThrow(() -> new IllegalStateException(String.format(PNPM_NOT_FOUND, new Object[0])));
            pnpmCommand = Stream.of(pnpmCommand).filter(this::validatePnpmVersion).findFirst().orElseThrow(() -> new IllegalStateException("Found too old globally installed 'pnpm'. Please upgrade 'pnpm' to at least " + SUPPORTED_PNPM_VERSION.getFullVersion()));
        } else {
            pnpmCommand = this.getNpmCliToolExecutable(BuildTool.NPX, "--yes", "--quiet", "pnpm");
            if (!this.validatePnpmVersion(pnpmCommand)) {
                throw new IllegalStateException("Found too old globally installed 'pnpm'. Please upgrade 'pnpm' to at least " + SUPPORTED_PNPM_VERSION.getFullVersion());
            }
        }
        return pnpmCommand;
    }

    List<String> getSuitableBun() {
        List bunCommand = this.frontendToolsLocator.tryLocateTool(BuildTool.BUN.getCommand()).map(File::getAbsolutePath).map(Collections::singletonList).orElseThrow(() -> new IllegalStateException(String.format(BUN_NOT_FOUND, new Object[0])));
        bunCommand = Stream.of(bunCommand).filter(this::validateBunVersion).findFirst().orElseThrow(() -> new IllegalStateException("Found too old globally installed 'bun'. Please upgrade 'bun' to at least " + SUPPORTED_BUN_VERSION.getFullVersion()));
        return bunCommand;
    }

    private boolean validatePnpmVersion(List<String> pnpmCommand) {
        String commandLine = String.join((CharSequence)" ", pnpmCommand);
        try {
            boolean versionAccepted;
            ArrayList<String> versionCmd = new ArrayList<String>(pnpmCommand);
            versionCmd.add("--version");
            FrontendVersion pnpmVersion = FrontendUtils.getVersion("pnpm", versionCmd);
            boolean versionNewEnough = pnpmVersion.isEqualOrNewer(SUPPORTED_PNPM_VERSION);
            boolean bl = versionAccepted = this.ignoreVersionChecks || versionNewEnough;
            if (!versionAccepted) {
                this.getLogger().warn("pnpm '{}' is version {} which is not supported (expected >={})", new Object[]{commandLine, pnpmVersion.getFullVersion(), SUPPORTED_PNPM_VERSION.getFullVersion()});
            }
            return versionAccepted;
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().warn("version check '{}' failed", (Object)commandLine, (Object)e);
            return false;
        }
    }

    private boolean validateBunVersion(List<String> bunCommand) {
        String commandLine = String.join((CharSequence)" ", bunCommand);
        try {
            boolean versionAccepted;
            ArrayList<String> versionCmd = new ArrayList<String>(bunCommand);
            versionCmd.add("--version");
            FrontendVersion bunVersion = FrontendUtils.getVersion("bun", versionCmd);
            boolean versionNewEnough = bunVersion.isEqualOrNewer(SUPPORTED_BUN_VERSION);
            boolean bl = versionAccepted = this.ignoreVersionChecks || versionNewEnough;
            if (!versionAccepted) {
                this.getLogger().warn("bun '{}' is version {} which is not supported (expected >={})", new Object[]{commandLine, bunVersion.getFullVersion(), SUPPORTED_BUN_VERSION.getFullVersion()});
            }
            return versionAccepted;
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().warn("version check '{}' failed", (Object)commandLine, (Object)e);
            return false;
        }
    }

    private String buildBadVersionString(String tool, String version, String ... extraUpdateInstructions) {
        StringBuilder extraInstructions = new StringBuilder();
        for (String instruction : extraUpdateInstructions) {
            extraInstructions.append(System.lineSeparator()).append("  - or ").append(instruction);
        }
        return String.format(BAD_VERSION, tool, version, extraInstructions.toString(), "vaadin.ignoreVersionChecks");
    }

    private String getAlternativeDir() {
        return this.alternativeDirGetter.get();
    }

    public String getNodeBinary() {
        return this.getNodeExecutable();
    }

    private String removeLineBreaks(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return String.join((CharSequence)"", str.split(System.lineSeparator()));
    }

    static {
        RESOLUTION_LOCK = new Object();
    }

    private static enum BuildTool {
        NPM("npm", "npm-cli.js"),
        NPX("npx", "npx-cli.js"),
        PNPM("pnpm", null),
        BUN("bun", null);

        private final String name;
        private final String script;

        private BuildTool(String tool, String script) {
            this.name = tool;
            this.script = script;
        }

        String getCommand() {
            if (this.name.equals("bun")) {
                return this.name;
            }
            return FrontendUtils.isWindows() ? this.name + ".cmd" : this.name;
        }

        String getScript() {
            if (this.script == null) {
                throw new RuntimeException(String.format("'%s' build tool doesn't have a CLI script", this.name));
            }
            return this.script;
        }
    }
}

