/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.graphson;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.MappingJsonFactory;

public class GraphSONWriter {
    private static final JsonFactory jsonFactory = new MappingJsonFactory();
    private final Graph graph;

    public GraphSONWriter(Graph graph) {
        this.graph = graph;
    }

    public void outputGraph(OutputStream jsonOutputStream, Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, GraphSONMode mode) throws IOException {
        JsonGenerator jg = jsonFactory.createJsonGenerator(jsonOutputStream);
        GraphSONUtility graphson = new GraphSONUtility(mode, null, vertexPropertyKeys, edgePropertyKeys);
        jg.writeStartObject();
        jg.writeStringField("mode", mode.toString());
        jg.writeArrayFieldStart("vertices");
        for (Vertex v : this.graph.getVertices()) {
            jg.writeTree((JsonNode)graphson.objectNodeFromElement(v));
        }
        jg.writeEndArray();
        jg.writeArrayFieldStart("edges");
        for (Edge e : this.graph.getEdges()) {
            jg.writeTree((JsonNode)graphson.objectNodeFromElement(e));
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.flush();
        jg.close();
    }

    public static void outputGraph(Graph graph, OutputStream jsonOutputStream) throws IOException {
        GraphSONWriter writer = new GraphSONWriter(graph);
        writer.outputGraph(jsonOutputStream, null, null, GraphSONMode.NORMAL);
    }

    public static void outputGraph(Graph graph, OutputStream jsonOutputStream, GraphSONMode mode) throws IOException {
        GraphSONWriter writer = new GraphSONWriter(graph);
        writer.outputGraph(jsonOutputStream, null, null, mode);
    }

    public static void outputGraph(Graph graph, OutputStream jsonOutputStream, Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, GraphSONMode mode) throws IOException {
        GraphSONWriter writer = new GraphSONWriter(graph);
        writer.outputGraph(jsonOutputStream, vertexPropertyKeys, edgePropertyKeys, mode);
    }
}

