/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.tg;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.tg.TinkerElement;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.blueprints.util.DefaultQuery;
import com.tinkerpop.blueprints.util.MultiIterable;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.VerticesFromEdgesIterable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class TinkerVertex
extends TinkerElement
implements Vertex,
Serializable {
    protected Map<String, Set<Edge>> outEdges = new HashMap<String, Set<Edge>>();
    protected Map<String, Set<Edge>> inEdges = new HashMap<String, Set<Edge>>();

    protected TinkerVertex(String id, TinkerGraph graph) {
        super(id, graph);
    }

    @Override
    public Iterable<Edge> getEdges(Direction direction, String ... labels) {
        if (direction.equals((Object)Direction.OUT)) {
            return this.getOutEdges(labels);
        }
        if (direction.equals((Object)Direction.IN)) {
            return this.getInEdges(labels);
        }
        return new MultiIterable<Edge>(Arrays.asList(this.getInEdges(labels), this.getOutEdges(labels)));
    }

    @Override
    public Iterable<Vertex> getVertices(Direction direction, String ... labels) {
        return new VerticesFromEdgesIterable(this, direction, labels);
    }

    private Iterable<Edge> getInEdges(String ... labels) {
        if (labels.length == 0) {
            ArrayList<Edge> totalEdges = new ArrayList<Edge>();
            for (Set<Edge> edges : this.inEdges.values()) {
                totalEdges.addAll(edges);
            }
            return totalEdges;
        }
        if (labels.length == 1) {
            Set<Edge> edges = this.inEdges.get(labels[0]);
            if (null == edges) {
                return Collections.emptyList();
            }
            return new ArrayList<Edge>(edges);
        }
        ArrayList<Edge> totalEdges = new ArrayList<Edge>();
        for (String label : labels) {
            Set<Edge> edges = this.inEdges.get(label);
            if (null == edges) continue;
            totalEdges.addAll(edges);
        }
        return totalEdges;
    }

    private Iterable<Edge> getOutEdges(String ... labels) {
        if (labels.length == 0) {
            ArrayList<Edge> totalEdges = new ArrayList<Edge>();
            for (Set<Edge> edges : this.outEdges.values()) {
                totalEdges.addAll(edges);
            }
            return totalEdges;
        }
        if (labels.length == 1) {
            Set<Edge> edges = this.outEdges.get(labels[0]);
            if (null == edges) {
                return Collections.emptyList();
            }
            return new ArrayList<Edge>(edges);
        }
        ArrayList<Edge> totalEdges = new ArrayList<Edge>();
        for (String label : labels) {
            Set<Edge> edges = this.outEdges.get(label);
            if (null == edges) continue;
            totalEdges.addAll(edges);
        }
        return totalEdges;
    }

    @Override
    public Query query() {
        return new DefaultQuery(this);
    }

    public String toString() {
        return StringFactory.vertexString(this);
    }

    protected void addOutEdge(String label, Edge edge) {
        Set<Edge> edges = this.outEdges.get(label);
        if (null == edges) {
            edges = new HashSet<Edge>();
            this.outEdges.put(label, edges);
        }
        edges.add(edge);
    }

    protected void addInEdge(String label, Edge edge) {
        Set<Edge> edges = this.inEdges.get(label);
        if (null == edges) {
            edges = new HashSet<Edge>();
            this.inEdges.put(label, edges);
        }
        edges.add(edge);
    }
}

