/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.tg;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.impls.tg.TinkerEdge;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.blueprints.impls.tg.TinkerVertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

abstract class TinkerElement
implements Element,
Serializable {
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected final String id;
    protected final TinkerGraph graph;

    protected TinkerElement(String id, TinkerGraph graph) {
        this.graph = graph;
        this.id = id;
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.properties.keySet();
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        if (key.equals("id")) {
            throw ExceptionFactory.propertyKeyIdIsReserved();
        }
        if (key.equals("label") && this instanceof Edge) {
            throw ExceptionFactory.propertyKeyLabelIsReservedForEdges();
        }
        if (key.equals("")) {
            throw ExceptionFactory.elementKeyCanNotBeEmpty();
        }
        Object oldValue = this.properties.put(key, value);
        if (this instanceof TinkerVertex) {
            this.graph.vertexKeyIndex.autoUpdate(key, value, oldValue, (TinkerVertex)this);
        } else {
            this.graph.edgeKeyIndex.autoUpdate(key, value, oldValue, (TinkerEdge)this);
        }
    }

    @Override
    public Object removeProperty(String key) {
        Object oldValue = this.properties.remove(key);
        if (this instanceof TinkerVertex) {
            this.graph.vertexKeyIndex.autoRemove(key, oldValue, (TinkerVertex)this);
        } else {
            this.graph.edgeKeyIndex.autoRemove(key, oldValue, (TinkerEdge)this);
        }
        return oldValue;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual(this, object);
    }
}

