/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.codegen.jet;

import com.tikal.codegen.jet.EmitterException;
import com.tikal.codegen.jet.ErrorCode;
import com.tikal.codegen.jet.TemplateElement;
import com.tikal.codegen.jet.parser.TemplateParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class TemplateEmitter {
    private final URL templateURL;
    private final TemplateParser parser;
    private Skeleton skeleton = null;

    public TemplateEmitter(URL templateURL) {
        this.templateURL = templateURL;
        this.parser = new TemplateParser(templateURL);
    }

    public String getPackageName() {
        return this.skeleton.packageName;
    }

    public String getClassName() {
        return this.skeleton.className;
    }

    public void parse() throws EmitterException {
        try {
            if (!this.parser.parse()) {
                throw this.parser.getFaultReason();
            }
            this.skeleton = this.createSkeleton();
        }
        catch (IOException e) {
            throw new EmitterException(ErrorCode.UNKNOWN, (Throwable)e);
        }
    }

    public String generate() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.skeleton.header);
        builder.append("\n\t\tStringBuffer builder = new StringBuffer();");
        for (TemplateElement templateElement : this.parser.getElements()) {
            templateElement.generate(builder);
        }
        builder.append("\n\t\treturn builder.toString();\n\t");
        builder.append(this.skeleton.footer);
        return builder.toString();
    }

    private Skeleton createSkeleton() throws EmitterException {
        Skeleton skeleton = new Skeleton();
        skeleton.packageName = this.parser.getPackageName();
        skeleton.className = this.parser.getClassName();
        if (StringUtils.isBlank((String)skeleton.className)) {
            throw new EmitterException(ErrorCode.CLASS_NAME_UNDEFINED);
        }
        URL skeletonURL = null;
        if (StringUtils.isNotEmpty((String)this.parser.getSkeleton())) {
            String templateURLName = this.templateURL.toString();
            int pos = templateURLName.lastIndexOf("/");
            if (pos >= 0) {
                String skeletonURLString = templateURLName.substring(0, pos + 1) + this.parser.getSkeleton();
                try {
                    skeletonURL = new URL(skeletonURLString);
                }
                catch (MalformedURLException e) {
                    throw new EmitterException(ErrorCode.SKELETON_NOT_FOUND, skeletonURLString, e.getMessage());
                }
            }
        } else {
            skeletonURL = this.getClass().getResource("/default.skeleton");
        }
        StringWriter skeletonWriter = new StringWriter();
        try {
            IOUtils.copy((InputStream)skeletonURL.openStream(), (Writer)skeletonWriter);
        }
        catch (IOException e) {
            throw new EmitterException(ErrorCode.SKELETON_READ_FAILED, skeletonURL.toString());
        }
        String skeletonContent = skeletonWriter.toString();
        int pos = skeletonContent.indexOf("generate");
        if (pos > 0) {
            int pos1 = skeletonContent.indexOf("{", pos);
            int pos2 = skeletonContent.indexOf("}", pos1);
            String left = skeletonContent.substring(0, pos1 + 1);
            String right = skeletonContent.substring(pos2);
            if (StringUtils.isNotBlank((String)skeleton.packageName)) {
                left = left.replace("PACKAGE", this.parser.getPackageName());
            }
            left = left.replace("CLASS", skeleton.className);
            if (StringUtils.isNotBlank((String)this.parser.getImports())) {
                String[] imports = this.parser.getImports().split(" ");
                StringBuilder builder = new StringBuilder("\n");
                for (String imp : imports) {
                    builder.append("import ");
                    builder.append(imp);
                    builder.append(";\n");
                }
                pos = left.indexOf("package");
                pos = pos >= 0 ? left.indexOf(";", pos + 1) : 0;
                left = left.substring(0, pos + 1) + builder.toString() + left.substring(pos + 1);
            }
            skeleton.header = left;
            skeleton.footer = right;
        }
        return skeleton;
    }

    static class Skeleton {
        String packageName;
        String className;
        String header;
        String footer;

        Skeleton() {
        }
    }
}

