/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.ConnectionCloseHandlerNotifier;
import com.sun.grizzly.util.SSLUtils;
import com.sun.grizzly.util.Utils;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;

public class InputReader
extends InputStream {
    private ChannelType defaultChannelType = ChannelType.SocketChannel;
    private static int defaultReadTimeout = 30000;
    protected ByteBuffer byteBuffer;
    protected ByteBuffer inputBB;
    public SelectionKey key = null;
    protected int readTimeout = defaultReadTimeout;
    private boolean secure = false;
    private boolean isClosed = false;
    protected SSLEngine sslEngine;

    public InputReader() {
    }

    public InputReader(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int available() {
        return this.byteBuffer.remaining();
    }

    public void close() {
        this.isClosed = true;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            this.byteBuffer.clear();
            int eof = this.doRead();
            if (eof <= 0) {
                return -1;
            }
        }
        return this.byteBuffer.hasRemaining() ? this.byteBuffer.get() & 0xFF : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            this.byteBuffer.clear();
            int eof = this.doRead();
            if (eof <= 0) {
                return -1;
            }
        }
        if (length > this.byteBuffer.remaining()) {
            length = this.byteBuffer.remaining();
        }
        this.byteBuffer.get(b, offset, length);
        return length;
    }

    public int read(ByteBuffer bb) throws IOException {
        ByteBuffer oldBB = this.byteBuffer;
        this.byteBuffer = bb;
        int initialPosition = bb.position();
        int eof = this.doRead();
        if (eof <= 0) {
            return -1;
        }
        this.byteBuffer = oldBB;
        int bytesRead = bb.limit() - initialPosition;
        return bytesRead;
    }

    public void recycle() {
        this.sslEngine = null;
        this.secure = false;
        this.byteBuffer = null;
        this.inputBB = null;
        this.key = null;
        this.isClosed = false;
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    protected int doRead() throws IOException {
        if (this.key == null || this.isClosed) {
            return -1;
        }
        int nRead = -1;
        try {
            if (this.secure) {
                nRead = this.doSecureRead();
            }
            nRead = this.doClearRead();
            return nRead;
        }
        catch (IOException ex) {
            nRead = -1;
            throw ex;
        }
        finally {
            ConnectionCloseHandlerNotifier notifier;
            if (nRead == -1 && Thread.currentThread() instanceof WorkerThread && (notifier = (ConnectionCloseHandlerNotifier)((WorkerThread)Thread.currentThread()).getAttachment().getAttribute("ConnectionCloseHandlerNotifier")) != null) {
                notifier.notifyRemotlyClose(this.key);
            }
            return nRead;
        }
    }

    protected int doSecureRead() throws IOException {
        Utils.Result r = SSLUtils.doSecureRead((SocketChannel)this.key.channel(), this.sslEngine, this.byteBuffer, this.inputBB);
        this.byteBuffer.flip();
        this.isClosed = r.isClosed;
        return r.bytesRead;
    }

    protected int doClearRead() throws IOException {
        Utils.Result r = Utils.readWithTemporarySelector(this.key.channel(), this.byteBuffer, this.readTimeout);
        this.byteBuffer.flip();
        this.isClosed = r.isClosed;
        return r.bytesRead;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int rt) {
        this.readTimeout = rt;
    }

    public static int getDefaultReadTimeout() {
        return defaultReadTimeout;
    }

    public static void setDefaultReadTimeout(int aDefaultReadTimeout) {
        defaultReadTimeout = aDefaultReadTimeout;
    }

    public ChannelType getChannelType() {
        return this.defaultChannelType;
    }

    public void setChannelType(ChannelType channelType) {
        this.defaultChannelType = channelType;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public void setSslEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public ByteBuffer getInputBB() {
        return this.inputBB;
    }

    public void setInputBB(ByteBuffer inputBB) {
        this.inputBB = inputBB;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChannelType {
        SocketChannel,
        DatagramChannel;

    }
}

