/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api;

import com.streamsets.pipeline.api.Config;
import com.streamsets.pipeline.api.ErrorCode;
import com.streamsets.pipeline.api.GenerateResourceBundle;
import com.streamsets.pipeline.api.StageException;
import java.util.List;

public interface StageUpgrader {
    default public List<Config> upgrade(List<Config> configs, Context context) throws StageException {
        return this.upgrade(context.getLibrary(), context.getStageName(), context.getStageInstance(), context.getFromVersion(), context.getToVersion(), configs);
    }

    @Deprecated
    default public List<Config> upgrade(String library, String stageName, String stageInstance, int fromVersion, int toVersion, List<Config> configs) throws StageException {
        return configs;
    }

    public static interface Context {
        public String getLibrary();

        public String getStageName();

        public String getStageInstance();

        public int getFromVersion();

        public int getToVersion();

        public void registerService(Class var1, List<Config> var2);
    }

    public static class Default
    implements StageUpgrader {
        @Override
        public List<Config> upgrade(List<Config> configs, Context context) throws StageException {
            throw new StageException(Error.UPGRADER_00, context.getLibrary(), context.getStageName(), context.getStageInstance());
        }
    }

    @GenerateResourceBundle
    public static enum Error implements ErrorCode
    {
        UPGRADER_00("Upgrader not implemented for stage '{}:{}' instance '{}'"),
        UPGRADER_01("Cannot upgrade stage '{}:{}' instance '{}' from version '{}' to version '{}'");

        private final String message;

        private Error(String message) {
            this.message = message;
        }

        @Override
        public String getCode() {
            return this.name();
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

