/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.calculator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import org.sagacity.sqltoy.config.model.LabelIndexModel;
import org.sagacity.sqltoy.config.model.RowsChainRelativeModel;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class RowsChainRelative {
    public static void process(RowsChainRelativeModel rowsRelative, LabelIndexModel labelIndexMap, List result) {
        Object[] relativeIndexs;
        int i;
        int groupColIndex;
        int end;
        if (result == null || result.size() < 2) {
            return;
        }
        if (rowsRelative.getRelativeColumns() == null || rowsRelative.getRelativeColumns().length == 0) {
            throw new IllegalArgumentException("\u884c\u4e0e\u884c\u7684\u73af\u6bd4\u8ba1\u7b97[rows-chain-relative]\u6ca1\u6709\u8bbe\u7f6erelative-columns\u5177\u4f53\u7684\u73af\u6bd4\u5217!");
        }
        int dataSize = result.size();
        boolean isAppend = rowsRelative.isInsert();
        Integer[] realRelativeCols = new Integer[rowsRelative.getRelativeColumns().length];
        int start = rowsRelative.getStartRow() == null ? 0 : rowsRelative.getStartRow();
        int n = end = rowsRelative.getEndRow() == null ? dataSize - 1 : rowsRelative.getEndRow();
        if (end < 0) {
            end = dataSize - 1 + end;
        }
        if (end > dataSize - 1) {
            end = dataSize - 1;
        }
        int groupSize = 1;
        if (StringUtil.isNotBlank(rowsRelative.getGroupColumn()) && (groupColIndex = NumberUtil.isInteger(rowsRelative.getGroupColumn()) ? Integer.parseInt(rowsRelative.getGroupColumn()) : labelIndexMap.get(rowsRelative.getGroupColumn().toLowerCase())) >= 0 && groupColIndex < ((List)result.get(0)).size()) {
            HashSet map = new HashSet();
            for (i = start; i <= end; ++i) {
                List rowData = (List)result.get(i);
                map.add(rowData.get(groupColIndex));
            }
            groupSize = map.size();
        }
        if ((relativeIndexs = rowsRelative.getRelativeIndexs()) == null || relativeIndexs.length == 0) {
            relativeIndexs = new Integer[groupSize];
            for (int i2 = 0; i2 < groupSize; ++i2) {
                relativeIndexs[i2] = i2;
            }
        } else {
            CollectionUtil.sortArray(relativeIndexs, false);
        }
        int addIndex = 0;
        for (i = 0; i < rowsRelative.getRelativeColumns().length; ++i) {
            String relativeCol = rowsRelative.getRelativeColumns()[i].toLowerCase();
            realRelativeCols[i] = NumberUtil.isInteger(relativeCol) ? Integer.valueOf(Integer.parseInt(relativeCol) + addIndex) : Integer.valueOf(labelIndexMap.get(relativeCol) + addIndex);
            if (!isAppend) continue;
            ++addIndex;
        }
        String defaultValue = rowsRelative.getDefaultValue();
        if (isAppend) {
            int n2 = result.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                List rowList = (List)result.get(i3);
                for (int j = 0; j < realRelativeCols.length; ++j) {
                    rowList.add(realRelativeCols[j] + 1, defaultValue);
                }
            }
        }
        double divData = 0.0;
        double divedData = 0.0;
        int radixSize = rowsRelative.getRadixSize();
        boolean isIncrement = rowsRelative.isReduceOne();
        double multiply = rowsRelative.getMultiply();
        String format = rowsRelative.getFormat();
        if (rowsRelative.isReverse()) {
            for (int i4 = end - groupSize; i4 > start; i4 -= groupSize) {
                for (int j = 0; j < relativeIndexs.length; ++j) {
                    int index = (Integer)relativeIndexs[j];
                    int divIndex = i4 - groupSize + index + 1;
                    int divedIndex = i4 + index + 1;
                    List divRowList = (List)result.get(divIndex);
                    List divedRowList = (List)result.get(divedIndex);
                    for (int k = 0; k < realRelativeCols.length; ++k) {
                        int colIndex = realRelativeCols[k];
                        if (divRowList.get(colIndex) != null) {
                            divData = Double.parseDouble(divRowList.get(colIndex).toString());
                        }
                        if (divedRowList.get(colIndex) != null) {
                            divedData = Double.parseDouble(divedRowList.get(colIndex).toString());
                        }
                        if (divedData == 0.0) {
                            divRowList.set(colIndex + 1, divData == 0.0 ? Integer.valueOf(0) : defaultValue);
                            continue;
                        }
                        BigDecimal value = new BigDecimal((divData - (isIncrement ? divedData : 0.0)) * multiply / divedData).setScale(radixSize, RoundingMode.FLOOR);
                        if (format == null) {
                            divRowList.set(colIndex + 1, value);
                            continue;
                        }
                        divRowList.set(colIndex + 1, NumberUtil.format(value, format));
                    }
                }
            }
        } else {
            for (int i5 = start + groupSize; i5 < end; i5 += groupSize) {
                for (int j = 0; j < relativeIndexs.length; ++j) {
                    int index = (Integer)relativeIndexs[j];
                    int divIndex = i5 + index;
                    int divedIndex = i5 + index - groupSize;
                    List divRowList = (List)result.get(divIndex);
                    List divedRowList = (List)result.get(divedIndex);
                    for (int k = 0; k < realRelativeCols.length; ++k) {
                        int colIndex = realRelativeCols[k];
                        if (divRowList.get(colIndex) != null) {
                            divData = Double.parseDouble(divRowList.get(colIndex).toString());
                        }
                        if (divedRowList.get(colIndex) != null) {
                            divedData = Double.parseDouble(divedRowList.get(colIndex).toString());
                        }
                        if (divedData == 0.0) {
                            divRowList.set(colIndex + 1, divData == 0.0 ? Integer.valueOf(0) : "");
                            continue;
                        }
                        BigDecimal value = new BigDecimal((divData - (isIncrement ? divedData : 0.0)) * multiply / divedData).setScale(radixSize, RoundingMode.FLOOR);
                        if (format == null) {
                            divRowList.set(colIndex + 1, value);
                            continue;
                        }
                        divRowList.set(colIndex + 1, NumberUtil.format(value, format));
                    }
                }
            }
        }
    }
}

