/*
 * Decompiled with CFR 0.152.
 */
package com.radcortez.flyway.test.junit;

import com.radcortez.flyway.test.annotation.DataSource;
import com.radcortez.flyway.test.annotation.FlywayTest;
import com.radcortez.flyway.test.junit.DataSourceInfo;
import com.radcortez.flyway.test.junit.DataSourceProvider;
import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flywaydb.core.Flyway;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class FlywayExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback {
    public void beforeAll(ExtensionContext context) {
        Optional<FlywayTestConfiguration> configuration = this.findFlywayAnnnotation(context);
        if (configuration.isEmpty()) {
            return;
        }
        Flyway flyway = this.flyway(configuration.get(), context);
        if (configuration.get().isClean()) {
            flyway.clean();
        }
        flyway.migrate();
    }

    public void beforeEach(ExtensionContext context) {
        this.findFlywayAnnnotation(context).filter(FlywayTestConfiguration::isClean).map(configuration -> this.flyway((FlywayTestConfiguration)configuration, context)).ifPresent(Flyway::migrate);
    }

    public void afterEach(ExtensionContext context) {
        this.findFlywayAnnnotation(context).filter(FlywayTestConfiguration::isClean).map(configuration -> this.flyway((FlywayTestConfiguration)configuration, context)).ifPresent(Flyway::clean);
    }

    private Flyway flyway(FlywayTestConfiguration configuration, ExtensionContext context) {
        String packageName = context.getRequiredTestClass().getName();
        String testDefaultLocation = "db/" + packageName.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
        ArrayList<String> locations = new ArrayList<String>(configuration.getLocations());
        locations.add(testDefaultLocation);
        locations.add("db" + File.separator + "migration");
        return Flyway.configure().dataSource(configuration.getDatasourceInfo().getUrl(), configuration.getDatasourceInfo().getUsername(), configuration.getDatasourceInfo().getPassword()).connectRetries(120).locations((String[])locations.toArray(String[]::new)).load();
    }

    private Optional<FlywayTestConfiguration> findFlywayAnnnotation(ExtensionContext context) {
        Optional classAnnotation = context.getTestClass().flatMap(klass -> AnnotationUtils.findAnnotation((AnnotatedElement)klass, FlywayTest.class));
        Optional methodAnnotation = context.getTestMethod().flatMap(klass -> AnnotationUtils.findAnnotation((AnnotatedElement)klass, FlywayTest.class));
        if (Stream.of(classAnnotation, methodAnnotation).flatMap(Optional::stream).findAny().isEmpty()) {
            return Optional.empty();
        }
        String url = Stream.of(methodAnnotation, classAnnotation).flatMap(Optional::stream).map(FlywayTest::value).map(DataSource::url).filter(FlywayExtension::isNotEmpty).findFirst().orElse("");
        String username = Stream.of(methodAnnotation, classAnnotation).flatMap(Optional::stream).map(FlywayTest::value).map(DataSource::username).filter(FlywayExtension::isNotEmpty).findFirst().orElse("");
        String password = Stream.of(methodAnnotation, classAnnotation).flatMap(Optional::stream).map(FlywayTest::value).map(DataSource::password).filter(FlywayExtension::isNotEmpty).findFirst().orElse("");
        List<String> locations = Stream.of(methodAnnotation, classAnnotation).flatMap(Optional::stream).map(FlywayTest::additionalLocations).flatMap(Stream::of).collect(Collectors.toList());
        Boolean clean = Stream.of(methodAnnotation, classAnnotation).flatMap(Optional::stream).map(FlywayTest::clean).findFirst().orElse(true);
        DataSourceInfo datasourceInfo = Stream.of(methodAnnotation, classAnnotation).flatMap(Optional::stream).map(FlywayTest::value).map(DataSource::value).map(FlywayExtension::newDatasourceProvider).filter(provider -> !(provider instanceof DataSource.DEFAULT)).map(provider -> provider.getDatasourceInfo(context)).findFirst().orElse(DataSourceInfo.config(url, username, password));
        if (datasourceInfo.getUrl() == null) {
            throw new IllegalStateException("No jdbc url provided.");
        }
        return Optional.of(FlywayTestConfiguration.flywayTestConfiguration(datasourceInfo, locations, clean));
    }

    private static DataSourceProvider newDatasourceProvider(Class<? extends DataSourceProvider> klass) {
        try {
            return klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    private static boolean isNotEmpty(String s) {
        return !s.isEmpty();
    }

    private static class FlywayTestConfiguration {
        private DataSourceInfo datasourceInfo;
        private List<String> locations;
        private boolean clean;

        private FlywayTestConfiguration(DataSourceInfo datasourceInfo, List<String> locations, boolean clean) {
            this.datasourceInfo = datasourceInfo;
            this.locations = locations;
            this.clean = clean;
        }

        private static FlywayTestConfiguration flywayTestConfiguration(DataSourceInfo datasourceInfo, List<String> locations, boolean clean) {
            return new FlywayTestConfiguration(datasourceInfo, locations, clean);
        }

        DataSourceInfo getDatasourceInfo() {
            return this.datasourceInfo;
        }

        List<String> getLocations() {
            return this.locations;
        }

        boolean isClean() {
            return this.clean;
        }
    }
}

