/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class OAbstractRecordReplicatedTask
extends OAbstractReplicatedTask {
    protected ORecordId rid;
    protected ORecordVersion version;
    protected boolean inTx = false;

    public OAbstractRecordReplicatedTask() {
    }

    public OAbstractRecordReplicatedTask(ORecordId iRid, ORecordVersion iVersion) {
        this.rid = iRid;
        this.version = iVersion;
    }

    public abstract ORecord getRecord();

    @Override
    public String toString() {
        return super.toString() + "(" + this.rid + " v." + this.version + ")";
    }

    public ORecordId getRid() {
        return this.rid;
    }

    public void setRid(ORecordId rid) {
        this.rid = rid;
    }

    public ORecordVersion getVersion() {
        return this.version;
    }

    public void setVersion(ORecordVersion version) {
        this.version = version;
    }

    abstract void setLockRecord(boolean var1);

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.rid.toString());
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().writeTo((DataOutput)out, this.version);
        out.writeBoolean(this.inTx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rid = new ORecordId(in.readUTF());
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().readFrom((DataInput)in, this.version);
        this.inTx = in.readBoolean();
    }

    public boolean isInTx() {
        return this.inTx;
    }

    public void setInTx(boolean inTx) {
        this.inTx = inTx;
    }

    @Override
    public String getPayload() {
        return "rid=" + this.rid + " v=" + this.version;
    }
}

