/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLProcessHaltedException;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.transformer.OAbstractLookupTransformer;

public class OMergeTransformer
extends OAbstractLookupTransformer {
    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + "," + "{joinFieldName:{optional:false,description:'field name containing the value to join'}}," + "{lookup:{optional:false,description:'<Class>.<property> or Query to execute'}}," + "{unresolvedLinkAction:{optional:true,description:'action when a unresolved link is found',values:" + this.stringArray2Json((Object[])OAbstractLookupTransformer.ACTION.values()) + "}}]," + "input:['ODocument'],output:'ODocument'}");
    }

    @Override
    public String getName() {
        return "merge";
    }

    @Override
    public Object executeTransform(Object input) {
        Object joinValue = ((ODocument)((OIdentifiable)input).getRecord()).field(this.joinFieldName);
        Object result = this.lookup(joinValue, false);
        this.log(OETLProcessor.LOG_LEVELS.DEBUG, "joinValue=%s, lookupResult=%s", joinValue, result);
        if (result != null) {
            if (result instanceof OIdentifiable) {
                ((ODocument)result).merge((ODocument)input, true, false);
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "merged record %s with found record=%s", result, input);
                return result;
            }
            if (OMultiValue.isMultiValue((Object)result) && OMultiValue.getSize((Object)result) == 1) {
                Object firstValue = OMultiValue.getFirstValue((Object)result);
                ((ODocument)firstValue).merge((ODocument)((OIdentifiable)input).getRecord(), true, false);
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "merged record %s with found record=%s", firstValue, input);
                return firstValue;
            }
            if (OMultiValue.isMultiValue((Object)result) && OMultiValue.getSize((Object)result) > 1) {
                throw new OETLProcessHaltedException("[Merge transformer] Multiple results returned from join for value '" + joinValue + "'");
            }
        } else {
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "unresolved link!!! %s", OMultiValue.getSize((Object)result));
            switch (this.unresolvedLinkAction) {
                case NOTHING: {
                    break;
                }
                case ERROR: {
                    this.processor.getStats().incrementErrors();
                    this.log(OETLProcessor.LOG_LEVELS.ERROR, "%s: ERROR Cannot resolve join for value '%s'", this.getName(), joinValue);
                    break;
                }
                case WARNING: {
                    this.processor.getStats().incrementWarnings();
                    this.log(OETLProcessor.LOG_LEVELS.INFO, "%s: WARN Cannot resolve join for value '%s'", this.getName(), joinValue);
                    break;
                }
                case SKIP: {
                    return null;
                }
                case HALT: {
                    throw new OETLProcessHaltedException("[Merge transformer] Cannot resolve join for value '" + joinValue + "'");
                }
            }
        }
        return input;
    }
}

