/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLProcessHaltedException;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.transformer.OAbstractLookupTransformer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class OLinkTransformer
extends OAbstractLookupTransformer {
    private String joinValue;
    private String linkFieldName;
    private OType linkFieldType;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + "," + "{joinFieldName:{optional:true,description:'field name containing the value to join'}}," + "{joinValue:{optional:true,description:'value to use in lookup query'}}," + "{linkFieldName:{optional:false,description:'field name containing the link to set'}}," + "{linkFieldType:{optional:true,description:'field type containing the link to set. Use LINK for single link and LINKSET or LINKLIST for many'}}," + "{lookup:{optional:false,description:'<Class>.<property> or Query to execute'}}," + "{unresolvedLinkAction:{optional:true,description:'action when a unresolved link is found',values:" + this.stringArray2Json((Object[])OAbstractLookupTransformer.ACTION.values()) + "}}]," + "input:['ODocument'],output:'ODocument'}");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        this.joinValue = (String)iConfiguration.field("joinValue");
        this.linkFieldName = (String)iConfiguration.field("linkFieldName");
        if (iConfiguration.containsField("linkFieldType")) {
            this.linkFieldType = OType.valueOf((String)((String)iConfiguration.field("linkFieldType")));
        }
    }

    @Override
    public String getName() {
        return "link";
    }

    @Override
    public Object executeTransform(Object input) {
        Object result;
        if (!(input instanceof OIdentifiable)) {
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "skip because input value is not a record, but rather an instance of class: %s", input.getClass());
            return null;
        }
        ODocument doc = (ODocument)((OIdentifiable)input).getRecord();
        Object joinRuntimeValue = this.joinFieldName != null ? doc.field(this.joinFieldName) : (this.joinValue != null ? this.resolve(this.joinValue) : null);
        if (OMultiValue.isMultiValue((Object)joinRuntimeValue)) {
            ArrayList<Object> singleJoinsResult = new ArrayList<Object>();
            for (Object o : OMultiValue.getMultiValueIterable((Object)joinRuntimeValue)) {
                singleJoinsResult.add(this.lookup(o, true));
            }
            result = singleJoinsResult;
        } else {
            result = this.lookup(joinRuntimeValue, true);
        }
        this.log(OETLProcessor.LOG_LEVELS.DEBUG, "joinRuntimeValue=%s, lookupResult=%s", joinRuntimeValue, result);
        if (result != null) {
            if (this.linkFieldType != null) {
                AbstractCollection res;
                if (this.linkFieldType == OType.LINK) {
                    if (result instanceof Collection) {
                        result = !((Collection)result).isEmpty() ? ((Collection)result).iterator().next() : null;
                    }
                } else if (this.linkFieldType == OType.LINKSET) {
                    if (!(result instanceof Collection)) {
                        res = new HashSet<OIdentifiable>();
                        res.add((OIdentifiable)result);
                        result = res;
                    }
                } else if (this.linkFieldType == OType.LINKLIST && !(result instanceof Collection)) {
                    res = new ArrayList();
                    res.add((OIdentifiable)((OIdentifiable)result));
                    result = res;
                }
            }
            if (result == null) {
                switch (this.unresolvedLinkAction) {
                    case CREATE: {
                        if (this.lookup != null) {
                            String[] lookupParts = this.lookup.split("\\.");
                            ODocument linkedDoc = new ODocument(lookupParts[0]);
                            linkedDoc.field(lookupParts[1], joinRuntimeValue);
                            linkedDoc.save();
                            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "created new document=%s", linkedDoc.getRecord());
                            result = linkedDoc;
                            break;
                        }
                        throw new OConfigurationException("Cannot create linked document because target class is unknown. Use 'lookup' field");
                    }
                    case ERROR: {
                        this.processor.getStats().incrementErrors();
                        this.log(OETLProcessor.LOG_LEVELS.ERROR, "%s: ERROR Cannot resolve join for value '%s'", this.getName(), joinRuntimeValue);
                        break;
                    }
                    case WARNING: {
                        this.processor.getStats().incrementWarnings();
                        this.log(OETLProcessor.LOG_LEVELS.INFO, "%s: WARN Cannot resolve join for value '%s'", this.getName(), joinRuntimeValue);
                        break;
                    }
                    case SKIP: {
                        return null;
                    }
                    case HALT: {
                        throw new OETLProcessHaltedException("[Link transformer] Cannot resolve join for value '" + joinRuntimeValue + "'");
                    }
                }
            }
        }
        doc.field(this.linkFieldName, result);
        this.log(OETLProcessor.LOG_LEVELS.DEBUG, "set %s=%s in document=%s", this.linkFieldName, result, input);
        return input;
    }
}

