/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.listener;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.listener.OImporterListener;
import java.util.HashMap;
import java.util.Map;

public class OScriptImporterListener
implements OImporterListener {
    private final Map<String, String> events;
    private Map<String, OCommandScript> scripts = new HashMap<String, OCommandScript>();

    public OScriptImporterListener() {
        this.events = new HashMap<String, String>();
    }

    public OScriptImporterListener(Map<String, String> iEvents) {
        this.events = iEvents;
    }

    @Override
    public void onBeforeFile(ODatabaseDocumentTx db, OCommandContext iContext) {
        this.executeEvent(db, "onBeforeFile", iContext);
    }

    @Override
    public void onAfterFile(ODatabaseDocumentTx db, OCommandContext iContext) {
        this.executeEvent(db, "onAfterFile", iContext);
    }

    @Override
    public boolean onBeforeLine(ODatabaseDocumentTx db, OCommandContext iContext) {
        Object ret = this.executeEvent(db, "onBeforeLine", iContext);
        if (ret != null && ret instanceof Boolean) {
            return (Boolean)ret;
        }
        return true;
    }

    @Override
    public void onAfterLine(ODatabaseDocumentTx db, OCommandContext iContext) {
        this.executeEvent(db, "onAfterLine", iContext);
    }

    @Override
    public void onDump(ODatabaseDocumentTx db, OCommandContext iContext) {
        this.executeEvent(db, "onDump", iContext);
    }

    @Override
    public void onJoinNotFound(ODatabaseDocumentTx db, OCommandContext iContext, OIndex<?> iIndex, Object iKey) {
        this.executeEvent(db, "onJoinNotFound", iContext);
    }

    @Override
    public void validate(ODatabaseDocumentTx db, OCommandContext iContext, ODocument iRecord) {
    }

    private Object executeEvent(ODatabaseDocumentTx db, String iEventName, OCommandContext iContext) {
        String code;
        if (this.events == null) {
            return null;
        }
        OCommandScript script = this.scripts.get(iEventName);
        if (script == null && (code = this.events.get(iEventName)) != null) {
            script = new OCommandScript(code).setLanguage("Javascript");
            this.scripts.put(iEventName, script);
        }
        if (script != null) {
            HashMap<String, Object> pars = new HashMap<String, Object>();
            pars.put("task", iContext);
            pars.put("importer", this);
            return db.command((OCommandRequest)script).execute(new Object[]{pars});
        }
        return null;
    }
}

