/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl;

import com.orientechnologies.common.parser.OVariableParser;
import com.orientechnologies.common.parser.OVariableParserListener;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.etl.OETLComponent;
import com.orientechnologies.orient.etl.OETLProcessor;

public abstract class OAbstractETLComponent
implements OETLComponent {
    protected OETLProcessor processor;
    protected OCommandContext context;
    protected OETLProcessor.LOG_LEVELS logLevel;
    protected String output;
    protected String ifExpression;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + "]");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        this.processor = iProcessor;
        this.context = iContext;
        this.ifExpression = (String)iConfiguration.field("if");
        this.logLevel = iConfiguration.containsField("log") ? OETLProcessor.LOG_LEVELS.valueOf(iConfiguration.field("log").toString().toUpperCase()) : iProcessor.getLogLevel();
        if (iConfiguration.containsField("output")) {
            this.output = (String)iConfiguration.field("output");
        }
    }

    @Override
    public void begin() {
    }

    @Override
    public void end() {
    }

    protected String getCommonConfigurationParameters() {
        return "{log:{optional:true,description:'Can be any of [NONE, ERROR, INFO, DEBUG]. Default is INFO'}},{if:{optional:true,description:'Conditional expression. If true, the block is executed, otherwise is skipped'}},{output:{optional:true,description:'Variable name to store the transformer output. If null, the output will be passed to the pipeline as input for the next component.'}}";
    }

    public String toString() {
        return this.getName();
    }

    protected boolean skip(Object input) {
        OSQLFilter ifFilter = this.getIfFilter();
        if (ifFilter != null) {
            ODocument doc = input instanceof OIdentifiable ? (ODocument)((OIdentifiable)input).getRecord() : null;
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "Evaluating conditional expression if=%s...", ifFilter);
            Object result = ifFilter.evaluate((OIdentifiable)doc, null, this.context);
            if (!(result instanceof Boolean)) {
                throw new OConfigurationException("'if' expression in Transformer " + this.getName() + " returned '" + result + "' instead of boolean");
            }
            return (Boolean)result == false;
        }
        return false;
    }

    protected OSQLFilter getIfFilter() {
        if (this.ifExpression != null) {
            return new OSQLFilter(this.ifExpression, this.context, null);
        }
        return null;
    }

    protected void log(OETLProcessor.LOG_LEVELS iLevel, String iText, Object ... iArgs) {
        if (this.logLevel.ordinal() >= iLevel.ordinal()) {
            Long extractedNum;
            Long l = extractedNum = this.context != null ? (Long)this.context.getVariable("extractedNum") : null;
            if (extractedNum != null) {
                System.out.println("[" + extractedNum + ":" + this.getName() + "] " + (Object)((Object)iLevel) + " " + String.format(iText, iArgs));
            } else {
                System.out.println("[" + this.getName() + "] " + (Object)((Object)iLevel) + " " + String.format(iText, iArgs));
            }
        }
    }

    protected String stringArray2Json(Object[] iObject) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append('[');
        for (int i = 0; i < iObject.length; ++i) {
            Object value;
            if (i > 0) {
                buffer.append(',');
            }
            if ((value = iObject[i]) == null) continue;
            buffer.append("'");
            buffer.append(value.toString());
            buffer.append("'");
        }
        buffer.append(']');
        return buffer.toString();
    }

    protected Object resolve(Object iContent) {
        if (this.context == null || iContent == null) {
            return iContent;
        }
        Object value = iContent instanceof String ? (((String)iContent).startsWith("$") && !((String)iContent).startsWith("${") ? this.context.getVariable(iContent.toString()) : OVariableParser.resolveVariables((String)((String)iContent), (String)"${", (String)"}", (OVariableParserListener)new OVariableParserListener(){

            public Object resolve(String iVariable) {
                return OAbstractETLComponent.this.context.getVariable(iVariable);
            }
        })) : iContent;
        if (value instanceof String) {
            value = OVariableParser.resolveVariables((String)((String)value), (String)"={", (String)"}", (OVariableParserListener)new OVariableParserListener(){

                public Object resolve(String iVariable) {
                    return new OSQLPredicate(iVariable).evaluate(OAbstractETLComponent.this.context);
                }
            });
        }
        return value;
    }
}

