/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.context;

import com.openhtmltopdf.css.extend.StylesheetFactory;
import com.openhtmltopdf.css.parser.CSSParser;
import com.openhtmltopdf.css.sheet.Ruleset;
import com.openhtmltopdf.css.sheet.Stylesheet;
import com.openhtmltopdf.css.sheet.StylesheetInfo;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.resource.CSSResource;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class StylesheetFactoryImpl
implements StylesheetFactory {
    private UserAgentCallback _userAgentCallback;
    private final int _cacheCapacity = 16;
    private final LinkedHashMap<String, Stylesheet> _cache = new LinkedHashMap<String, Stylesheet>(16, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Stylesheet> eldest) {
            return this.size() > 16;
        }
    };
    private CSSParser _cssParser;

    public StylesheetFactoryImpl(UserAgentCallback userAgentCallback) {
        this._userAgentCallback = userAgentCallback;
        this._cssParser = new CSSParser((uri, message) -> XRLog.log(Level.WARNING, LogMessageId.LogMessageId2Param.CSS_PARSE_GENERIC_MESSAGE, (Object)uri, (Object)message));
    }

    @Override
    public Stylesheet parse(Reader reader, StylesheetInfo info) {
        try {
            return this._cssParser.parseStylesheet(info.getUri(), info.getOrigin(), reader);
        }
        catch (IOException e) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId2Param.CSS_PARSE_COULDNT_PARSE_STYLESHEET_AT_URI, (Object)info.getUri(), (Object)e.getMessage(), e);
            return new Stylesheet(info.getUri(), info.getOrigin());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stylesheet parse(StylesheetInfo info) {
        CSSResource cr = this._userAgentCallback.getCSSResource(info.getUri());
        if (cr == null) {
            return null;
        }
        Reader reader = cr.getResourceReader();
        if (reader == null) {
            return null;
        }
        try {
            Stylesheet stylesheet = this.parse(reader, info);
            return stylesheet;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public Ruleset parseStyleDeclaration(int origin, String styleDeclaration) {
        return this._cssParser.parseDeclaration(origin, styleDeclaration);
    }

    @Deprecated
    public void putStylesheet(String key, Stylesheet sheet) {
        this._cache.put(key, sheet);
    }

    @Deprecated
    public boolean containsStylesheet(String key) {
        return this._cache.containsKey(key);
    }

    @Deprecated
    public Stylesheet getCachedStylesheet(String key) {
        return this._cache.get(key);
    }

    @Deprecated
    public Object removeCachedStylesheet(String key) {
        return this._cache.remove(key);
    }

    @Deprecated
    public void flushCachedStylesheets() {
        this._cache.clear();
    }

    @Override
    public Stylesheet getStylesheet(StylesheetInfo info) {
        XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.LOAD_REQUESTING_STYLESHEET_AT_URI, info.getUri());
        Stylesheet s = this.getCachedStylesheet(info.getUri());
        if (s == null && !this.containsStylesheet(info.getUri())) {
            s = this.parse(info);
            this.putStylesheet(info.getUri(), s);
        }
        return s;
    }

    public void setUserAgentCallback(UserAgentCallback userAgent) {
        this._userAgentCallback = userAgent;
    }

    public void setSupportCMYKColors(boolean b) {
        this._cssParser.setSupportCMYKColors(b);
    }
}

