/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.testng;

import com.mycila.log.Logger;
import com.mycila.log.Loggers;
import com.mycila.testing.core.Mycila;
import com.mycila.testing.core.MycilaTesting;
import com.mycila.testing.core.api.TestExecution;
import com.mycila.testing.core.api.TestNotifier;
import com.mycila.testing.core.api.TestPluginException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.testng.Assert;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.internal.MethodHelper;

public abstract class MycilaTestNGTest
extends Assert
implements IHookable {
    private static final Logger LOGGER = Loggers.get(MycilaTestNGTest.class);
    private TestNotifier testNotifier;

    @BeforeClass(alwaysRun=true)
    protected final void prepareTestInstance() {
        this.testNotifier = MycilaTesting.from(((Object)((Object)this)).getClass()).configure((Object)this).createNotifier((Object)this);
        this.testNotifier.prepare();
    }

    public final void run(IHookCallBack callBack, ITestResult testResult) {
        this.testNotifier.fireBeforeTest(testResult.getMethod().getMethod());
        TestExecution testExecution = (TestExecution)Mycila.currentExecution();
        if (testExecution.mustSkip()) {
            testResult.setStatus(3);
        } else {
            LOGGER.debug((Object)"Calling test method %s.%s", new Object[]{testExecution.method().getDeclaringClass().getName(), testExecution.method().getName()});
            try {
                Field field = callBack.getClass().getDeclaredField("val$instance");
                field.setAccessible(true);
                MethodHelper.invokeMethod((Method)testResult.getMethod().getMethod(), (Object)field.get(callBack), (Object[])testResult.getParameters());
            }
            catch (Throwable e) {
                testExecution.setThrowable(e);
            }
        }
        try {
            this.testNotifier.fireAfterTest();
        }
        catch (TestPluginException e) {
            testExecution.setThrowable(e);
        }
        testResult.setThrowable(testExecution.throwable());
    }

    @AfterClass(alwaysRun=true)
    protected final void end() {
        this.testNotifier.fireAfterClass();
    }

    @AfterSuite(alwaysRun=true)
    protected final void shutdown() {
        if (this.testNotifier != null) {
            this.testNotifier.shutdown();
        }
    }
}

