/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.core.introspect;

import com.mycila.testing.MycilaTestingException;
import com.mycila.testing.core.api.Ensure;
import com.mycila.testing.core.introspect.Filter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Introspector {
    private final Object instance;

    public Introspector(Object instance) {
        Ensure.notNull("Object to introspect", instance);
        this.instance = instance;
    }

    public Object instance() {
        return this.instance;
    }

    public Class<?> testClass() {
        return this.instance.getClass();
    }

    public List<Field> selectFields(Filter<Field> filter) {
        Ensure.notNull("Filter", filter);
        for (Class<?> c = this.testClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                filter.add(Ensure.accessible(field));
            }
        }
        return filter.select();
    }

    public List<Method> selectMethods(Filter<Method> filter) {
        Ensure.notNull("Filter", filter);
        for (Class<?> c = this.testClass(); c != Object.class; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                filter.add(Ensure.accessible(method));
            }
        }
        return filter.select();
    }

    public Object invoke(Method method, Object ... args) {
        Ensure.notNull("Method", method);
        Ensure.notNull("Method argumentd", args);
        try {
            return method.invoke(this.instance(), args);
        }
        catch (IllegalAccessException e) {
            throw new MycilaTestingException(e, "Error invoking method '%s' with arguments: %s: %s", method, Arrays.deepToString(args), e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new MycilaTestingException(e.getTargetException().getClass().getSimpleName() + ": " + e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (Exception e) {
            throw new MycilaTestingException(e, "Error invoking method '%s' with arguments: %s: %s", method, Arrays.deepToString(args), e.getMessage());
        }
    }

    public Object get(Field field) {
        Ensure.notNull("Field", field);
        try {
            return field.get(this.instance());
        }
        catch (Exception e) {
            throw new MycilaTestingException(e, "Error getting value of field '%s' on test class '%s': %s", field, this.testClass().getName(), e.getMessage());
        }
    }

    public void set(Field field, Object value) {
        Ensure.notNull("Field", field);
        try {
            field.set(this.instance(), value);
        }
        catch (Exception e) {
            throw new MycilaTestingException(e, "Error setting value on field '%s' on test class '%s': %s", field, this.testClass().getName(), e.getMessage());
        }
    }

    public boolean hasAnnotation(Class<? extends Annotation> annot) {
        Ensure.notNull("Annotation", annot);
        return this.testClass().isAnnotationPresent(annot);
    }
}

