/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.core;

import com.mycila.log.Loggers;
import com.mycila.log.jdk.format.ClassFormatter;
import com.mycila.log.jdk.handler.StderrHandler;
import com.mycila.log.jdk.handler.StdoutHandler;
import com.mycila.log.jdk.hook.AsyncInvocationHandler;
import com.mycila.log.jdk.hook.InvocationHandler;
import com.mycila.plugin.spi.PluginManager;
import com.mycila.testing.core.TestContextImpl;
import com.mycila.testing.core.annot.ConfigureMycilaPlugins;
import com.mycila.testing.core.annot.MycilaPlugins;
import com.mycila.testing.core.api.Cache;
import com.mycila.testing.core.api.Ensure;
import com.mycila.testing.core.api.TestNotifier;
import com.mycila.testing.core.introspect.Filter;
import com.mycila.testing.core.introspect.Filters;
import com.mycila.testing.core.introspect.Introspector;
import com.mycila.testing.core.plugin.TestPlugin;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MycilaTesting {
    public static final String DEFAULT_PLUGIN_DESCRIPTOR = "META-INF/mycila/testing/plugins.properties";
    private static final com.mycila.log.Logger LOGGER = Loggers.get(MycilaTesting.class);
    private static final Map<String, MycilaTesting> instances = new HashMap<String, MycilaTesting>();
    private static MycilaTesting customTestHandler;
    private final PluginManager<TestPlugin> pluginManager;

    private MycilaTesting() {
        LOGGER.debug((Object)"Creating new empty plugin manager");
        this.pluginManager = new PluginManager(TestPlugin.class);
    }

    private MycilaTesting(String descriptor) {
        LOGGER.debug((Object)"Creating new plugin manager from descriptor %s", new Object[]{descriptor});
        this.pluginManager = new PluginManager(TestPlugin.class, descriptor);
    }

    public PluginManager<TestPlugin> pluginManager() {
        return this.pluginManager;
    }

    public TestNotifier createNotifier(Object testInstance) {
        Ensure.notNull("Test instance", testInstance);
        return new TestContextImpl(this.pluginManager, testInstance);
    }

    public MycilaTesting configure(Object testInstance) {
        Ensure.notNull("Test instance", testInstance);
        Introspector introspector = new Introspector(testInstance);
        List<Method> methods = introspector.selectMethods(Filters.excludeOverridenMethods(Filters.and(Filters.methodsAnnotatedBy(ConfigureMycilaPlugins.class), new Filter<Method>(){

            @Override
            protected boolean accept(Method method) {
                Class<?>[] types = method.getParameterTypes();
                return types.length == 1 && types[0].equals(PluginManager.class);
            }
        })));
        PluginManager<TestPlugin> pluginManager = this.pluginManager();
        for (Method method : methods) {
            LOGGER.debug((Object)"Configuring plugin manager through method %s.%s...", new Object[]{method.getDeclaringClass().getName(), method.getName()});
            try {
                method.invoke(testInstance, pluginManager);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException().getMessage(), e.getTargetException());
            }
        }
        return this;
    }

    public static MycilaTesting staticDefaultSetup() {
        return MycilaTesting.staticSetup(DEFAULT_PLUGIN_DESCRIPTOR);
    }

    public static MycilaTesting newDefaultSetup() {
        return MycilaTesting.newSetup(DEFAULT_PLUGIN_DESCRIPTOR);
    }

    public static MycilaTesting staticSetup(String pluginDescriptor) {
        Ensure.notNull("Plugin descriptor", pluginDescriptor);
        MycilaTesting testSetup = instances.get(pluginDescriptor);
        if (testSetup == null) {
            testSetup = MycilaTesting.newSetup(pluginDescriptor);
            LOGGER.debug((Object)"Registering new shared plugins for descriptor %s", new Object[]{pluginDescriptor});
            instances.put(pluginDescriptor, testSetup);
        } else {
            LOGGER.debug((Object)"Reusing shared plugins for descriptor %s", new Object[]{pluginDescriptor});
        }
        return testSetup;
    }

    public static MycilaTesting newSetup(String pluginDescriptor) {
        Ensure.notNull("Plugin descriptor", pluginDescriptor);
        return new MycilaTesting(pluginDescriptor);
    }

    public static MycilaTesting staticCustomSetup() {
        if (customTestHandler == null) {
            LOGGER.debug((Object)"Registering new shared empty plugin manager");
            customTestHandler = MycilaTesting.newCustomSetup();
        } else {
            LOGGER.debug((Object)"Reusing existing shared empty plugin manager");
        }
        return customTestHandler;
    }

    public static MycilaTesting newCustomSetup() {
        return new MycilaTesting();
    }

    public static MycilaTesting from(Class<?> c) {
        Ensure.notNull("Test class", c);
        MycilaPlugins mycilaPlugins = c.getAnnotation(MycilaPlugins.class);
        if (mycilaPlugins == null) {
            mycilaPlugins = new MycilaPlugins(){

                @Override
                public Cache value() {
                    return Cache.SHARED;
                }

                @Override
                public String descriptor() {
                    return MycilaTesting.DEFAULT_PLUGIN_DESCRIPTOR;
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return MycilaPlugins.class;
                }
            };
        }
        return MycilaTesting.from(mycilaPlugins);
    }

    public static MycilaTesting from(MycilaPlugins mycilaPlugins) {
        Ensure.notNull("MycilaPlugins annotation", mycilaPlugins);
        if (mycilaPlugins.value() == null) {
            return MycilaTesting.staticDefaultSetup();
        }
        boolean descBlank = mycilaPlugins.descriptor() == null || mycilaPlugins.descriptor().trim().length() == 0;
        switch (mycilaPlugins.value()) {
            case SHARED: {
                return descBlank ? MycilaTesting.staticCustomSetup() : MycilaTesting.staticSetup(mycilaPlugins.descriptor());
            }
            case UNSHARED: {
                return descBlank ? MycilaTesting.newCustomSetup() : MycilaTesting.newSetup(mycilaPlugins.descriptor());
            }
        }
        throw new AssertionError((Object)("Use case not defined for value of enum Cache: " + (Object)((Object)mycilaPlugins.value())));
    }

    public static void debug() {
        StdoutHandler stdoutHandler = new StdoutHandler();
        stdoutHandler.setLevel(Level.ALL);
        stdoutHandler.setMaxLevel(Level.INFO);
        stdoutHandler.setFormatter((Formatter)new ClassFormatter());
        stdoutHandler.setHook((InvocationHandler)new AsyncInvocationHandler());
        StderrHandler stderrHandler = new StderrHandler();
        stderrHandler.setLevel(Level.WARNING);
        stderrHandler.setMaxLevel(Level.SEVERE);
        stderrHandler.setFormatter((Formatter)new ClassFormatter());
        stderrHandler.setHook((InvocationHandler)new AsyncInvocationHandler());
        Logger logger = Logger.getLogger("com.mycila");
        logger.setLevel(Level.ALL);
        logger.addHandler((Handler)stdoutHandler);
        logger.addHandler((Handler)stderrHandler);
    }
}

