/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.aad.msal4j.MsalServiceException;
import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.microsoft.azure.spring.autoconfigure.aad.AzureADGraphClient;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpointsProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Optional;
import java.util.Set;
import javax.naming.ServiceUnavailableException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class AADOAuth2UserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private static final String CONDITIONAL_ACCESS_POLICY = "conditional_access_policy";
    private static final String INVALID_REQUEST = "invalid_request";
    private static final String SERVER_ERROR = "server_error";
    private static final String DEFAULT_USERNAME_ATTR_NAME = "name";
    private AADAuthenticationProperties aadAuthProps;
    private ServiceEndpointsProperties serviceEndpointsProps;
    private OidcUserService oidcUserService;

    public AADOAuth2UserService(AADAuthenticationProperties aadAuthProps, ServiceEndpointsProperties serviceEndpointsProps) {
        this.aadAuthProps = aadAuthProps;
        this.serviceEndpointsProps = serviceEndpointsProps;
        this.oidcUserService = new OidcUserService();
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        Set<GrantedAuthority> mappedAuthorities;
        OidcUser oidcUser = this.oidcUserService.loadUser(userRequest);
        try {
            ClientRegistration registration = userRequest.getClientRegistration();
            AzureADGraphClient graphClient = new AzureADGraphClient(registration.getClientId(), registration.getClientSecret(), this.aadAuthProps, this.serviceEndpointsProps);
            String graphApiToken = graphClient.acquireTokenForGraphApi(userRequest.getIdToken().getTokenValue(), this.aadAuthProps.getTenantId()).accessToken();
            mappedAuthorities = graphClient.getGrantedAuthorities(graphApiToken);
        }
        catch (MalformedURLException e) {
            throw this.wrapException(INVALID_REQUEST, "Failed to acquire token for Graph API.", null, e);
        }
        catch (ServiceUnavailableException e) {
            throw this.wrapException(SERVER_ERROR, "Failed to acquire token for Graph API.", null, e);
        }
        catch (IOException e) {
            throw this.wrapException(SERVER_ERROR, "Failed to map group to authorities.", null, e);
        }
        catch (MsalServiceException e) {
            if (e.claims() != null && !e.claims().isEmpty()) {
                throw this.wrapException(CONDITIONAL_ACCESS_POLICY, "Handle conditional access policy", null, (Exception)((Object)e));
            }
            throw e;
        }
        String nameAttributeKey = Optional.of(userRequest).map(OAuth2UserRequest::getClientRegistration).map(ClientRegistration::getProviderDetails).map(ClientRegistration.ProviderDetails::getUserInfoEndpoint).map(ClientRegistration.ProviderDetails.UserInfoEndpoint::getUserNameAttributeName).filter(s -> !s.isEmpty()).orElse(DEFAULT_USERNAME_ATTR_NAME);
        return new DefaultOidcUser(mappedAuthorities, oidcUser.getIdToken(), nameAttributeKey);
    }

    private OAuth2AuthenticationException wrapException(String errorCode, String errDesc, String uri, Exception e) {
        OAuth2Error oAuth2Error = new OAuth2Error(errorCode, errDesc, uri);
        throw new OAuth2AuthenticationException(oAuth2Error, (Throwable)e);
    }
}

