/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloundfoundry.environment;

import com.microsoft.azure.spring.cloundfoundry.environment.VcapPojo;
import com.microsoft.azure.spring.cloundfoundry.environment.VcapResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Service;

@Service
@Configuration
public class VcapProcessor
implements EnvironmentPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(VcapProcessor.class);
    public static final String VCAP_SERVICES = "VCAP_SERVICES";
    public static final String LOG_VARIABLE = "COM_MICROSOFT_AZURE_CLOUDFOUNDRY_SERVICE_LOG";
    private static final String AZURE = "azure-";
    private static final String USER_PROVIDED = "user-provided";
    private static final String AZURE_SERVICE_BROKER_NAME = "azure-service-broker-name";
    private static final String AZURE_SERVICE_PLAN = "azure-service-plan";
    private static final String CREDENTIALS = "credentials";
    private static final String LABEL = "label";
    private static final String NAME = "name";
    private static final String PLAN = "plan";
    private static final String PROVIDER = "provider";
    private static final String SYSLOG_DRAIN_URL = "syslog_drain_url";
    private static final String TAGS = "tags";
    private static final String VOLUME_MOUNTS = "volume_mounts";
    private boolean logFlag = false;

    public void postProcessEnvironment(ConfigurableEnvironment confEnv, SpringApplication app) {
        Map environment = confEnv.getSystemEnvironment();
        String logValue = (String)environment.get(LOG_VARIABLE);
        if ("true".equals(logValue)) {
            this.logFlag = true;
        }
        this.log("VcapParser.postProcessEnvironment: Start");
        String vcapServices = (String)environment.get(VCAP_SERVICES);
        VcapResult result = this.parse(vcapServices);
        result.setLogFlag(this.logFlag);
        result.setConfEnv(confEnv);
        result.populateProperties();
        this.log("VcapParser.postProcessEnvironment: End");
    }

    public VcapResult parse(String vcapServices) {
        VcapResult result = new VcapResult();
        ArrayList<VcapPojo> results = new ArrayList<VcapPojo>();
        this.log("VcapParser.parse:  vcapServices = " + vcapServices);
        if (vcapServices != null) {
            try {
                JSONObject json = new JSONObject(vcapServices);
                JSONArray names = json.names();
                if (names != null) {
                    for (int i = 0; i < names.length(); ++i) {
                        String name = (String)names.get(i);
                        if (!name.startsWith(AZURE) && !USER_PROVIDED.equals(name)) continue;
                        JSONArray azureService = json.getJSONArray(name);
                        int numElements = azureService.length();
                        for (int index = 0; index < numElements; ++index) {
                            VcapPojo pojo = this.parseService(name, azureService, vcapServices, index);
                            if (pojo == null) continue;
                            results.add(pojo);
                        }
                    }
                }
            }
            catch (JSONException e) {
                LOGGER.error("Error parsing " + vcapServices, (Throwable)e);
            }
        }
        result.setPojos(results.toArray(new VcapPojo[results.size()]));
        return result;
    }

    private VcapPojo parseService(String serviceBrokerName, JSONArray azureService, String vCapServices, int index) {
        VcapPojo result = new VcapPojo();
        try {
            JSONObject service = azureService.getJSONObject(index);
            result.setLabel(this.parseString(service, LABEL));
            result.setProvider(this.parseString(service, PROVIDER));
            result.setServiceInstanceName(this.parseString(service, NAME));
            result.setSyslogDrainUrl(this.parseString(service, SYSLOG_DRAIN_URL));
            result.setTags(this.parseStringArray(service.getJSONArray(TAGS)));
            result.setVolumeMounts(this.parseStringArray(service.getJSONArray(VOLUME_MOUNTS)));
            JSONObject credObject = service.getJSONObject(CREDENTIALS);
            if (USER_PROVIDED.equals(serviceBrokerName)) {
                if (credObject == null) {
                    return null;
                }
                HashMap<String, String> credentials = new HashMap<String, String>();
                this.parseMap(credObject, credentials);
                String userServiceBrokerName = credentials.remove(AZURE_SERVICE_BROKER_NAME);
                if (userServiceBrokerName == null) {
                    return null;
                }
                result.setServiceBrokerName(userServiceBrokerName);
                String userServicePlan = credentials.remove(AZURE_SERVICE_PLAN);
                result.setServicePlan(userServicePlan);
                result.setCredentials(credentials);
            } else {
                result.setServiceBrokerName(serviceBrokerName);
                result.setServicePlan(this.parseString(service, PLAN));
                if (credObject == null) {
                    LOGGER.error("Found " + serviceBrokerName + ", but missing " + CREDENTIALS + " : " + vCapServices);
                } else {
                    this.parseMap(credObject, result.getCredentials());
                }
            }
        }
        catch (JSONException e) {
            LOGGER.error("Found " + serviceBrokerName + ", but missing " + CREDENTIALS + " : " + vCapServices, (Throwable)e);
        }
        return result;
    }

    private String[] parseStringArray(JSONArray strings) {
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < strings.length(); ++i) {
            try {
                results.add((String)strings.get(i));
                continue;
            }
            catch (JSONException e) {
                LOGGER.error("Error parsing " + strings, (Throwable)e);
            }
        }
        return results.toArray(new String[results.size()]);
    }

    private void parseMap(JSONObject mapObject, Map<String, String> target) {
        JSONArray keys = mapObject.names();
        for (int i = 0; i < keys.length(); ++i) {
            try {
                String key = (String)keys.get(i);
                String value = mapObject.getString(key);
                target.put(key, value);
                continue;
            }
            catch (JSONException e) {
                LOGGER.error("Error parsing " + mapObject, (Throwable)e);
            }
        }
    }

    private String parseString(JSONObject service, String key) {
        String result = null;
        try {
            if (!service.isNull(key)) {
                result = service.getString(key);
            }
        }
        catch (JSONException e) {
            LOGGER.error("Error parsing " + service, (Throwable)e);
        }
        return result;
    }

    private void log(String msg) {
        if (this.logFlag) {
            LOGGER.info(msg);
        }
    }
}

