/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import java.io.IOException;
import java.util.List;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class YamlFileApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final String SERVICE_ENDPOINTS_YAML = "classpath:serviceEndpoints.yml";

    private List<PropertySource<?>> yamlPropertySourceLoad(ConfigurableApplicationContext context) {
        List serviceEndpoints;
        Resource resource = context.getResource(SERVICE_ENDPOINTS_YAML);
        YamlPropertySourceLoader sourceLoader = new YamlPropertySourceLoader();
        try {
            serviceEndpoints = sourceLoader.load("serviceEndpoints", resource);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load the azure service endpoints configuration", e);
        }
        if (serviceEndpoints.size() != 1) {
            throw new IllegalStateException("There must be only 1 azure service endpoints configuration in classpath");
        }
        return serviceEndpoints;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        List<PropertySource<?>> serviceEndpoints = this.yamlPropertySourceLoad(applicationContext);
        applicationContext.getEnvironment().getPropertySources().addFirst(serviceEndpoints.get(0));
    }
}

