/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import java.time.Duration;
import java.util.Locale;

public final class SessionHandlerOptions {
    private static final boolean DEFAULT_AUTO_COMPLETE = true;
    private static final int DEFAULT_MAX_CONCURRENT_SESSIONS = 1;
    private static final int DEFAULT_MAX_CONCURRENT_CALLS_PER_SESSION = 1;
    private static final int DEFAULT_MAX_RENEW_TIME_MINUTES = 5;
    private boolean autoComplete;
    private Duration maxAutoRenewDuration;
    private int maxConcurrentSessions;
    private int maxConcurrentCallsPerSession;

    public SessionHandlerOptions() {
        this(1, true, Duration.ofMinutes(5L));
    }

    public SessionHandlerOptions(int maxConcurrentSessions, boolean autoComplete, Duration maxAutoRenewDuration) {
        this(maxConcurrentSessions, 1, autoComplete, maxAutoRenewDuration);
    }

    public SessionHandlerOptions(int maxConcurrentSessions, int maxConcurrentCallsPerSession, boolean autoComplete, Duration maxAutoRenewDuration) {
        this.maxConcurrentSessions = maxConcurrentSessions;
        this.maxConcurrentCallsPerSession = maxConcurrentCallsPerSession;
        this.autoComplete = autoComplete;
        this.maxAutoRenewDuration = maxAutoRenewDuration;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public int getMaxConcurrentSessions() {
        return this.maxConcurrentSessions;
    }

    public int getMaxConcurrentCallsPerSession() {
        return this.maxConcurrentCallsPerSession;
    }

    public Duration getMaxAutoRenewDuration() {
        return this.maxAutoRenewDuration;
    }

    public String toString() {
        return String.format(Locale.US, "SessionHandlerOptions - AutoComplete:%s, MaxConcurrentSessions:%s, MaxConcurretnCallsPerSession:%s, MaxAutoRenewDuration:%s", this.autoComplete, this.maxConcurrentSessions, this.maxConcurrentCallsPerSession, this.maxAutoRenewDuration);
    }
}

