/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import java.time.Duration;
import java.util.Locale;

public final class MessageHandlerOptions {
    private static final boolean DEFAULT_AUTO_COMPLETE = true;
    private static final int DEFAULT_MAX_CONCURRENT_CALLS = 1;
    private static final int DEFAULT_MAX_RENEW_TIME_MINUTES = 5;
    private boolean autoComplete;
    private Duration maxAutoRenewDuration;
    private int maxConcurrentCalls;

    public MessageHandlerOptions() {
        this(1, true, Duration.ofMinutes(5L));
    }

    public MessageHandlerOptions(int maxConcurrentCalls, boolean autoComplete, Duration maxAutoRenewDuration) {
        this.autoComplete = autoComplete;
        this.maxAutoRenewDuration = maxAutoRenewDuration;
        this.maxConcurrentCalls = maxConcurrentCalls;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public int getMaxConcurrentCalls() {
        return this.maxConcurrentCalls;
    }

    public Duration getMaxAutoRenewDuration() {
        return this.maxAutoRenewDuration;
    }

    public String toString() {
        return String.format(Locale.US, "MessageHandlerOptions - AutoComplete:%s, MaxConcurrentCalls:%s, MaxAutoRenewDuration:%s", this.autoComplete, this.maxConcurrentCalls, this.maxAutoRenewDuration);
    }
}

