/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.AbstractElement;

public class XmlUtils {
    public static String getChildValue(Element element, String attribute) {
        Element child = element.element(attribute);
        return child == null ? null : child.getText();
    }

    public static String prettyPrintElementNoNamespace(Element node) {
        XmlUtils.removeAllNamespaces(node);
        try {
            StringWriter out = new StringWriter();
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setSuppressDeclaration(true);
            format.setIndent("    ");
            format.setPadText(false);
            XMLWriter writer = new XMLWriter((Writer)out, format);
            writer.write(node);
            writer.flush();
            return StringUtils.stripStart((String)out.toString(), null);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while generating textual representation: " + e.getMessage());
        }
    }

    public static void trimTextBeforeEnd(Element parent, Node target) {
        List children = parent.content();
        int index = children.indexOf(target);
        int pos = index - 1;
        while (pos >= 0 && ((Node)children.get(pos)).getNodeType() == 3) {
            Node textNode = (Node)children.get(pos--);
            textNode.setText(StringUtils.stripEnd((String)textNode.getText(), null));
            if (!StringUtils.isNotBlank((CharSequence)textNode.getText())) continue;
            break;
        }
        int size = children.size();
        pos = index + 1;
        while (pos < size && ((Node)children.get(pos)).getNodeType() == 3) {
            Node textNode = (Node)children.get(pos++);
            textNode.setText(StringUtils.stripStart((String)textNode.getText(), null));
            if (!StringUtils.isNotBlank((CharSequence)textNode.getText())) continue;
            break;
        }
    }

    private static void setNamespace(Element element, Namespace nameSpace) {
        if (element instanceof AbstractElement) {
            ((AbstractElement)element).setNamespace(nameSpace);
        }
        for (Element child : element.elements()) {
            XmlUtils.setNamespace(child, nameSpace);
        }
    }

    public static void addDomWithValueList(Element element, String attribute, String subAttribute, List<String> values) {
        if (values != null && !values.isEmpty()) {
            DOMElement resultNode = new DOMElement(attribute);
            for (String value : values) {
                XmlUtils.addDomWithKeyValue((Element)resultNode, subAttribute, value);
            }
            element.add((Element)resultNode);
        }
    }

    public static void addDomWithKeyValue(Element node, String key, Object value) {
        DOMElement newNode = new DOMElement(key);
        if (value != null) {
            newNode.setText(value.toString());
        }
        node.add((Element)newNode);
    }

    public static void removeAllNamespaces(Element ele) {
        XmlUtils.setNamespace(ele, Namespace.NO_NAMESPACE);
        XmlUtils.removeNamespaces(ele.content());
    }

    private static void setNamespaces(List l, Namespace ns) {
        for (Object o : l) {
            Node n = (Node)o;
            if (n.getNodeType() == 2) {
                ((Attribute)n).setNamespace(ns);
            }
            if (n.getNodeType() != 1) continue;
            XmlUtils.setNamespaces((Element)n, ns);
        }
    }

    private static void removeNamespaces(List l) {
        XmlUtils.setNamespaces(l, Namespace.NO_NAMESPACE);
    }

    private static void setNamespaces(Element elem, Namespace ns) {
        XmlUtils.setNamespace(elem, ns);
        XmlUtils.setNamespaces(elem.content(), ns);
    }

    private XmlUtils() {
    }
}

