/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: AdminNavTreeFilter.java 1443 2010-09-20 08:50:49Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.2.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/AdminNavTreeFilter.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin;

import javax.swing.tree.TreeModel;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.tree.TreeFilter;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

/**
 * Implementation of admin navigation tree filter.
 * 
 * Pour l'instant, le filter regarde principalement si le getName de l'intité
 * en question "contient" le {@link #filterString}.
 * 
 * Mais on pourrait matcher sur autre chose, description ...
 * 
 * @author chatellier
 * @version $Revision: 1443 $
 * 
 * Last update : $Date: 2010-09-20 10:50:49 +0200 (lun., 20 sept. 2010) $
 * By : $Author: chatellier $
 */
public class AdminNavTreeFilter implements TreeFilter {

    static private final Log log = LogFactory.getLog(AdminNavTreeFilter.class);

    protected String filterString;

    public AdminNavTreeFilter(String filterString) {
        this.filterString = filterString.toLowerCase();
    }

    /*
     * @see org.nuiton.widget.tree.TreeFilter#include(javax.swing.tree.TreeModel, java.lang.Object)
     */
    @Override
    public boolean include(TreeModel model, Object node) {

        // empty filter, no filtering
        if (StringUtils.isEmpty(filterString)) {
            return true;
        }

        // filter real user object
        if (log.isInfoEnabled()) {
            log.info("Todo filter string : " + filterString + " on " + node);
        }

        boolean result = true;
        VradiTreeNode vradiNode = (VradiTreeNode)node;
        String wikittyId = vradiNode.getId();
        Class<?> nodeType = vradiNode.getInternalClass();
        
        // si c'est un noeaud intermediaire, on l'affiche tout le temps
        if (vradiNode.isStringNode()) {
            result = true;
        }

        // les noeuds intermédiaires (filtres si un des sous neuds match)
        /*else if (bean instanceof Collection<?>) {
            result = false;
            for (int i = 0 ; i < ntNode.getChildCount() && result == false; i++) {
                NavigationNode<?> child = ntNode.getChildAt(i);
                result = include(model, child);
            }
        }*/

        // un client (si son nom match ou ses clients)
        else if (nodeType.equals(Client.class)) {
            Client client = VradiService.getWikittyProxy().restore(Client.class, wikittyId);
            if (!client.getName().toLowerCase().contains(filterString)) {
                result = false;
                
                for (int i = 0 ; i < vradiNode.getChildCount() && result == false; i++) {
                    VradiTreeNode child = vradiNode.getChildAt(i);
                    result = include(model, child);
                }
            }
        }

        // un utilisateur (filtre s'il match ou son client match)
        else if (nodeType.equals(User.class)) {
            User user = VradiService.getWikittyProxy().restore(User.class, wikittyId);
            if (!user.getName().toLowerCase().contains(filterString)) {
                result = false;
            }

            VradiTreeNode clientNode = vradiNode.getParent().getParent();
            
            // cas ou le parent est un client
            if (clientNode.getInternalClass().equals(Client.class)) {
                Client client = VradiService.getWikittyProxy().restore(Client.class, wikittyId);
                if (client.getName().toLowerCase().contains(filterString)) {
                    result = true;
                }
            }
            // cas ou le parent est un group
            else if (clientNode.getInternalClass().equals(Group.class)) {
                Group group = VradiService.getWikittyProxy().restore(Group.class, wikittyId);
                if (group.getName().toLowerCase().contains(filterString)) {
                    result = true;
                }
            }
        }

        // group
        else if (nodeType.equals(Group.class)) {
            Group group = VradiService.getWikittyProxy().restore(Group.class, wikittyId);
            
            if (!group.getName().toLowerCase().contains(filterString)) {
                result = false;
                
                for (int i = 0 ; i < vradiNode.getChildCount() && result == false; i++) {
                    VradiTreeNode child = vradiNode.getChildAt(i);
                    result = include(model, child);
                }
            }
        }

        // un formulaire (filtre sur son nom seulement)
        else if (nodeType.equals(WikittyExtension.class)) {
            WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
            WikittyExtension form = wikittyProxy.restoreExtension(wikittyId);
            //log.info("form.getObjet()" + form.getObjet());
            if (!form.getName().toLowerCase().contains(filterString)) {
                result = false;
            }
        }
        
        // flux xml
        else if (nodeType.equals(XmlStream.class)) {
            XmlStream xmlStream = VradiService.getWikittyProxy().restore(XmlStream.class, wikittyId);
            
            if (!xmlStream.getName().toLowerCase().contains(filterString)) {
                result = false;
            }
        }
        
        
        return result;
    }

}
