/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomSerializer {
    protected CleanerProperties props;
    protected boolean escapeXml = true;

    public DomSerializer(CleanerProperties props, boolean escapeXml) {
        this.props = props;
        this.escapeXml = escapeXml;
    }

    public DomSerializer(CleanerProperties props) {
        this(props, true);
    }

    public Document createDOM(TagNode rootNode) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = factory.newDocumentBuilder().newDocument();
        Element rootElement = document.createElement(rootNode.getName());
        document.appendChild(rootElement);
        this.createSubnodes(document, rootElement, rootNode.getChildren());
        return document;
    }

    private void createSubnodes(Document document, Element element, List tagChildren) {
        if (tagChildren != null) {
            Iterator it = tagChildren.iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (item instanceof CommentToken) {
                    CommentToken commentToken = (CommentToken)item;
                    Comment comment = document.createComment(commentToken.getContent());
                    element.appendChild(comment);
                    continue;
                }
                if (item instanceof ContentToken) {
                    boolean specialCase;
                    String nodeName = element.getNodeName();
                    ContentToken contentToken = (ContentToken)item;
                    String content = contentToken.getContent();
                    boolean bl = specialCase = this.props.isUseCdataForScriptAndStyle() && ("script".equalsIgnoreCase(nodeName) || "style".equalsIgnoreCase(nodeName));
                    if (this.escapeXml && !specialCase) {
                        content = Utils.escapeXml(content, this.props, true);
                    }
                    element.appendChild(specialCase ? document.createCDATASection(content) : document.createTextNode(content));
                    continue;
                }
                if (item instanceof TagNode) {
                    TagNode subTagNode = (TagNode)item;
                    Element subelement = document.createElement(subTagNode.getName());
                    Map attributes = subTagNode.getAttributes();
                    Iterator entryIterator = attributes.entrySet().iterator();
                    while (entryIterator.hasNext()) {
                        Map.Entry entry = entryIterator.next();
                        String attrName = (String)entry.getKey();
                        String attrValue = (String)entry.getValue();
                        if (this.escapeXml) {
                            attrValue = Utils.escapeXml(attrValue, this.props, true);
                        }
                        subelement.setAttribute(attrName, attrValue);
                    }
                    this.createSubnodes(document, subelement, subTagNode.getChildren());
                    element.appendChild(subelement);
                    continue;
                }
                if (!(item instanceof List)) continue;
                List sublist = (List)item;
                this.createSubnodes(document, element, sublist);
            }
        }
    }
}

